/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.persistence.util;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.persistence.PersistenceHelper;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.persistence.model.PersistenceMappings;
import com.intellij.persistence.model.PersistencePackage;
import com.intellij.persistence.model.PersistentAttribute;
import com.intellij.persistence.model.PersistentEmbeddedAttribute;
import com.intellij.persistence.model.PersistentEntityBase;
import com.intellij.persistence.model.PersistentObject;
import com.intellij.persistence.model.PersistentRelationshipAttribute;
import com.intellij.persistence.model.TableInfoProvider;
import com.intellij.persistence.roles.PersistenceClassRole;
import com.intellij.persistence.roles.PersistenceClassRoleEnum;
import com.intellij.persistence.roles.PersistenceRoleHolder;
import com.intellij.persistence.util.JavaContainerType;
import com.intellij.persistence.util.JavaTypeInfo;
import com.intellij.persistence.util.PersistenceModelBrowser;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.ExecutorsQuery;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.QueryExecutor;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericValue;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PersistenceCommonUtil {
    private static final Key<CachedValue<List<PersistenceFacet>>> MODULE_PERSISTENCE_FACETS = Key.create((String)"MODULE_PERSISTENCE_FACETS");

    private PersistenceCommonUtil() {
    }

    @NotNull
    public static List<PersistenceFacet> getAllPersistenceFacets(@NotNull Project project) {
        if (project == null) {
            PersistenceCommonUtil.$$$reportNull$$$0(0);
        }
        List<PersistenceFacet> result = Collections.emptyList();
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            List<PersistenceFacet> facets = PersistenceCommonUtil.getAllPersistenceFacets(module);
            if (facets.isEmpty()) continue;
            if (result.isEmpty()) {
                result = new ArrayList<PersistenceFacet>(facets.size());
            }
            result.addAll(facets);
        }
        List<PersistenceFacet> list = result;
        if (list == null) {
            PersistenceCommonUtil.$$$reportNull$$$0(1);
        }
        return list;
    }

    @NotNull
    public static List<PersistenceFacet> getAllPersistenceFacets(@NotNull Module module) {
        if (module == null) {
            PersistenceCommonUtil.$$$reportNull$$$0(2);
        }
        List<PersistenceFacet> result = Collections.emptyList();
        for (Facet facet : FacetManager.getInstance((Module)module).getAllFacets()) {
            if (!(facet instanceof PersistenceFacet)) continue;
            if (result.isEmpty()) {
                result = new ArrayList<PersistenceFacet>();
            }
            result.add((PersistenceFacet)facet);
        }
        List<PersistenceFacet> list = result;
        if (list == null) {
            PersistenceCommonUtil.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    public static List<PersistenceFacet> getAllPersistenceFacetsWithDependencies(@NotNull Module module) {
        if (module == null) {
            PersistenceCommonUtil.$$$reportNull$$$0(4);
        }
        if (module.isDisposed()) {
            List<PersistenceFacet> list = Collections.emptyList();
            if (list == null) {
                PersistenceCommonUtil.$$$reportNull$$$0(5);
            }
            return list;
        }
        CachedValue cachedValue = (CachedValue)module.getUserData(MODULE_PERSISTENCE_FACETS);
        if (cachedValue == null) {
            cachedValue = CachedValuesManager.getManager((Project)module.getProject()).createCachedValue(() -> {
                if (module == null) {
                    PersistenceCommonUtil.$$$reportNull$$$0(17);
                }
                THashSet modules = new THashSet();
                ContainerUtil.addAll((Collection)modules, (Object[])JamCommonUtil.getAllDependentModules((Module)module));
                ContainerUtil.addAll((Collection)modules, (Object[])JamCommonUtil.getAllModuleDependencies((Module)module));
                THashSet facets = new THashSet();
                for (Module depModule : modules) {
                    facets.addAll(PersistenceCommonUtil.getAllPersistenceFacets(depModule));
                }
                return new CachedValueProvider.Result(new ArrayList(facets), new Object[]{ProjectRootManager.getInstance((Project)module.getProject())});
            }, false);
            module.putUserData(MODULE_PERSISTENCE_FACETS, (Object)cachedValue);
        }
        List list = (List)cachedValue.getValue();
        if (list == null) {
            PersistenceCommonUtil.$$$reportNull$$$0(6);
        }
        return list;
    }

    public static PersistenceModelBrowser createSameUnitsModelBrowser(@Nullable PsiElement sourceElement) {
        PsiClass sourceClass;
        Set unitSet = sourceElement == null || (sourceClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)sourceElement, PsiClass.class, (boolean)false)) == null ? null : (Set)PersistenceCommonUtil.getAllPersistenceUnits(sourceClass, new THashSet());
        return PersistenceCommonUtil.createUnitsAndTypeMapper(unitSet);
    }

    public static PersistenceModelBrowser createSameUnitsModelBrowser(@Nullable DomElement sourceDom) {
        DomElement rootElement;
        THashSet unitSet = sourceDom == null || !((rootElement = DomUtil.getFileElement((DomElement)sourceDom).getRootElement()) instanceof PersistenceMappings) ? null : new THashSet(PersistenceHelper.getHelper().getSharedModelBrowser().getPersistenceUnits((PersistenceMappings)rootElement));
        return PersistenceCommonUtil.createUnitsAndTypeMapper(unitSet);
    }

    public static PersistenceModelBrowser createUnitsAndTypeMapper(@Nullable Set<PersistencePackage> unitSet) {
        return PersistenceHelper.getHelper().createModelBrowser().setRoleFilter((Condition<? super PersistenceClassRole>)((Condition)role -> {
            PersistentObject object = role.getPersistentObject();
            PersistenceClassRoleEnum roleType = role.getType();
            return roleType != PersistenceClassRoleEnum.ENTITY_LISTENER && object != null && (unitSet == null || unitSet.contains(role.getPersistenceUnit()));
        }));
    }

    public static PersistenceModelBrowser createFacetAndUnitModelBrowser(PersistenceFacet facet, PersistencePackage unit, @Nullable PersistenceClassRoleEnum type) {
        return PersistenceHelper.getHelper().createModelBrowser().setRoleFilter((Condition<? super PersistenceClassRole>)((Condition)role -> {
            PersistentObject object = role.getPersistentObject();
            return !(object == null || type != null && role.getType() != type || unit != null && !unit.equals(role.getPersistenceUnit()) || facet != null && !facet.equals(role.getFacet()));
        }));
    }

    @Nullable
    public static PsiType getTargetEntityType(PsiMember psiMember) {
        return PersistenceCommonUtil.getTargetEntityType(PropertyUtilBase.getPropertyType((PsiMember)psiMember));
    }

    @Nullable
    public static PsiType getTargetEntityType(PsiType type) {
        return PersistenceCommonUtil.getTypeInfo(type).getValueType();
    }

    public static <T extends Collection<PersistencePackage>> T getAllPersistenceUnits(@Nullable PsiClass sourceClass, @NotNull T result) {
        if (result == null) {
            PersistenceCommonUtil.$$$reportNull$$$0(7);
        }
        for (PersistenceClassRole role : PersistenceCommonUtil.getPersistenceRoles(sourceClass)) {
            ContainerUtil.addIfNotNull(result, (Object)role.getPersistenceUnit());
        }
        return result;
    }

    @NotNull
    public static <V extends PersistenceMappings> Collection<V> getDomEntityMappings(Class<V> mappingsClass, PersistencePackage unit, PersistenceFacet facet) {
        THashSet result = new THashSet();
        for (PersistenceMappings persistenceMappings : facet.getDefaultEntityMappings(unit)) {
            if (!ReflectionUtil.isAssignable(mappingsClass, persistenceMappings.getClass())) continue;
            result.add((Object)persistenceMappings);
        }
        for (GenericValue genericValue : unit.getModelHelper().getMappingFiles(mappingsClass)) {
            ContainerUtil.addIfNotNull((Collection)result, (Object)genericValue.getValue());
        }
        THashSet tHashSet = result;
        if (tHashSet == null) {
            PersistenceCommonUtil.$$$reportNull$$$0(8);
        }
        return tHashSet;
    }

    public static boolean isSameTable(TableInfoProvider table1, TableInfoProvider table2) {
        if (table1 == null || table2 == null) {
            return false;
        }
        String name1 = (String)table1.getTableName().getValue();
        return StringUtil.isNotEmpty((String)name1) && Comparing.equal((String)name1, (String)((String)table2.getTableName().getValue())) && Comparing.equal((String)((String)table1.getSchema().getValue()), (String)((String)table2.getSchema().getValue())) && Comparing.equal((String)((String)table1.getCatalog().getValue()), (String)((String)table2.getCatalog().getValue()));
    }

    public static String getUniqueId(PsiElement psiElement) {
        VirtualFile virtualFile = psiElement == null ? null : PsiUtilBase.getVirtualFile((PsiElement)psiElement);
        return virtualFile == null ? "" : virtualFile.getUrl();
    }

    public static String getMultiplicityString(boolean optional, boolean many) {
        String first = optional ? "0" : "1";
        String last = many ? "*" : "1";
        return first.equals(last) ? first : first + ".." + last;
    }

    public static <T, V extends Collection<T>> V mapPersistenceRoles(V result, Project project, PersistenceFacet facet, PersistencePackage unit, Function<? super PersistenceClassRole, ? extends T> mapper) {
        for (PersistenceClassRole role : PersistenceCommonUtil.getPersistenceRoles(project)) {
            if (facet != null && facet != role.getFacet() || unit != null && unit != role.getPersistenceUnit()) continue;
            ContainerUtil.addIfNotNull(result, (Object)mapper.fun((Object)role));
        }
        return result;
    }

    public static boolean haveCorrespondingMultiplicity(PersistentRelationshipAttribute a1, PersistentRelationshipAttribute a2) {
        return a1.getAttributeModelHelper().getRelationshipType().corresponds(a2.getAttributeModelHelper().getRelationshipType());
    }

    @NotNull
    public static JavaTypeInfo getTypeInfo(PsiType type) {
        JavaTypeInfo javaTypeInfo = PersistenceCommonUtil.getTypeInfo(type, null);
        if (javaTypeInfo == null) {
            PersistenceCommonUtil.$$$reportNull$$$0(9);
        }
        return javaTypeInfo;
    }

    @NotNull
    public static JavaTypeInfo getTypeInfo(PsiType type, @Nullable PsiClass convertClass) {
        PsiClass psiClass;
        if (type instanceof PsiArrayType) {
            JavaTypeInfo javaTypeInfo = new JavaTypeInfo(JavaContainerType.ARRAY, type, convertClass, ((PsiArrayType)type).getComponentType());
            if (javaTypeInfo == null) {
                PersistenceCommonUtil.$$$reportNull$$$0(10);
            }
            return javaTypeInfo;
        }
        PsiClassType.ClassResolveResult classResolveResult = type instanceof PsiClassType ? ((PsiClassType)type).resolveGenerics() : null;
        PsiClass psiClass2 = psiClass = classResolveResult == null ? null : classResolveResult.getElement();
        if (psiClass == null) {
            JavaTypeInfo javaTypeInfo = new JavaTypeInfo(null, type, convertClass, new PsiType[0]);
            if (javaTypeInfo == null) {
                PersistenceCommonUtil.$$$reportNull$$$0(11);
            }
            return javaTypeInfo;
        }
        PsiManager manager = psiClass.getManager();
        GlobalSearchScope scope = ProjectScope.getAllScope((Project)manager.getProject());
        for (JavaContainerType collectionType : JavaContainerType.values()) {
            PsiClass aClass;
            if (collectionType == JavaContainerType.ARRAY || (aClass = JavaPsiFacade.getInstance((Project)manager.getProject()).findClass(collectionType.getJavaBaseClassName(), scope)) == null || !manager.areElementsEquivalent((PsiElement)aClass, (PsiElement)psiClass) && !psiClass.isInheritor(aClass, true)) continue;
            PsiSubstitutor superClassSubstitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)aClass, (PsiClass)psiClass, (PsiSubstitutor)classResolveResult.getSubstitutor());
            JavaTypeInfo result = new JavaTypeInfo(collectionType, type, convertClass, (PsiType[])ArrayUtil.reverseArray((Object[])ContainerUtil.map2Array((Object[])aClass.getTypeParameters(), PsiType.class, (Function)((NullableFunction)psiTypeParameter -> superClassSubstitutor.substitute(psiTypeParameter)))));
            if (result.containerType == JavaContainerType.MAP && result.parameters.length != 2 || JavaContainerType.isCollection(result.containerType) && result.parameters.length != 1) {
                JavaTypeInfo javaTypeInfo = new JavaTypeInfo(null, type, new PsiType[0]);
                if (javaTypeInfo == null) {
                    PersistenceCommonUtil.$$$reportNull$$$0(12);
                }
                return javaTypeInfo;
            }
            JavaTypeInfo javaTypeInfo = result;
            if (javaTypeInfo == null) {
                PersistenceCommonUtil.$$$reportNull$$$0(13);
            }
            return javaTypeInfo;
        }
        JavaTypeInfo javaTypeInfo = new JavaTypeInfo(null, type, convertClass, new PsiType[0]);
        if (javaTypeInfo == null) {
            PersistenceCommonUtil.$$$reportNull$$$0(14);
        }
        return javaTypeInfo;
    }

    public static Query<PersistentObject> queryPersistentObjects(PersistenceMappings mappings) {
        return new ExecutorsQuery((Object)mappings, Collections.singletonList(new QueryExecutor<PersistentObject, PersistenceMappings>(){

            public boolean execute(@NotNull PersistenceMappings queryParameters, @NotNull Processor<? super PersistentObject> consumer) {
                if (queryParameters == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (consumer == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (!ContainerUtil.process(queryParameters.getModelHelper().getPersistentEntities(), consumer)) {
                    return false;
                }
                if (!ContainerUtil.process(queryParameters.getModelHelper().getPersistentSuperclasses(), consumer)) {
                    return false;
                }
                return ContainerUtil.process(queryParameters.getModelHelper().getPersistentEmbeddables(), consumer);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "queryParameters";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "consumer";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/persistence/util/PersistenceCommonUtil$1";
                objectArray[2] = "execute";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }));
    }

    @Nullable
    public static PsiClass getTargetClass(PersistentRelationshipAttribute attribute) {
        PsiType entityType;
        GenericValue<PsiClass> classValue = attribute.getTargetEntityClass();
        PsiClass targetClass = classValue.getStringValue() != null ? (PsiClass)classValue.getValue() : ((entityType = PersistenceCommonUtil.getTargetEntityType(attribute.getPsiMember())) instanceof PsiClassType ? ((PsiClassType)entityType).resolve() : null);
        return targetClass;
    }

    @Nullable
    public static PsiClass getTargetClass(PersistentEmbeddedAttribute attribute) {
        PsiType entityType;
        GenericValue<PsiClass> classValue = attribute.getTargetEmbeddableClass();
        PsiClass targetClass = classValue.getStringValue() != null ? (PsiClass)classValue.getValue() : ((entityType = PropertyUtilBase.getPropertyType((PsiMember)attribute.getPsiMember())) instanceof PsiClassType ? ((PsiClassType)entityType).resolve() : null);
        return targetClass;
    }

    @Nullable
    public static PsiType getPrimaryKeyClass(@NotNull PersistentEntityBase persistentObject, PersistenceModelBrowser browser) {
        if (persistentObject == null) {
            PersistenceCommonUtil.$$$reportNull$$$0(15);
        }
        ArrayList<PersistentAttribute> idAttrs = new ArrayList<PersistentAttribute>();
        for (PersistentObject object : browser.queryPersistentObjectHierarchy(persistentObject)) {
            if (!(object instanceof PersistentEntityBase)) continue;
            PsiClass idClass = (PsiClass)((PersistentEntityBase)object).getIdClassValue().getValue();
            if (idClass != null) {
                return JavaPsiFacade.getElementFactory((Project)idClass.getProject()).createType(idClass);
            }
            for (PersistentAttribute idAttr : object.getObjectModelHelper().getAttributes()) {
                if (!idAttr.getAttributeModelHelper().isIdAttribute()) continue;
                idAttrs.add(idAttr);
            }
        }
        return idAttrs.size() == 1 ? ((PersistentAttribute)idAttrs.get(0)).getPsiType() : null;
    }

    public static PersistenceClassRole[] getPersistenceRoles(PsiClass psiClass) {
        if (psiClass == null) {
            return PersistenceClassRole.EMPTY_ARRAY;
        }
        CommonProcessors.CollectProcessor collectProcessor = new CommonProcessors.CollectProcessor();
        PersistenceRoleHolder.getInstance(psiClass.getProject()).processAllRoles(psiClass, (Processor<PersistenceClassRole>)collectProcessor);
        return (PersistenceClassRole[])ContainerUtil.toArray((Collection)collectProcessor.getResults(), PersistenceClassRole.ARRAY_FACTORY);
    }

    public static PersistenceClassRole[] getPersistenceRoles(@NotNull Project project) {
        if (project == null) {
            PersistenceCommonUtil.$$$reportNull$$$0(16);
        }
        CommonProcessors.CollectProcessor collectProcessor = new CommonProcessors.CollectProcessor();
        PersistenceRoleHolder.getInstance(project).processAllRoles((Processor<PersistenceClassRole>)collectProcessor);
        return (PersistenceClassRole[])ContainerUtil.toArray((Collection)collectProcessor.getResults(), PersistenceClassRole.ARRAY_FACTORY);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/persistence/util/PersistenceCommonUtil";
                break;
            }
            case 2: 
            case 4: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "persistentObject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/persistence/util/PersistenceCommonUtil";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllPersistenceFacets";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllPersistenceFacetsWithDependencies";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDomEntityMappings";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAllPersistenceFacets";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getAllPersistenceFacetsWithDependencies";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getAllPersistenceUnits";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getPrimaryKeyClass";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getPersistenceRoles";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getAllPersistenceFacetsWithDependencies$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

