/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.seam.el;

import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.jsf.model.xml.FacesDomModel;
import com.intellij.jsf.model.xml.FacesDomModelManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.source.jsp.el.ElContextProviderEx;
import com.intellij.psi.impl.source.jsp.el.impl.CustomJsfVariableResolverProvider;
import com.intellij.psi.jsp.JspImplicitVariable;
import com.intellij.seam.jsf.JsfContextBeansUtils;
import java.util.ArrayList;
import java.util.Iterator;
import org.jetbrains.annotations.Nullable;

public class SeamELContextProvider
extends ElContextProviderEx {
    private final PsiElement myHost;

    public SeamELContextProvider(PsiElement host) {
        this.myHost = host;
    }

    @Nullable
    public Iterator<? extends PsiVariable> getTopLevelElVariables(@Nullable String nameHint) {
        ArrayList<JspImplicitVariable> allVars = new ArrayList<JspImplicitVariable>(JsfContextBeansUtils.getJspImplicitVariables(nameHint, this.myHost.getContainingFile()));
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)this.myHost.getContainingFile());
        if (module != null) {
            for (WebFacet webFacet : WebFacet.getInstances((Module)module)) {
                for (FacesDomModel facesDomModel : FacesDomModelManager.getInstance((Project)module.getProject()).getAllModels(webFacet)) {
                    String variableResolverClass = facesDomModel.getFacesConfig().getApplication().getVariableResolver().getStringValue();
                    if (StringUtil.isEmptyOrSpaces((String)variableResolverClass)) continue;
                    for (CustomJsfVariableResolverProvider provider : CustomJsfVariableResolverProvider.EP_NAME.getExtensionList()) {
                        if (!provider.acceptVariableResolver(variableResolverClass, module)) continue;
                        provider.addVars(allVars, module);
                    }
                }
            }
        }
        return allVars.iterator();
    }

    public boolean acceptsGetMethodForLastReference(PsiMethod getter) {
        return true;
    }

    public boolean acceptsSetMethodForLastReference(PsiMethod setter) {
        return false;
    }

    public boolean acceptsNonPropertyMethodForLastReference(PsiMethod method) {
        return !SeamELContextProvider.isObjectClassMethod(method);
    }

    private static boolean isObjectClassMethod(PsiMethod method) {
        return "java.lang.Object".equals(method.getContainingClass().getQualifiedName());
    }
}

