/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.seam.highlighting.jam;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.javaee.ejb.role.EjbClassRole;
import com.intellij.javaee.model.common.ejb.EnterpriseBean;
import com.intellij.javaee.model.common.ejb.EntityBean;
import com.intellij.javaee.model.common.ejb.SessionBean;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiType;
import com.intellij.seam.constants.SeamAnnotationsUtil;
import com.intellij.seam.highlighting.jam.SeamJamModelInspectionBase;
import com.intellij.seam.model.jam.SeamJamComponent;
import com.intellij.seam.model.xml.SeamDomModel;
import com.intellij.seam.model.xml.SeamDomModelManager;
import com.intellij.seam.resources.SeamInspectionBundle;
import com.intellij.seam.utils.SeamCommonUtils;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class SeamAnnotationsInconsistencyInspection
extends SeamJamModelInspectionBase {
    @Override
    protected void checkClass(PsiClass aClass, ProblemsHolder holder) {
        SeamJamComponent jamComponent = SeamCommonUtils.getSeamJamComponent(aClass);
        if (jamComponent != null) {
            this.checkSeamJamComponent(jamComponent, holder);
        } else if (!SeamCommonUtils.isAbstractSeamComponent(aClass) && !SeamAnnotationsInconsistencyInspection.isDefinedInXml(aClass)) {
            SeamAnnotationsInconsistencyInspection.checkClassContainsIllegalSeamAnnotations(aClass, holder);
        }
    }

    private static boolean isDefinedInXml(PsiClass aClass) {
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)aClass);
        if (module != null) {
            for (SeamDomModel seamDomModel : SeamDomModelManager.getInstance(aClass.getProject()).getAllModels(module)) {
                if (seamDomModel.getSeamComponents((PsiType)JavaPsiFacade.getInstance((Project)module.getProject()).getElementFactory().createType(aClass)).size() <= 0) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected void checkSeamJamComponent(SeamJamComponent seamClassRole, ProblemsHolder holder) {
        SeamAnnotationsInconsistencyInspection.checkBeans(seamClassRole, holder);
    }

    private static void checkBeans(SeamJamComponent seamClassRole, ProblemsHolder holder) {
        EjbClassRole[] ejbRoles;
        for (EjbClassRole ejbClassRole : ejbRoles = SeamCommonUtils.getEjbRoles(seamClassRole)) {
            EnterpriseBean bean = ejbClassRole.getEnterpriseBean();
            if (bean instanceof SessionBean) {
                if (SeamCommonUtils.isStateful((SessionBean)bean)) {
                    SeamAnnotationsInconsistencyInspection.checkInconsistency(seamClassRole, holder, SeamUnsupportedAnnotations.STATEFUL);
                    continue;
                }
                SeamAnnotationsInconsistencyInspection.checkInconsistency(seamClassRole, holder, SeamUnsupportedAnnotations.STATELESS);
                continue;
            }
            if (!(bean instanceof EntityBean)) continue;
            SeamAnnotationsInconsistencyInspection.checkInconsistency(seamClassRole, holder, SeamUnsupportedAnnotations.ENTITY);
        }
        if (ejbRoles.length == 0) {
            SeamAnnotationsInconsistencyInspection.checkInconsistency(seamClassRole, holder, SeamUnsupportedAnnotations.JAVA_BEAN);
        }
        SeamAnnotationsInconsistencyInspection.checkInconsistency(seamClassRole, holder, SeamUnsupportedAnnotations.SEAM_COMPONENT);
    }

    private static void checkInconsistency(SeamJamComponent seamComponent, ProblemsHolder holder, SeamUnsupportedAnnotations incorrectAnnotations) {
        PsiClass psiClass = seamComponent.getPsiElement();
        SeamAnnotationsInconsistencyInspection.checkAnnotation((PsiMember)psiClass, incorrectAnnotations, holder);
        for (PsiMethod psiMethod : psiClass.getMethods()) {
            SeamAnnotationsInconsistencyInspection.checkAnnotation((PsiMember)psiMethod, incorrectAnnotations, holder);
        }
        for (PsiMethod psiMethod : psiClass.getFields()) {
            SeamAnnotationsInconsistencyInspection.checkAnnotation((PsiMember)psiMethod, incorrectAnnotations, holder);
        }
    }

    private static void checkAnnotation(PsiMember psiMember, SeamUnsupportedAnnotations incorrectAnnotations, ProblemsHolder holder) {
        PsiModifierList modifierList = psiMember.getModifierList();
        if (modifierList != null) {
            PsiAnnotation[] annotations;
            for (PsiAnnotation annotation : annotations = modifierList.getAnnotations()) {
                String qualifiedName = annotation.getQualifiedName();
                if (!incorrectAnnotations.isUnsupported(qualifiedName)) continue;
                holder.registerProblem((PsiElement)annotation, SeamInspectionBundle.message("jam.annotation.not.allowed", StringUtil.getShortName((String)qualifiedName), incorrectAnnotations.getFullName()), new LocalQuickFix[0]);
            }
        }
    }

    private static void checkClassContainsIllegalSeamAnnotations(PsiClass psiClass, ProblemsHolder holder) {
        for (String seamAnnotation : SeamAnnotationsUtil.getAllSeamAnnotations()) {
            SeamAnnotationsInconsistencyInspection.checkAnnotation((PsiMember)psiClass, seamAnnotation, holder);
            for (PsiMethod psiMethod : psiClass.getMethods()) {
                SeamAnnotationsInconsistencyInspection.checkAnnotation((PsiMember)psiMethod, seamAnnotation, holder);
            }
            for (PsiMethod psiMethod : psiClass.getFields()) {
                SeamAnnotationsInconsistencyInspection.checkAnnotation((PsiMember)psiMethod, seamAnnotation, holder);
            }
        }
    }

    private static void checkAnnotation(PsiMember psiMember, String incorrectAnnotation, ProblemsHolder holder) {
        PsiModifierList modifierList = psiMember.getModifierList();
        if (modifierList != null) {
            PsiAnnotation[] annotations;
            for (PsiAnnotation annotation : annotations = modifierList.getAnnotations()) {
                String qualifiedName = annotation.getQualifiedName();
                if (!incorrectAnnotation.equals(qualifiedName)) continue;
                holder.registerProblem((PsiElement)annotation, SeamInspectionBundle.message("jam.name.annotation.must.be.defined.for.class", StringUtil.getShortName((String)qualifiedName)), new LocalQuickFix[0]);
            }
        }
    }

    @NotNull
    public String getDisplayName() {
        String string = SeamInspectionBundle.message("jam.annotation.inconsistency.inspection.name", new Object[0]);
        if (string == null) {
            SeamAnnotationsInconsistencyInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    @NonNls
    public String getShortName() {
        if ("SeamAnnotationsInconsistencyInspection" == null) {
            SeamAnnotationsInconsistencyInspection.$$$reportNull$$$0(1);
        }
        return "SeamAnnotationsInconsistencyInspection";
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            SeamAnnotationsInconsistencyInspection.$$$reportNull$$$0(2);
        }
        return highlightDisplayLevel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/seam/highlighting/jam/SeamAnnotationsInconsistencyInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static enum SeamUnsupportedAnnotations {
        STATELESS("Stateless Session Bean", "org.jboss.seam.annotations.Create", "org.jboss.seam.annotations.Destroy", "org.jboss.seam.annotations.Transactional", "org.jboss.seam.annotations.DataBinderClass", "org.jboss.seam.annotations.DataSelectorClass"),
        STATEFUL("Stateful Session Bean", "org.jboss.seam.annotations.Transactional", "org.jboss.seam.annotations.DataBinderClass", "org.jboss.seam.annotations.DataSelectorClass"),
        ENTITY("Entity Bean", "org.jboss.seam.annotations.JndiName", "org.jboss.seam.annotations.In", "org.jboss.seam.annotations.Out", "org.jboss.seam.annotations.Unwrap", "org.jboss.seam.annotations.Factory", "org.jboss.seam.annotations.Logger", "org.jboss.seam.annotations.web.RequestParameter", "org.jboss.seam.annotations.Create", "org.jboss.seam.annotations.Destroy", "org.jboss.seam.annotations.bpm.BeginTask", "org.jboss.seam.annotations.Begin", "org.jboss.seam.annotations.End", "org.jboss.seam.annotations.bpm.StartTask", "org.jboss.seam.annotations.bpm.ResumeProcess", "org.jboss.seam.annotations.bpm.CreateProcess", "org.jboss.seam.annotations.Transactional", "org.jboss.seam.annotations.datamodel.DataModel", "org.jboss.seam.annotations.datamodel.DataModelSelection", "org.jboss.seam.annotations.datamodel.DataModelSelectionIndex", "org.jboss.seam.annotations.DataBinderClass", "org.jboss.seam.annotations.DataSelectorClass"),
        JAVA_BEAN("Java Bean", "org.jboss.seam.annotations.JndiName"),
        SEAM_COMPONENT("Seam Component", "org.jboss.seam.annotations.Around", "org.jboss.seam.annotations.DataBinderClass", "org.jboss.seam.annotations.DataSelectorClass", "org.jboss.seam.annotations.Within");

        private final String myName;
        private final List<String> myUnsupportedAnnotations;

        private SeamUnsupportedAnnotations(String name, String ... annotations) {
            this.myName = name;
            this.myUnsupportedAnnotations = Arrays.asList(annotations);
        }

        public String getFullName() {
            return this.myName;
        }

        public boolean isUnsupported(String anno) {
            for (String s : this.myUnsupportedAnnotations) {
                if (!s.equals(anno)) continue;
                return true;
            }
            return false;
        }

        public String getName() {
            return this.myName;
        }
    }
}

