/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.seam.model.references;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.seam.model.jam.SeamJamComponent;
import com.intellij.seam.model.jam.SeamJamModel;
import com.intellij.seam.model.jam.context.SeamJamObserver;
import com.intellij.seam.model.references.BasicEventTypeReference;
import com.intellij.seam.model.xml.SeamDomModel;
import com.intellij.seam.model.xml.SeamDomModelManager;
import com.intellij.seam.model.xml.components.SeamEvent;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public abstract class SeamEventTypeReference<T extends PsiElement>
extends BasicEventTypeReference<T> {
    public SeamEventTypeReference(T element) {
        super(element);
    }

    @NotNull
    public Object[] getVariants() {
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)this.getElement());
        if (module != null) {
            ArrayList<String> eventTypes = new ArrayList<String>();
            for (SeamJamComponent seamJamComponent : SeamJamModel.getModel(module).getSeamComponents()) {
                for (SeamJamObserver seamJamObserver : seamJamComponent.getObservers()) {
                    ContainerUtil.addAll(eventTypes, (Object[])seamJamObserver.getEventTypes());
                }
            }
            for (SeamDomModel domModel : SeamDomModelManager.getInstance(module.getProject()).getAllModels(module)) {
                for (SeamEvent seamEvent : domModel.getEvents()) {
                    String value = seamEvent.getType().getStringValue();
                    if (StringUtil.isEmptyOrSpaces((String)value)) continue;
                    eventTypes.add(value);
                }
            }
            Object[] objectArray = ArrayUtil.toObjectArray(eventTypes);
            if (objectArray == null) {
                SeamEventTypeReference.$$$reportNull$$$0(0);
            }
            return objectArray;
        }
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            SeamEventTypeReference.$$$reportNull$$$0(1);
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/seam/model/references/SeamEventTypeReference", "getVariants"));
    }

    public static class SeamLiteralExpression
    extends SeamEventTypeReference<PsiLiteralExpression> {
        public SeamLiteralExpression(PsiLiteralExpression element) {
            super(element);
        }

        @Override
        protected String getEventType(PsiLiteralExpression psiElement) {
            return (String)psiElement.getValue();
        }
    }
}

