/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.seam.structure;

import com.intellij.ide.DeleteProvider;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.javaee.module.view.nodes.JavaeeNodeDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.seam.model.jam.SeamJamComponent;
import com.intellij.seam.resources.SeamBundle;
import com.intellij.seam.structure.SeamComponentNodeDescriptor;
import com.intellij.seam.structure.SeamDomModelNodeDescriptor;
import com.intellij.util.PlatformIcons;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SeamModuleLibrariesNodeDescriptor
extends JavaeeNodeDescriptor<Module> {
    private final List<? extends SeamJamComponent> myCompiledElements;
    private final List<? extends XmlFile> myModelFiles;

    public SeamModuleLibrariesNodeDescriptor(List<? extends SeamJamComponent> compiledElements, List<? extends XmlFile> modelFiles, Project project, NodeDescriptor parentDescriptor, Object parameters, Module element) {
        super(project, parentDescriptor, parameters, (Object)element);
        this.myCompiledElements = compiledElements;
        this.myModelFiles = modelFiles;
    }

    protected String getNewNodeText() {
        return SeamBundle.message("seam.j2ee.structure.module.libraries", new Object[0]);
    }

    protected DeleteProvider getDeleteProvider() {
        return super.getDeleteProvider();
    }

    @NotNull
    public JavaeeNodeDescriptor[] getChildren() {
        VirtualFile forJar;
        ArrayList<Object> nodes = new ArrayList<Object>();
        HashMap libs = new HashMap();
        HashMap modelLibs = new HashMap();
        ArrayList<SeamJamComponent> unknownLib = new ArrayList<SeamJamComponent>();
        for (SeamJamComponent seamJamComponent : this.myCompiledElements) {
            forJar = this.getJarFile(seamJamComponent.getPsiElement().getContainingFile().getVirtualFile());
            if (forJar != null) {
                if (libs.get(forJar) == null) {
                    libs.put(forJar, new ArrayList());
                }
                ((List)libs.get(forJar)).add(seamJamComponent);
                continue;
            }
            unknownLib.add(seamJamComponent);
        }
        for (XmlFile xmlFile : this.myModelFiles) {
            forJar = this.getJarFile(xmlFile.getVirtualFile());
            if (forJar == null) continue;
            if (modelLibs.get(forJar) == null) {
                modelLibs.put(forJar, new ArrayList());
            }
            ((List)modelLibs.get(forJar)).add(xmlFile);
        }
        for (VirtualFile virtualFile : libs.keySet()) {
            nodes.add((Object)new ModuleLibNodeDescriptor(this.getProject(), (NodeDescriptor)this, this.getParameters(), virtualFile, (List)libs.get(virtualFile), (List)modelLibs.get(virtualFile)));
        }
        for (SeamJamComponent seamJamComponent : unknownLib) {
            nodes.add((Object)new SeamComponentNodeDescriptor(seamJamComponent, this, this.getParameters()));
        }
        JavaeeNodeDescriptor[] javaeeNodeDescriptorArray = nodes.toArray(JavaeeNodeDescriptor.EMPTY_ARRAY);
        if (javaeeNodeDescriptorArray == null) {
            SeamModuleLibrariesNodeDescriptor.$$$reportNull$$$0(0);
        }
        return javaeeNodeDescriptorArray;
    }

    private VirtualFile getJarFile(VirtualFile file) {
        VirtualFile forJar = JarFileSystem.getInstance().getVirtualFileForJar(file);
        return forJar;
    }

    protected Icon getNewIcon() {
        return PlatformIcons.LIBRARY_ICON;
    }

    public int getWeight() {
        return 10000;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/seam/structure/SeamModuleLibrariesNodeDescriptor", "getChildren"));
    }

    private static class ModuleLibNodeDescriptor
    extends JavaeeNodeDescriptor<VirtualFile> {
        private final List<? extends SeamJamComponent> mySeamComponents;
        private final List<? extends XmlFile> myXmlFiles;

        private ModuleLibNodeDescriptor(Project project, NodeDescriptor parentDescriptor, Object parameters, VirtualFile element, @Nullable List<? extends SeamJamComponent> seamComponents, @Nullable List<? extends XmlFile> xmlFiles) {
            super(project, parentDescriptor, parameters, (Object)element);
            this.mySeamComponents = seamComponents;
            this.myXmlFiles = xmlFiles;
        }

        protected String getNewNodeText() {
            return ((VirtualFile)this.getElement()).getName();
        }

        @NotNull
        public JavaeeNodeDescriptor[] getChildren() {
            ArrayList<Object> nodes = new ArrayList<Object>();
            if (this.myXmlFiles != null) {
                for (XmlFile xmlFile : this.myXmlFiles) {
                    nodes.add((Object)new SeamDomModelNodeDescriptor(this.getProject(), (NodeDescriptor)this, this.getParameters(), xmlFile, JarFileSystem.getInstance().getJarRootForLocalFile((VirtualFile)this.getElement())));
                }
            }
            if (this.mySeamComponents != null) {
                for (SeamJamComponent seamJamComponent : this.mySeamComponents) {
                    nodes.add((Object)new SeamComponentNodeDescriptor(seamJamComponent, this, this.getParameters()));
                }
            }
            JavaeeNodeDescriptor[] javaeeNodeDescriptorArray = nodes.toArray(JavaeeNodeDescriptor.EMPTY_ARRAY);
            if (javaeeNodeDescriptorArray == null) {
                ModuleLibNodeDescriptor.$$$reportNull$$$0(0);
            }
            return javaeeNodeDescriptorArray;
        }

        protected Icon getNewIcon() {
            return ((VirtualFile)this.getElement()).getFileType().getIcon();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/seam/structure/SeamModuleLibrariesNodeDescriptor$ModuleLibNodeDescriptor", "getChildren"));
        }
    }
}

