/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.seam.utils;

import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.jsp.WebDirectoryUtil;
import com.intellij.psi.jsp.WebDirectoryElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.seam.model.jam.SeamJamComponent;
import com.intellij.seam.model.jam.SeamJamModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SeamConfigFileUtils {
    @NonNls
    public static final String CONFIG_DEFAULT_DIRECTORY = "WEB-INF";
    @NonNls
    public static final String CONFIG_RESOURCES_PATH = "META-INF/components.xml";
    @NonNls
    public static final String CONFIG_DEFAULT_PATH = "WEB-INF/components.xml";

    private SeamConfigFileUtils() {
    }

    public static Set<XmlFile> getConfigurationFiles(Module module) {
        HashSet<XmlFile> componentsFiles = new HashSet<XmlFile>();
        componentsFiles.addAll(SeamConfigFileUtils.getConfigsFromWebInf(module));
        componentsFiles.addAll(SeamConfigFileUtils.getConfigsFromMetaInf(module));
        componentsFiles.addAll(SeamConfigFileUtils.getConfigsFromResources(module));
        return componentsFiles;
    }

    public static List<XmlFile> getConfigsFromWebInf(Module module) {
        ArrayList<XmlFile> files = new ArrayList<XmlFile>();
        Collection webFacet = WebFacet.getInstances((Module)module);
        for (WebFacet facet : webFacet) {
            XmlFile xmlFile = SeamConfigFileUtils.getConfigsFromWebInf(facet);
            if (xmlFile == null) continue;
            files.add(xmlFile);
        }
        return files;
    }

    @Nullable
    public static XmlFile getConfigsFromWebInf(WebFacet webFacet) {
        return SeamConfigFileUtils.getWebDirectoryElementConfig(webFacet, CONFIG_DEFAULT_PATH);
    }

    @Nullable
    private static XmlFile getWebDirectoryElementConfig(@NotNull WebFacet webFacet, String relativePath) {
        PsiFile psiFile;
        Module module;
        WebDirectoryElement element;
        if (webFacet == null) {
            SeamConfigFileUtils.$$$reportNull$$$0(0);
        }
        if ((element = WebDirectoryUtil.getWebDirectoryUtil((Project)(module = webFacet.getModule()).getProject()).findWebDirectoryElementByPath(relativePath, webFacet)) != null && (psiFile = element.getOriginalFile()) instanceof XmlFile) {
            return (XmlFile)psiFile;
        }
        return null;
    }

    @NotNull
    public static List<XmlFile> getConfigsFromMetaInf(Module module) {
        PsiManager psiManager = PsiManager.getInstance((Project)module.getProject());
        ArrayList<XmlFile> resourceFiles = new ArrayList<XmlFile>();
        for (VirtualFile file : OrderEnumerator.orderEntries((Module)module).getAllLibrariesAndSdkClassesRoots()) {
            PsiFile psiFile;
            VirtualFile candidate = file.findFileByRelativePath(CONFIG_RESOURCES_PATH);
            if (candidate == null || !((psiFile = psiManager.findFile(candidate)) instanceof XmlFile)) continue;
            resourceFiles.add((XmlFile)psiFile);
        }
        ArrayList<XmlFile> arrayList = resourceFiles;
        if (arrayList == null) {
            SeamConfigFileUtils.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @NotNull
    public static List<XmlFile> getConfigsFromResources(Module module) {
        ArrayList<XmlFile> resourceFiles = new ArrayList<XmlFile>();
        HashSet<VirtualFile> directories = new HashSet<VirtualFile>();
        for (SeamJamComponent seamJamComponent : SeamJamModel.getModel(module).getSeamComponents(false)) {
            PsiDirectory psiDirectory;
            PsiFile containingFile = seamJamComponent.getContainingFile();
            if (containingFile == null || (psiDirectory = containingFile.getParent()) == null) continue;
            directories.add(psiDirectory.getVirtualFile());
        }
        PsiManager psiManager = PsiManager.getInstance((Project)module.getProject());
        for (VirtualFile directory : directories) {
            PsiFile psiFile;
            VirtualFile file = directory.findChild("components.xml");
            if (file == null || !((psiFile = psiManager.findFile(file)) instanceof XmlFile)) continue;
            resourceFiles.add((XmlFile)psiFile);
        }
        ArrayList<XmlFile> arrayList = resourceFiles;
        if (arrayList == null) {
            SeamConfigFileUtils.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "webFacet";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/seam/utils/SeamConfigFileUtils";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/seam/utils/SeamConfigFileUtils";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigsFromMetaInf";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigsFromResources";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getWebDirectoryElementConfig";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

