/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.seam.utils.beans;

import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.jsp.el.impl.ELResolveUtil;
import com.intellij.psi.jsp.el.ELExpression;
import com.intellij.psi.jsp.el.ELExpressionHolder;
import com.intellij.psi.jsp.el.ELSelectExpression;
import com.intellij.psi.jsp.el.ELVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.seam.model.xml.components.SeamDomFactory;
import com.intellij.seam.utils.SeamCommonUtils;
import com.intellij.seam.utils.beans.ContextVariable;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DomFactoryContextVariable
extends ContextVariable {
    private final SeamDomFactory myFactory;
    private final Set<ContextVariable> myVars;
    private final Module myModule;
    private static final Key<Boolean> IS_PROCESSING_VAR_TYPE = new Key("IS_PROCESSING_VAR_TYPE");

    public DomFactoryContextVariable(SeamDomFactory factory, String factoryName, Set<ContextVariable> vars, Module module) {
        super(factory, factoryName, (PsiType)PsiType.VOID);
        this.myFactory = factory;
        this.myVars = vars;
        this.myModule = module;
    }

    @Override
    @NotNull
    public PsiType getType() {
        PsiType type = SeamCommonUtils.getFactoryType(this.myFactory, this.myVars);
        PsiType psiType = type != null ? type : SeamCommonUtils.getObjectClassType(this.myModule.getProject());
        if (psiType == null) {
            DomFactoryContextVariable.$$$reportNull$$$0(0);
        }
        return psiType;
    }

    @Nullable
    public PsiType getELExpressionType() {
        XmlAttributeValue context = this.myFactory.getValue().getXmlAttributeValue();
        if (context == null || DomFactoryContextVariable.isProcessing((PsiElement)context)) {
            return null;
        }
        String value = this.myFactory.getValue().getStringValue();
        if (value != null && SeamCommonUtils.isElText(value)) {
            Ref injectionType = new Ref();
            DomFactoryContextVariable.setProcessing((PsiElement)context, true);
            InjectedLanguageManager.getInstance((Project)context.getProject()).enumerate((PsiElement)context, (injectedPsi, places) -> {
                ELExpression expression;
                PsiElement at = injectedPsi.findElementAt(injectedPsi.getTextLength() - 1);
                ELExpressionHolder holder = (ELExpressionHolder)PsiTreeUtil.getParentOfType((PsiElement)at, ELExpressionHolder.class);
                if (holder != null && (expression = (ELExpression)PsiTreeUtil.getChildOfType((PsiElement)holder, ELExpression.class)) != null && !DomFactoryContextVariable.isSelfReference(expression, this.getName())) {
                    injectionType.set((Object)ELResolveUtil.resolveContextAsType((ELExpression)expression));
                }
            });
            DomFactoryContextVariable.setProcessing((PsiElement)context, false);
            return (PsiType)injectionType.get();
        }
        return null;
    }

    private static void setProcessing(@NotNull PsiElement context, boolean b) {
        if (context == null) {
            DomFactoryContextVariable.$$$reportNull$$$0(1);
        }
        context.putUserData(IS_PROCESSING_VAR_TYPE, (Object)b);
    }

    private static boolean isProcessing(@NotNull PsiElement context) {
        Boolean isProcessing;
        if (context == null) {
            DomFactoryContextVariable.$$$reportNull$$$0(2);
        }
        return (isProcessing = (Boolean)context.getUserData(IS_PROCESSING_VAR_TYPE)) != null && isProcessing != false;
    }

    private static boolean isSelfReference(ELExpression expression, String myName) {
        if (expression == null) {
            return false;
        }
        if (expression.getText().equals(myName)) {
            return true;
        }
        PsiElement firstChild = expression.getFirstChild();
        ELVariable var = null;
        if (firstChild instanceof ELVariable) {
            var = (ELVariable)firstChild;
        }
        if (firstChild instanceof ELSelectExpression) {
            var = ((ELSelectExpression)firstChild).getField();
        }
        return var != null && var.getText().equals(myName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/seam/utils/beans/DomFactoryContextVariable";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/seam/utils/beans/DomFactoryContextVariable";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setProcessing";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isProcessing";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

