/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.descriptors.annotations;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.BuiltInAnnotationDescriptor;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.constants.AnnotationValue;
import org.jetbrains.kotlin.resolve.constants.ArrayValue;
import org.jetbrains.kotlin.resolve.constants.EnumValue;
import org.jetbrains.kotlin.resolve.constants.StringValue;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.Variance;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u00006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a&\u0010\b\u001a\u00020\t*\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\f2\b\b\u0002\u0010\u000e\u001a\u00020\f\u001a\f\u0010\u000f\u001a\u00020\u0010*\u00020\u0011H\u0002\u001a\n\u0010\u0012\u001a\u00020\u0010*\u00020\u0013\u001a\n\u0010\u0014\u001a\u00020\u0010*\u00020\u0013\u001a\n\u0010\u0015\u001a\u00020\u0010*\u00020\u0013\u001a\f\u0010\u0016\u001a\u00020\u0010*\u00020\u0011H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"DEPRECATED_LEVEL_NAME", "Lorg/jetbrains/kotlin/name/Name;", "DEPRECATED_MESSAGE_NAME", "DEPRECATED_REPLACE_WITH_NAME", "INLINE_ONLY_ANNOTATION_FQ_NAME", "Lorg/jetbrains/kotlin/name/FqName;", "REPLACE_WITH_EXPRESSION_NAME", "REPLACE_WITH_IMPORTS_NAME", "createDeprecatedAnnotation", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "message", "", "replaceWith", "level", "hasInlineOnlyAnnotation", "", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "isEffectivelyInlineOnly", "Lorg/jetbrains/kotlin/descriptors/MemberDescriptor;", "isInlineOnly", "isInlineOnlyOrReifiable", "isReifiable", "descriptors"})
public final class AnnotationUtilKt {
    private static final Name DEPRECATED_MESSAGE_NAME;
    private static final Name DEPRECATED_REPLACE_WITH_NAME;
    private static final Name DEPRECATED_LEVEL_NAME;
    private static final Name REPLACE_WITH_EXPRESSION_NAME;
    private static final Name REPLACE_WITH_IMPORTS_NAME;
    private static final FqName INLINE_ONLY_ANNOTATION_FQ_NAME;

    @NotNull
    public static final AnnotationDescriptor createDeprecatedAnnotation(@NotNull KotlinBuiltIns $receiver, @NotNull String message, @NotNull String replaceWith, @NotNull String level) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Intrinsics.checkParameterIsNotNull((Object)replaceWith, (String)"replaceWith");
        Intrinsics.checkParameterIsNotNull((Object)level, (String)"level");
        FqName fqName2 = KotlinBuiltIns.FQ_NAMES.replaceWith;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"KotlinBuiltIns.FQ_NAMES.replaceWith");
        BuiltInAnnotationDescriptor replaceWithAnnotation2 = new BuiltInAnnotationDescriptor($receiver, fqName2, MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)REPLACE_WITH_EXPRESSION_NAME, (Object)new StringValue(replaceWith)), TuplesKt.to((Object)REPLACE_WITH_IMPORTS_NAME, (Object)new ArrayValue(CollectionsKt.emptyList(), (Function1<? super ModuleDescriptor, ? extends KotlinType>)((Function1)new Function1<ModuleDescriptor, SimpleType>($receiver){
            final /* synthetic */ KotlinBuiltIns $this_createDeprecatedAnnotation;

            @NotNull
            public final SimpleType invoke(@NotNull ModuleDescriptor module) {
                Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
                SimpleType simpleType = module.getBuiltIns().getArrayType(Variance.INVARIANT, this.$this_createDeprecatedAnnotation.getStringType());
                Intrinsics.checkExpressionValueIsNotNull((Object)simpleType, (String)"module.builtIns.getArray\u2026ce.INVARIANT, stringType)");
                return simpleType;
            }
            {
                this.$this_createDeprecatedAnnotation = kotlinBuiltIns;
                super(1);
            }
        })))}));
        FqName fqName3 = KotlinBuiltIns.FQ_NAMES.deprecated;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName3, (String)"KotlinBuiltIns.FQ_NAMES.deprecated");
        Pair[] pairArray = new Pair[3];
        pairArray[0] = TuplesKt.to((Object)DEPRECATED_MESSAGE_NAME, (Object)new StringValue(message));
        pairArray[1] = TuplesKt.to((Object)DEPRECATED_REPLACE_WITH_NAME, (Object)new AnnotationValue(replaceWithAnnotation2));
        ClassId classId = ClassId.topLevel(KotlinBuiltIns.FQ_NAMES.deprecationLevel);
        Intrinsics.checkExpressionValueIsNotNull((Object)classId, (String)"ClassId.topLevel(KotlinB\u2026Q_NAMES.deprecationLevel)");
        Name name = Name.identifier(level);
        Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"Name.identifier(level)");
        pairArray[2] = TuplesKt.to((Object)DEPRECATED_LEVEL_NAME, (Object)new EnumValue(classId, name));
        return new BuiltInAnnotationDescriptor($receiver, fqName3, MapsKt.mapOf((Pair[])pairArray));
    }

    @NotNull
    public static /* synthetic */ AnnotationDescriptor createDeprecatedAnnotation$default(KotlinBuiltIns kotlinBuiltIns, String string, String string2, String string3, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = "";
        }
        if ((n & 4) != 0) {
            string3 = "WARNING";
        }
        return AnnotationUtilKt.createDeprecatedAnnotation(kotlinBuiltIns, string, string2, string3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isInlineOnlyOrReifiable(@NotNull MemberDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        if (!($receiver instanceof CallableMemberDescriptor)) return false;
        if (AnnotationUtilKt.isReifiable((CallableMemberDescriptor)$receiver)) return true;
        CallableMemberDescriptor callableMemberDescriptor = DescriptorUtils.getDirectMember((CallableMemberDescriptor)$receiver);
        Intrinsics.checkExpressionValueIsNotNull((Object)callableMemberDescriptor, (String)"DescriptorUtils.getDirectMember(this)");
        if (AnnotationUtilKt.isReifiable(callableMemberDescriptor)) return true;
        if (!AnnotationUtilKt.isInlineOnly($receiver)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isEffectivelyInlineOnly(@NotNull MemberDescriptor $receiver) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        if (AnnotationUtilKt.isInlineOnlyOrReifiable($receiver)) return true;
        if (!($receiver instanceof FunctionDescriptor)) return false;
        if (!((FunctionDescriptor)$receiver).isSuspend()) return false;
        if (!((FunctionDescriptor)$receiver).isInline()) return false;
        List<ValueParameterDescriptor> list = ((FunctionDescriptor)$receiver).getValueParameters();
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"valueParameters");
        Iterable $receiver$iv = list;
        if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
            bl = false;
        } else {
            for (Object element$iv : $receiver$iv) {
                ValueParameterDescriptor it = (ValueParameterDescriptor)element$iv;
                if (!it.isCrossinline()) continue;
                return true;
            }
            bl = false;
        }
        if (bl) return true;
        if (!Intrinsics.areEqual((Object)((FunctionDescriptor)$receiver).getVisibility(), (Object)Visibilities.PRIVATE)) return false;
        return true;
    }

    public static final boolean isInlineOnly(@NotNull MemberDescriptor $receiver) {
        block5: {
            block4: {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
                if (!($receiver instanceof FunctionDescriptor)) break block4;
                if (AnnotationUtilKt.hasInlineOnlyAnnotation((CallableMemberDescriptor)$receiver)) break block5;
                CallableMemberDescriptor callableMemberDescriptor = DescriptorUtils.getDirectMember((CallableMemberDescriptor)$receiver);
                Intrinsics.checkExpressionValueIsNotNull((Object)callableMemberDescriptor, (String)"DescriptorUtils.getDirectMember(this)");
                if (AnnotationUtilKt.hasInlineOnlyAnnotation(callableMemberDescriptor)) break block5;
            }
            return false;
        }
        boolean bl = ((FunctionDescriptor)$receiver).isInline();
        if (_Assertions.ENABLED && !bl) {
            String string = "Function is not inline: " + $receiver;
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        return true;
    }

    private static final boolean isReifiable(@NotNull CallableMemberDescriptor $receiver) {
        boolean bl;
        block3: {
            List<TypeParameterDescriptor> list = $receiver.getTypeParameters();
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"typeParameters");
            Iterable $receiver$iv = list;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $receiver$iv) {
                    TypeParameterDescriptor it;
                    TypeParameterDescriptor typeParameterDescriptor = it = (TypeParameterDescriptor)element$iv;
                    Intrinsics.checkExpressionValueIsNotNull((Object)typeParameterDescriptor, (String)"it");
                    if (!typeParameterDescriptor.isReified()) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final boolean hasInlineOnlyAnnotation(@NotNull CallableMemberDescriptor $receiver) {
        return $receiver.getAnnotations().hasAnnotation(INLINE_ONLY_ANNOTATION_FQ_NAME);
    }

    static {
        Name name = Name.identifier("message");
        Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"Name.identifier(\"message\")");
        DEPRECATED_MESSAGE_NAME = name;
        Name name2 = Name.identifier("replaceWith");
        Intrinsics.checkExpressionValueIsNotNull((Object)name2, (String)"Name.identifier(\"replaceWith\")");
        DEPRECATED_REPLACE_WITH_NAME = name2;
        Name name3 = Name.identifier("level");
        Intrinsics.checkExpressionValueIsNotNull((Object)name3, (String)"Name.identifier(\"level\")");
        DEPRECATED_LEVEL_NAME = name3;
        Name name4 = Name.identifier("expression");
        Intrinsics.checkExpressionValueIsNotNull((Object)name4, (String)"Name.identifier(\"expression\")");
        REPLACE_WITH_EXPRESSION_NAME = name4;
        Name name5 = Name.identifier("imports");
        Intrinsics.checkExpressionValueIsNotNull((Object)name5, (String)"Name.identifier(\"imports\")");
        REPLACE_WITH_IMPORTS_NAME = name5;
        INLINE_ONLY_ANNOTATION_FQ_NAME = new FqName("kotlin.internal.InlineOnly");
    }
}

