/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.moduleconverter;

import javax.annotation.Nullable;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.internal.artifacts.ImmutableModuleIdentifierFactory;
import org.gradle.api.internal.artifacts.Module;
import org.gradle.api.internal.artifacts.component.ComponentIdentifierFactory;
import org.gradle.api.internal.artifacts.configurations.ConfigurationInternal;
import org.gradle.api.internal.artifacts.configurations.ConfigurationsProvider;
import org.gradle.api.internal.artifacts.configurations.DependencyMetaDataProvider;
import org.gradle.api.internal.artifacts.configurations.MutationValidator;
import org.gradle.api.internal.artifacts.dsl.dependencies.DependencyLockingProvider;
import org.gradle.api.internal.artifacts.dsl.dependencies.ProjectFinder;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.LocalComponentMetadataBuilder;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.RootComponentMetadataBuilder;
import org.gradle.api.internal.attributes.AttributesSchemaInternal;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.ProjectState;
import org.gradle.api.internal.project.ProjectStateRegistry;
import org.gradle.internal.Factory;
import org.gradle.internal.component.local.model.BuildableLocalConfigurationMetadata;
import org.gradle.internal.component.local.model.DefaultLocalComponentMetadata;
import org.gradle.internal.component.local.model.RootLocalComponentMetadata;
import org.gradle.internal.component.model.ComponentResolveMetadata;
import org.gradle.internal.locking.NoOpDependencyLockingProvider;

public class DefaultRootComponentMetadataBuilder
implements RootComponentMetadataBuilder {
    private final DependencyMetaDataProvider metadataProvider;
    private final ComponentIdentifierFactory componentIdentifierFactory;
    private final ImmutableModuleIdentifierFactory moduleIdentifierFactory;
    private final ProjectFinder projectFinder;
    private final LocalComponentMetadataBuilder localComponentMetadataBuilder;
    private final ConfigurationsProvider configurationsProvider;
    private final MetadataHolder holder;
    private final ProjectStateRegistry projectStateRegistry;

    public DefaultRootComponentMetadataBuilder(DependencyMetaDataProvider metadataProvider, ComponentIdentifierFactory componentIdentifierFactory, ImmutableModuleIdentifierFactory moduleIdentifierFactory, ProjectFinder projectFinder, LocalComponentMetadataBuilder localComponentMetadataBuilder, ConfigurationsProvider configurationsProvider, ProjectStateRegistry projectStateRegistry) {
        this.metadataProvider = metadataProvider;
        this.componentIdentifierFactory = componentIdentifierFactory;
        this.moduleIdentifierFactory = moduleIdentifierFactory;
        this.projectFinder = projectFinder;
        this.localComponentMetadataBuilder = localComponentMetadataBuilder;
        this.configurationsProvider = configurationsProvider;
        this.projectStateRegistry = projectStateRegistry;
        this.holder = new MetadataHolder();
    }

    @Override
    public ComponentResolveMetadata toRootComponentMetaData() {
        Module module = this.metadataProvider.getModule();
        ComponentIdentifier componentIdentifier = this.componentIdentifierFactory.createComponentIdentifier(module);
        DefaultLocalComponentMetadata metadata = this.holder.tryCached(componentIdentifier);
        if (metadata == null) {
            metadata = this.buildRootComponentMetadata(module, componentIdentifier);
            this.holder.cachedValue = metadata;
        }
        return metadata;
    }

    private DefaultLocalComponentMetadata buildRootComponentMetadata(final Module module, final ComponentIdentifier componentIdentifier) {
        final ModuleVersionIdentifier moduleVersionIdentifier = this.moduleIdentifierFactory.moduleWithVersion(module.getGroup(), module.getName(), module.getVersion());
        ProjectInternal project = this.projectFinder.findProject(module.getProjectPath());
        if (project != null) {
            final AttributesSchemaInternal schema = (AttributesSchemaInternal)project.getDependencies().getAttributesSchema();
            final DependencyLockingProvider dependencyLockingHandler = project.getServices().get(DependencyLockingProvider.class);
            ProjectState projectState = this.projectStateRegistry.stateFor(project);
            return projectState.withMutableState(new Factory<DefaultLocalComponentMetadata>(){

                @Override
                @Nullable
                public DefaultLocalComponentMetadata create() {
                    return DefaultRootComponentMetadataBuilder.this.getRootComponentMetadata(module, componentIdentifier, moduleVersionIdentifier, schema, dependencyLockingHandler);
                }
            });
        }
        return this.getRootComponentMetadata(module, componentIdentifier, moduleVersionIdentifier, null, NoOpDependencyLockingProvider.getInstance());
    }

    private DefaultLocalComponentMetadata getRootComponentMetadata(Module module, ComponentIdentifier componentIdentifier, ModuleVersionIdentifier moduleVersionIdentifier, AttributesSchemaInternal schema, DependencyLockingProvider dependencyLockingHandler) {
        RootLocalComponentMetadata metadata = new RootLocalComponentMetadata(moduleVersionIdentifier, componentIdentifier, module.getStatus(), schema, dependencyLockingHandler);
        for (ConfigurationInternal configurationInternal : this.configurationsProvider.getAll()) {
            this.addConfiguration(metadata, configurationInternal);
        }
        return metadata;
    }

    private void addConfiguration(DefaultLocalComponentMetadata metadata, ConfigurationInternal configuration) {
        BuildableLocalConfigurationMetadata buildableLocalConfigurationMetadata = this.localComponentMetadataBuilder.addConfiguration(metadata, configuration);
        if (configuration.getResolutionStrategy().isDependencyLockingEnabled()) {
            buildableLocalConfigurationMetadata.enableLocking();
        }
    }

    @Override
    public RootComponentMetadataBuilder withConfigurationsProvider(ConfigurationsProvider alternateProvider) {
        return new DefaultRootComponentMetadataBuilder(this.metadataProvider, this.componentIdentifierFactory, this.moduleIdentifierFactory, this.projectFinder, this.localComponentMetadataBuilder, alternateProvider, this.projectStateRegistry);
    }

    public MutationValidator getValidator() {
        return this.holder;
    }

    private static class MetadataHolder
    implements MutationValidator {
        private DefaultLocalComponentMetadata cachedValue;

        private MetadataHolder() {
        }

        @Override
        public void validateMutation(MutationValidator.MutationType type) {
            if (type == MutationValidator.MutationType.DEPENDENCIES || type == MutationValidator.MutationType.ARTIFACTS || type == MutationValidator.MutationType.DEPENDENCY_ATTRIBUTES) {
                this.cachedValue = null;
            }
        }

        DefaultLocalComponentMetadata tryCached(ComponentIdentifier id) {
            if (this.cachedValue != null) {
                if (this.cachedValue.getId().equals(id)) {
                    return this.cachedValue;
                }
                this.cachedValue = null;
            }
            return null;
        }
    }
}

