/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.Version;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionParser;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ComponentState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ModuleResolveState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.NodeState;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.impldep.com.google.common.collect.Sets;

public class VirtualPlatformState {
    private final Comparator<String> vC;
    private final ModuleResolveState platformModule;
    private final Set<ModuleResolveState> participatingModules = Sets.newHashSet();

    public VirtualPlatformState(final Comparator<Version> versionComparator, final VersionParser versionParser, ModuleResolveState platformModule) {
        this.vC = new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return versionComparator.compare(versionParser.transform(o2), versionParser.transform(o1));
            }
        };
        this.platformModule = platformModule;
    }

    void participatingModule(ModuleResolveState state) {
        ComponentState selected;
        if (this.participatingModules.add(state) && (selected = this.platformModule.getSelected()) != null) {
            for (NodeState nodeState : selected.getNodes()) {
                nodeState.resetSelectionState();
            }
        }
    }

    List<String> getCandidateVersions() {
        ArrayList sorted = Lists.newArrayListWithCapacity((int)this.participatingModules.size());
        for (ModuleResolveState module : this.participatingModules) {
            ComponentState selected = module.getSelected();
            if (selected == null) continue;
            sorted.add(selected.getVersion());
        }
        Collections.sort(sorted, this.vC);
        return sorted;
    }

    Set<ModuleResolveState> getParticipatingModules() {
        return this.participatingModules;
    }

    ComponentIdentifier getSelectedPlatformId() {
        ComponentState selected = this.platformModule.getSelected();
        if (selected != null) {
            return selected.getComponentId();
        }
        return null;
    }
}

