/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.changes;

import java.util.Collection;
import java.util.Map;
import org.gradle.StartParameter;
import org.gradle.api.internal.TaskExecutionHistory;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.changedetection.TaskArtifactState;
import org.gradle.api.internal.changedetection.TaskArtifactStateRepository;
import org.gradle.api.internal.changedetection.changes.NoOutputsArtifactState;
import org.gradle.api.internal.changedetection.changes.RebuildIncrementalTaskInputs;
import org.gradle.api.internal.tasks.OriginTaskExecutionMetadata;
import org.gradle.api.internal.tasks.TaskExecutionContext;
import org.gradle.api.internal.tasks.execution.TaskProperties;
import org.gradle.api.specs.AndSpec;
import org.gradle.api.tasks.incremental.IncrementalTaskInputs;
import org.gradle.caching.internal.tasks.TaskOutputCachingBuildCacheKey;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.id.UniqueId;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSortedMap;
import org.gradle.internal.reflect.Instantiator;

public class ShortCircuitTaskArtifactStateRepository
implements TaskArtifactStateRepository {
    private final StartParameter startParameter;
    private final TaskArtifactStateRepository repository;
    private final Instantiator instantiator;

    public ShortCircuitTaskArtifactStateRepository(StartParameter startParameter, Instantiator instantiator, TaskArtifactStateRepository repository) {
        this.startParameter = startParameter;
        this.instantiator = instantiator;
        this.repository = repository;
    }

    @Override
    public TaskArtifactState getStateFor(TaskInternal task, TaskProperties taskProperties) {
        AndSpec<? super TaskInternal> upToDateSpec = task.getOutputs().getUpToDateSpec();
        if (!taskProperties.hasDeclaredOutputs() && upToDateSpec.isEmpty()) {
            if (task.hasTaskActions()) {
                return NoOutputsArtifactState.WITH_ACTIONS;
            }
            return NoOutputsArtifactState.WITHOUT_ACTIONS;
        }
        TaskArtifactState state = this.repository.getStateFor(task, taskProperties);
        if (this.startParameter.isRerunTasks()) {
            return new RerunTaskArtifactState(state, task, "Executed with '--rerun-tasks'.");
        }
        if (!upToDateSpec.isSatisfiedBy(task)) {
            return new RerunTaskArtifactState(state, task, "Task.upToDateWhen is false.");
        }
        return state;
    }

    private class RerunTaskArtifactState
    implements TaskArtifactState {
        private final TaskArtifactState delegate;
        private final TaskInternal task;
        private final String reason;

        private RerunTaskArtifactState(TaskArtifactState delegate, TaskInternal task, String reason) {
            this.delegate = delegate;
            this.task = task;
            this.reason = reason;
        }

        @Override
        public boolean isUpToDate(Collection<String> messages) {
            this.delegate.ensureSnapshotBeforeTask();
            messages.add(this.reason);
            return false;
        }

        @Override
        public IncrementalTaskInputs getInputChanges(TaskProperties taskProperties) {
            return ShortCircuitTaskArtifactStateRepository.this.instantiator.newInstance(RebuildIncrementalTaskInputs.class, this.task, taskProperties);
        }

        @Override
        public boolean isAllowedToUseCachedResults() {
            return false;
        }

        @Override
        public TaskOutputCachingBuildCacheKey calculateCacheKey() {
            return this.delegate.calculateCacheKey();
        }

        @Override
        public TaskExecutionHistory getExecutionHistory() {
            return this.delegate.getExecutionHistory();
        }

        @Override
        public Map<String, CurrentFileCollectionFingerprint> getOutputFingerprints() {
            return this.delegate.getOutputFingerprints();
        }

        @Override
        public void ensureSnapshotBeforeTask() {
            this.delegate.ensureSnapshotBeforeTask();
        }

        @Override
        public void afterOutputsRemovedBeforeTask() {
            this.delegate.afterOutputsRemovedBeforeTask();
        }

        @Override
        public void snapshotAfterTaskExecution(Throwable failure, UniqueId buildInvocationId, TaskExecutionContext taskExecutionContext) {
            this.delegate.snapshotAfterTaskExecution(failure, buildInvocationId, taskExecutionContext);
        }

        @Override
        public void snapshotAfterLoadedFromCache(ImmutableSortedMap<String, CurrentFileCollectionFingerprint> newOutputFingerprints, OriginTaskExecutionMetadata originMetadata) {
            this.delegate.snapshotAfterLoadedFromCache(newOutputFingerprints, originMetadata);
        }
    }
}

