/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import javax.annotation.Nullable;
import org.gradle.api.Named;
import org.gradle.api.internal.changedetection.state.IsolatedManagedNamedTypeSnapshot;
import org.gradle.api.internal.changedetection.state.StringValueSnapshot;
import org.gradle.api.internal.changedetection.state.isolation.Isolatable;
import org.gradle.api.internal.changedetection.state.isolation.IsolatableEnumValueSnapshot;
import org.gradle.api.internal.model.NamedObjectInstantiator;
import org.gradle.internal.Cast;

public class CoercingStringValueSnapshot
extends StringValueSnapshot {
    private final String value;
    private final NamedObjectInstantiator instantiator;

    public CoercingStringValueSnapshot(String value, NamedObjectInstantiator instantiator) {
        super(value);
        this.value = value;
        this.instantiator = instantiator;
    }

    @Override
    @Nullable
    public <S> Isolatable<S> coerce(Class<S> type) {
        if (type.isInstance(this.value)) {
            return (Isolatable)Cast.uncheckedCast(this);
        }
        if (type.isEnum()) {
            return (Isolatable)Cast.uncheckedCast(new IsolatableEnumValueSnapshot(Enum.valueOf(type.asSubclass(Enum.class), (String)this.getValue())));
        }
        if (Named.class.isAssignableFrom(type)) {
            return (Isolatable)Cast.uncheckedCast(new IsolatedManagedNamedTypeSnapshot((Named)this.instantiator.named(type, (String)this.getValue()), this.instantiator));
        }
        return null;
    }
}

