/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.reporting.dependencies.internal;

import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.artifacts.result.DependencyResult;
import org.gradle.api.artifacts.result.ResolvedDependencyResult;
import org.gradle.api.specs.Spec;

public class StrictDependencyResultSpec
implements Spec<DependencyResult> {
    private final ModuleIdentifier moduleIdentifier;

    public StrictDependencyResultSpec(ModuleIdentifier moduleIdentifier) {
        this.moduleIdentifier = moduleIdentifier;
    }

    @Override
    public boolean isSatisfiedBy(DependencyResult candidate) {
        if (candidate instanceof ResolvedDependencyResult) {
            return this.matchesRequested(candidate) || this.matchesSelected((ResolvedDependencyResult)candidate);
        }
        return this.matchesRequested(candidate);
    }

    private boolean matchesRequested(DependencyResult candidate) {
        ComponentSelector requested = candidate.getRequested();
        if (this.moduleIdentifier != null && requested instanceof ModuleComponentSelector) {
            ModuleComponentSelector requestedSelector = (ModuleComponentSelector)requested;
            return requestedSelector.getGroup().equals(this.moduleIdentifier.getGroup()) && requestedSelector.getModule().equals(this.moduleIdentifier.getName());
        }
        return false;
    }

    private boolean matchesSelected(ResolvedDependencyResult candidate) {
        ComponentIdentifier selected = candidate.getSelected().getId();
        if (this.moduleIdentifier != null && selected instanceof ModuleComponentIdentifier) {
            ModuleComponentIdentifier selectedModule = (ModuleComponentIdentifier)selected;
            return selectedModule.getGroup().equals(this.moduleIdentifier.getGroup()) && selectedModule.getModule().equals(this.moduleIdentifier.getName());
        }
        return false;
    }
}

