/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.reporting.plugins;

import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.internal.ConventionMapping;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.api.plugins.ReportingBasePlugin;
import org.gradle.api.reporting.DirectoryReport;
import org.gradle.api.reporting.GenerateBuildDashboard;
import org.gradle.api.reporting.Reporting;
import org.gradle.api.reporting.ReportingExtension;

@Incubating
public class BuildDashboardPlugin
implements Plugin<Project> {
    public static final String BUILD_DASHBOARD_TASK_NAME = "buildDashboard";

    @Override
    public void apply(final Project project) {
        project.getPluginManager().apply(ReportingBasePlugin.class);
        final GenerateBuildDashboard buildDashboardTask = project.getTasks().create(BUILD_DASHBOARD_TASK_NAME, GenerateBuildDashboard.class);
        buildDashboardTask.setDescription("Generates a dashboard of all the reports produced by this build.");
        buildDashboardTask.setGroup("reporting");
        DirectoryReport htmlReport = buildDashboardTask.getReports().getHtml();
        ConventionMapping htmlReportConventionMapping = new DslObject(htmlReport).getConventionMapping();
        htmlReportConventionMapping.map("destination", new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return project.getExtensions().getByType(ReportingExtension.class).file(BuildDashboardPlugin.BUILD_DASHBOARD_TASK_NAME);
            }
        });
        Action<Task> captureReportingTasks = new Action<Task>(){

            @Override
            public void execute(Task task) {
                if (!(task instanceof Reporting)) {
                    return;
                }
                Reporting reporting = (Reporting)((Object)task);
                buildDashboardTask.aggregate(reporting);
                if (!task.equals(buildDashboardTask)) {
                    task.finalizedBy(buildDashboardTask);
                }
            }
        };
        for (Project aProject : project.getAllprojects()) {
            aProject.getTasks().all(captureReportingTasks);
        }
    }
}

