/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.external.model;

import java.util.List;
import org.gradle.api.artifacts.VersionConstraint;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.artifacts.component.ProjectComponentSelector;
import org.gradle.api.internal.attributes.AttributesSchemaInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.component.external.model.DefaultModuleComponentSelector;
import org.gradle.internal.component.external.model.ExternalDependencyDescriptor;
import org.gradle.internal.component.external.model.ModuleDependencyMetadata;
import org.gradle.internal.component.local.model.DefaultProjectDependencyMetadata;
import org.gradle.internal.component.model.AttributeConfigurationSelector;
import org.gradle.internal.component.model.ComponentResolveMetadata;
import org.gradle.internal.component.model.ConfigurationMetadata;
import org.gradle.internal.component.model.DependencyMetadata;
import org.gradle.internal.component.model.ExcludeMetadata;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.impldep.com.google.common.base.Objects;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;

public class ConfigurationBoundExternalDependencyMetadata
implements ModuleDependencyMetadata {
    private final ConfigurationMetadata configuration;
    private final ModuleComponentIdentifier componentId;
    private final ExternalDependencyDescriptor dependencyDescriptor;
    private final String reason;
    private final boolean isTransitive;
    private boolean alwaysUseAttributeMatching;

    private ConfigurationBoundExternalDependencyMetadata(ConfigurationMetadata configuration, ModuleComponentIdentifier componentId, ExternalDependencyDescriptor dependencyDescriptor, String reason) {
        this.configuration = configuration;
        this.componentId = componentId;
        this.dependencyDescriptor = dependencyDescriptor;
        this.reason = reason;
        this.isTransitive = dependencyDescriptor.isTransitive();
    }

    public ConfigurationBoundExternalDependencyMetadata(ConfigurationMetadata configuration, ModuleComponentIdentifier componentId, ExternalDependencyDescriptor dependencyDescriptor) {
        this(configuration, componentId, dependencyDescriptor, null);
    }

    public ConfigurationBoundExternalDependencyMetadata alwaysUseAttributeMatching() {
        this.alwaysUseAttributeMatching = true;
        return this;
    }

    public ExternalDependencyDescriptor getDependencyDescriptor() {
        return this.dependencyDescriptor;
    }

    @Override
    public List<ConfigurationMetadata> selectConfigurations(ImmutableAttributes consumerAttributes, ComponentResolveMetadata targetComponent, AttributesSchemaInternal consumerSchema) {
        if (this.alwaysUseAttributeMatching || this.hasVariants(targetComponent)) {
            return ImmutableList.of((Object)AttributeConfigurationSelector.selectConfigurationUsingAttributeMatching(consumerAttributes, targetComponent, consumerSchema));
        }
        return this.dependencyDescriptor.selectLegacyConfigurations(this.componentId, this.configuration, targetComponent);
    }

    private boolean hasVariants(ComponentResolveMetadata targetComponent) {
        return targetComponent.getVariantsForGraphTraversal().isPresent();
    }

    @Override
    public List<IvyArtifactName> getArtifacts() {
        return this.dependencyDescriptor.getConfigurationArtifacts(this.configuration);
    }

    @Override
    public List<ExcludeMetadata> getExcludes() {
        return this.dependencyDescriptor.getConfigurationExcludes(this.configuration.getHierarchy());
    }

    @Override
    public DependencyMetadata withTarget(ComponentSelector target) {
        if (target instanceof ModuleComponentSelector) {
            ModuleComponentSelector moduleTarget = (ModuleComponentSelector)target;
            ModuleComponentSelector newSelector = DefaultModuleComponentSelector.newSelector(moduleTarget.getModuleIdentifier(), moduleTarget.getVersionConstraint(), moduleTarget.getAttributes());
            if (newSelector.equals(this.getSelector())) {
                return this;
            }
            return this.withRequested(newSelector);
        }
        if (target instanceof ProjectComponentSelector) {
            ProjectComponentSelector projectTarget = (ProjectComponentSelector)target;
            return new DefaultProjectDependencyMetadata(projectTarget, this);
        }
        throw new IllegalArgumentException("Unexpected selector provided: " + target);
    }

    @Override
    public ModuleDependencyMetadata withRequestedVersion(VersionConstraint requestedVersion) {
        ModuleComponentSelector selector = this.getSelector();
        if (requestedVersion.equals(selector.getVersionConstraint())) {
            return this;
        }
        ModuleComponentSelector newSelector = DefaultModuleComponentSelector.newSelector(selector.getModuleIdentifier(), requestedVersion, selector.getAttributes());
        return this.withRequested(newSelector);
    }

    @Override
    public ModuleDependencyMetadata withReason(String reason) {
        if (Objects.equal((Object)reason, (Object)this.getReason())) {
            return this;
        }
        return new ConfigurationBoundExternalDependencyMetadata(this.configuration, this.componentId, this.dependencyDescriptor, reason);
    }

    private ModuleDependencyMetadata withRequested(ModuleComponentSelector newSelector) {
        ExternalDependencyDescriptor newDelegate = this.dependencyDescriptor.withRequested(newSelector);
        return new ConfigurationBoundExternalDependencyMetadata(this.configuration, this.componentId, newDelegate);
    }

    @Override
    public ModuleComponentSelector getSelector() {
        return this.dependencyDescriptor.getSelector();
    }

    @Override
    public boolean isChanging() {
        return this.dependencyDescriptor.isChanging();
    }

    @Override
    public boolean isTransitive() {
        return this.isTransitive;
    }

    @Override
    public boolean isPending() {
        return this.dependencyDescriptor.isOptional();
    }

    @Override
    public String getReason() {
        return this.reason;
    }

    public String toString() {
        return this.dependencyDescriptor.toString();
    }
}

