/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.hash;

import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class HashCode
implements Serializable,
Comparable<HashCode> {
    private static final int MIN_NUMBER_OF_BYTES = 4;
    private static final int MAX_NUMBER_OF_BYTES = 255;
    private static final char[] HEX_DIGITS = "0123456789abcdef".toCharArray();
    private final byte[] bytes;
    private long hashCode;

    private HashCode(byte[] bytes) {
        this.bytes = bytes;
    }

    static HashCode fromBytesNoCopy(byte[] bytes) {
        return new HashCode(bytes);
    }

    public static HashCode fromBytes(byte[] bytes) {
        if (bytes.length < 4 || bytes.length > 255) {
            throw new IllegalArgumentException(String.format("Invalid hash code length: %d bytes", bytes.length));
        }
        return HashCode.fromBytesNoCopy((byte[])bytes.clone());
    }

    public static HashCode fromInt(int value) {
        return HashCode.fromBytesNoCopy(new byte[]{(byte)(value >> 24), (byte)(value >> 16), (byte)(value >> 8), (byte)value});
    }

    public static HashCode fromString(String string) {
        int length = string.length();
        if (length % 2 != 0 || length < 8 || length > 510) {
            throw new IllegalArgumentException(String.format("Invalid hash code length: %d characters", length));
        }
        byte[] bytes = new byte[length / 2];
        for (int i = 0; i < length; i += 2) {
            int ch1 = HashCode.decode(string.charAt(i)) << 4;
            int ch2 = HashCode.decode(string.charAt(i + 1));
            bytes[i / 2] = (byte)(ch1 + ch2);
        }
        return HashCode.fromBytesNoCopy(bytes);
    }

    private static int decode(char ch) {
        if (ch >= '0' && ch <= '9') {
            return ch - 48;
        }
        if (ch >= 'a' && ch <= 'f') {
            return ch - 97 + 10;
        }
        if (ch >= 'A' && ch <= 'F') {
            return ch - 65 + 10;
        }
        throw new IllegalArgumentException("Illegal hexadecimal character: " + ch);
    }

    public int length() {
        return this.bytes.length;
    }

    public byte[] toByteArray() {
        return (byte[])this.bytes.clone();
    }

    public int hashCode() {
        if (this.hashCode == 0L) {
            this.hashCode = (long)(this.bytes[0] & 0xFF | (this.bytes[1] & 0xFF) << 8 | (this.bytes[2] & 0xFF) << 16 | (this.bytes[3] & 0xFF) << 24) | 0x100000000L;
        }
        return (int)this.hashCode;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != HashCode.class) {
            return false;
        }
        byte[] b = ((HashCode)obj).bytes;
        byte[] a = this.bytes;
        int length = a.length;
        if (b.length != length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(@Nonnull HashCode o) {
        byte[] bytes2 = o.bytes;
        int len1 = this.bytes.length;
        int len2 = bytes2.length;
        int length = Math.min(len1, len2);
        for (int idx = 0; idx < length; ++idx) {
            int result = this.bytes[idx] - bytes2[idx];
            if (result == 0) continue;
            return result;
        }
        return len1 - len2;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(2 * this.bytes.length);
        for (byte b : this.bytes) {
            sb.append(HEX_DIGITS[b >> 4 & 0xF]).append(HEX_DIGITS[b & 0xF]);
        }
        return sb.toString();
    }

    byte[] getBytes() {
        return this.bytes;
    }
}

