/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.scala.internal.toolchain;

import java.io.File;
import java.util.Set;
import org.gradle.api.JavaVersion;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ResolveException;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.language.scala.ScalaPlatform;
import org.gradle.language.scala.internal.toolchain.DefaultScalaToolProvider;
import org.gradle.language.scala.internal.toolchain.NotFoundScalaToolProvider;
import org.gradle.language.scala.internal.toolchain.ScalaToolChainInternal;
import org.gradle.platform.base.internal.toolchain.ToolProvider;
import org.gradle.workers.internal.WorkerDaemonFactory;

public class DownloadingScalaToolChain
implements ScalaToolChainInternal {
    private final File gradleUserHomeDir;
    private final File daemonWorkingDir;
    private final WorkerDaemonFactory workerDaemonFactory;
    private final ConfigurationContainer configurationContainer;
    private final DependencyHandler dependencyHandler;
    private final JavaVersion javaVersion;
    private final FileResolver fileResolver;

    public DownloadingScalaToolChain(File gradleUserHomeDir, File daemonWorkingDir, WorkerDaemonFactory workerDaemonFactory, ConfigurationContainer configurationContainer, DependencyHandler dependencyHandler, FileResolver fileResolver) {
        this.gradleUserHomeDir = gradleUserHomeDir;
        this.daemonWorkingDir = daemonWorkingDir;
        this.workerDaemonFactory = workerDaemonFactory;
        this.configurationContainer = configurationContainer;
        this.dependencyHandler = dependencyHandler;
        this.fileResolver = fileResolver;
        this.javaVersion = JavaVersion.current();
    }

    @Override
    public String getName() {
        return "Scala Toolchain";
    }

    @Override
    public String getDisplayName() {
        return "Scala Toolchain (JDK " + this.javaVersion.getMajorVersion() + " (" + (Object)((Object)this.javaVersion) + "))";
    }

    @Override
    public ToolProvider select(ScalaPlatform targetPlatform) {
        try {
            Configuration scalaClasspath = this.resolveDependency("org.scala-lang:scala-compiler:" + targetPlatform.getScalaVersion());
            Configuration zincClasspath = this.resolveDependency("com.typesafe.zinc:zinc:0.3.15");
            Set<File> resolvedScalaClasspath = scalaClasspath.resolve();
            Set<File> resolvedZincClasspath = zincClasspath.resolve();
            return new DefaultScalaToolProvider(this.gradleUserHomeDir, this.daemonWorkingDir, this.workerDaemonFactory, this.fileResolver, resolvedScalaClasspath, resolvedZincClasspath);
        }
        catch (ResolveException resolveException) {
            return new NotFoundScalaToolProvider(resolveException);
        }
    }

    private Configuration resolveDependency(Object dependencyNotation) {
        Dependency dependency = this.dependencyHandler.create(dependencyNotation);
        return this.configurationContainer.detachedConfiguration(dependency);
    }
}

