/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coldFusion.UI.editorActions.matchers;

import com.intellij.codeInsight.highlighting.BraceMatcher;
import com.intellij.coldFusion.model.CfmlLanguage;
import com.intellij.coldFusion.model.CfmlUtil;
import com.intellij.coldFusion.model.files.CfmlFileType;
import com.intellij.coldFusion.model.lexer.CfmlTokenTypes;
import com.intellij.coldFusion.model.lexer.CfscriptTokenTypes;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.lang.BracePair;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageBraceMatching;
import com.intellij.lang.PairedBraceMatcher;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeExtensionPoint;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CfmlBraceMatcher
implements BraceMatcher {
    private static final BracePair[] PAIRS = new BracePair[]{new BracePair(CfscriptTokenTypes.L_BRACKET, CfscriptTokenTypes.R_BRACKET, false), new BracePair(CfscriptTokenTypes.L_SQUAREBRACKET, CfscriptTokenTypes.R_SQUAREBRACKET, false), new BracePair(CfscriptTokenTypes.L_CURLYBRACKET, CfscriptTokenTypes.R_CURLYBRACKET, false), new BracePair(CfscriptTokenTypes.OPENSHARP, CfscriptTokenTypes.CLOSESHARP, true), new BracePair(CfmlTokenTypes.START_EXPRESSION, CfmlTokenTypes.END_EXPRESSION, true)};

    public int getBraceTokenGroupId(IElementType tokenType) {
        Language l = tokenType.getLanguage();
        return l.hashCode();
    }

    public boolean isLBraceToken(HighlighterIterator iterator, CharSequence fileText, FileType fileType) {
        LanguageFileType tokenFileType;
        IElementType tokenType = iterator.getTokenType();
        PairedBraceMatcher matcher = (PairedBraceMatcher)LanguageBraceMatching.INSTANCE.forLanguage(tokenType.getLanguage());
        if (matcher != null) {
            BracePair[] pairs = matcher.getPairs();
            BracePair[] bracePairArray = pairs;
            int n = bracePairArray.length;
            for (int i = 0; i < n; ++i) {
                BracePair pair = bracePairArray[i];
                if (pair.getLeftBraceType() != tokenType) continue;
                return true;
            }
        }
        if (!tokenType.getLanguage().equals((Object)CfmlLanguage.INSTANCE) && (tokenFileType = iterator.getTokenType().getLanguage().getAssociatedFileType()) != null && tokenFileType != CfmlFileType.INSTANCE) {
            for (FileTypeExtensionPoint ext : BraceMatcher.EP_NAME.getExtensionList()) {
                if (ext.filetype == null || !ext.filetype.equals(tokenFileType.getName())) continue;
                return ((BraceMatcher)ext.getInstance()).isLBraceToken(iterator, fileText, (FileType)(tokenFileType instanceof XmlFileType ? StdFileTypes.HTML : tokenFileType));
            }
        }
        for (BracePair pair : PAIRS) {
            if (pair.getLeftBraceType() != tokenType) continue;
            return true;
        }
        return tokenType.equals(CfmlTokenTypes.OPENER) && (!CfmlUtil.isEndTagRequired(CfmlBraceMatcher.getTagName(fileText, iterator), null) || CfmlBraceMatcher.findEndTag(fileText, iterator));
    }

    public boolean isRBraceToken(HighlighterIterator iterator, CharSequence fileText, FileType fileType) {
        LanguageFileType tokenFileType;
        IElementType tokenType = iterator.getTokenType();
        PairedBraceMatcher matcher = (PairedBraceMatcher)LanguageBraceMatching.INSTANCE.forLanguage(tokenType.getLanguage());
        if (matcher != null) {
            BracePair[] pairs = matcher.getPairs();
            BracePair[] bracePairArray = pairs;
            int n = bracePairArray.length;
            for (int i = 0; i < n; ++i) {
                BracePair pair = bracePairArray[i];
                if (pair.getRightBraceType() != tokenType) continue;
                return true;
            }
        }
        if (!tokenType.getLanguage().equals((Object)CfmlLanguage.INSTANCE) && (tokenFileType = iterator.getTokenType().getLanguage().getAssociatedFileType()) != null && tokenFileType != CfmlFileType.INSTANCE) {
            for (FileTypeExtensionPoint ext : BraceMatcher.EP_NAME.getExtensionList()) {
                if (ext.filetype == null || !ext.filetype.equals(tokenFileType.getName())) continue;
                return ((BraceMatcher)ext.getInstance()).isRBraceToken(iterator, fileText, (FileType)(tokenFileType instanceof XmlFileType ? StdFileTypes.HTML : tokenFileType));
            }
        }
        for (BracePair pair : PAIRS) {
            if (pair.getRightBraceType() != tokenType) continue;
            return true;
        }
        return tokenType.equals(CfmlTokenTypes.CLOSER) && CfmlBraceMatcher.findBeginTag(fileText, iterator) || tokenType.equals(CfmlTokenTypes.R_ANGLEBRACKET) && !CfmlUtil.isEndTagRequired(CfmlBraceMatcher.getTagName(fileText, iterator), null) && !CfmlBraceMatcher.findEndTag(fileText, iterator);
    }

    public boolean isPairBraces(IElementType tokenType1, IElementType tokenType2) {
        PairedBraceMatcher matcher = (PairedBraceMatcher)LanguageBraceMatching.INSTANCE.forLanguage(tokenType1.getLanguage());
        if (matcher != null) {
            BracePair[] pairs;
            for (BracePair pair : pairs = matcher.getPairs()) {
                if (pair.getLeftBraceType() == tokenType1) {
                    return pair.getRightBraceType() == tokenType2;
                }
                if (pair.getRightBraceType() != tokenType1) continue;
                return pair.getLeftBraceType() == tokenType2;
            }
        }
        LanguageFileType tokenFileType1 = tokenType1.getLanguage().getAssociatedFileType();
        LanguageFileType tokenFileType2 = tokenType2.getLanguage().getAssociatedFileType();
        if (tokenFileType2 != tokenFileType1) {
            return false;
        }
        if (tokenFileType1 != CfmlFileType.INSTANCE && tokenFileType1 != null) {
            for (FileTypeExtensionPoint ext : BraceMatcher.EP_NAME.getExtensionList()) {
                if (!ext.filetype.equals(tokenFileType1.getName())) continue;
                return ((BraceMatcher)ext.getInstance()).isPairBraces(tokenType1, tokenType2);
            }
        }
        for (BracePair pair : PAIRS) {
            if (pair.getLeftBraceType() == tokenType1) {
                return pair.getRightBraceType() == tokenType2;
            }
            if (pair.getRightBraceType() != tokenType1) continue;
            return pair.getLeftBraceType() == tokenType2;
        }
        return tokenType1.equals(CfmlTokenTypes.OPENER) && tokenType2.equals(CfmlTokenTypes.CLOSER) || tokenType1.equals(CfmlTokenTypes.CLOSER) && tokenType2.equals(CfmlTokenTypes.OPENER) || tokenType1.equals(CfmlTokenTypes.R_ANGLEBRACKET) && tokenType2.equals(CfmlTokenTypes.OPENER) || tokenType1.equals(CfmlTokenTypes.OPENER) && tokenType2.equals(CfmlTokenTypes.R_ANGLEBRACKET);
    }

    public boolean isStructuralBrace(HighlighterIterator iterator, CharSequence text, FileType fileType) {
        IElementType type = iterator.getTokenType();
        return type != CfscriptTokenTypes.L_BRACKET && type != CfscriptTokenTypes.R_BRACKET;
    }

    public boolean isPairedBracesAllowedBeforeType(@NotNull IElementType lbraceType, @Nullable IElementType contextType) {
        if (lbraceType == null) {
            CfmlBraceMatcher.$$$reportNull$$$0(0);
        }
        return true;
    }

    private static boolean findBeginTag(CharSequence fileText, HighlighterIterator iterator) {
        String name = CfmlBraceMatcher.getTagName(fileText, iterator);
        if (name == null) {
            return false;
        }
        int balance = 0;
        int count = 0;
        while (balance < 1) {
            iterator.retreat();
            ++count;
            if (iterator.atEnd()) break;
            IElementType tokenType = iterator.getTokenType();
            String currentTagName = CfmlBraceMatcher.getTagName(fileText, iterator);
            if (tokenType == CfmlTokenTypes.CLOSER && name.equals(currentTagName)) {
                --balance;
                continue;
            }
            if (tokenType != CfmlTokenTypes.OPENER || !name.equals(currentTagName)) continue;
            ++balance;
        }
        while (count-- > 0) {
            iterator.advance();
        }
        return balance == 1;
    }

    private static boolean findEndTag(CharSequence fileText, HighlighterIterator iterator) {
        String name = CfmlBraceMatcher.getTagName(fileText, iterator);
        if (name == null) {
            return false;
        }
        int balance = 0;
        int count = 0;
        while (balance > -1 && !iterator.atEnd()) {
            iterator.advance();
            ++count;
            if (iterator.atEnd()) break;
            IElementType tokenType = iterator.getTokenType();
            String currrentTagName = CfmlBraceMatcher.getTagName(fileText, iterator);
            if (tokenType == CfmlTokenTypes.OPENER && name.equals(currrentTagName)) {
                ++balance;
                continue;
            }
            if (tokenType != CfmlTokenTypes.CLOSER || !name.equals(currrentTagName)) continue;
            --balance;
        }
        while (count-- > 0) {
            iterator.retreat();
        }
        return balance == -1;
    }

    @Nullable
    public static String getTagName(CharSequence fileText, HighlighterIterator iterator) {
        IElementType tokenType = iterator.getTokenType();
        String name = null;
        if (tokenType == CfmlTokenTypes.CLOSER || tokenType == CfmlTokenTypes.R_ANGLEBRACKET) {
            IElementType tokenType1;
            iterator.retreat();
            IElementType iElementType = tokenType1 = !iterator.atEnd() ? iterator.getTokenType() : null;
            if (tokenType1 == CfmlTokenTypes.CF_TAG_NAME) {
                name = fileText.subSequence(iterator.getStart(), iterator.getEnd()).toString();
            } else {
                int counter = 0;
                while (!iterator.atEnd()) {
                    if (iterator.getTokenType() == CfmlTokenTypes.CF_TAG_NAME) {
                        name = fileText.subSequence(iterator.getStart(), iterator.getEnd()).toString();
                        break;
                    }
                    if (iterator.getTokenType() == CfmlTokenTypes.CLOSER || iterator.getTokenType() == CfmlTokenTypes.R_ANGLEBRACKET) break;
                    iterator.retreat();
                    ++counter;
                }
                while (counter-- > 0) {
                    iterator.advance();
                }
            }
            iterator.advance();
        } else if (tokenType == CfmlTokenTypes.OPENER) {
            IElementType tokenType1;
            iterator.advance();
            IElementType iElementType = tokenType1 = !iterator.atEnd() ? iterator.getTokenType() : null;
            if (tokenType1 == CfmlTokenTypes.CF_TAG_NAME) {
                name = fileText.subSequence(iterator.getStart(), iterator.getEnd()).toString();
            }
            iterator.retreat();
        }
        return name == null ? name : name.toLowerCase();
    }

    public IElementType getOppositeBraceTokenType(@NotNull IElementType type) {
        if (type == null) {
            CfmlBraceMatcher.$$$reportNull$$$0(1);
        }
        for (BracePair pair : PAIRS) {
            if (pair.getLeftBraceType() == type) {
                return pair.getRightBraceType();
            }
            if (pair.getRightBraceType() != type) continue;
            return pair.getLeftBraceType();
        }
        if (type == CfmlTokenTypes.OPENER) {
            return CfmlTokenTypes.R_ANGLEBRACKET;
        }
        if (type == CfmlTokenTypes.CLOSER) {
            return CfmlTokenTypes.OPENER;
        }
        if (type == CfmlTokenTypes.R_ANGLEBRACKET) {
            return CfmlTokenTypes.OPENER;
        }
        return null;
    }

    public int getCodeConstructStart(PsiFile file, int openingBraceOffset) {
        PsiElement element = file.findElementAt(openingBraceOffset);
        if (element == null || element instanceof PsiFile) {
            return openingBraceOffset;
        }
        PsiElement parent = element.getParent();
        return parent.getTextRange().getStartOffset();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lbraceType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        objectArray2[1] = "com/intellij/coldFusion/UI/editorActions/matchers/CfmlBraceMatcher";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isPairedBracesAllowedBeforeType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getOppositeBraceTokenType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

