/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coldFusion.UI.editorActions.typedHandlers;

import com.intellij.codeInsight.generation.CommenterDataHolder;
import com.intellij.codeInsight.generation.SelfManagingCommenter;
import com.intellij.coldFusion.model.lexer.CfmlTokenTypes;
import com.intellij.coldFusion.model.lexer.CfscriptTokenTypes;
import com.intellij.coldFusion.model.psi.impl.CfmlTagScriptImpl;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Commenter;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;

public class CfmlCommenter
implements Commenter,
SelfManagingCommenter<MyCommenterData> {
    private static final String CF_SCRIPT_BLOCK_COMMENT_PREFIX = "/*";
    private static final String CF_SCRIPT_BLOCK_COMMENT_SUFFIX = "*/";
    private static final String CF_SCRIPT_LINE_COMMENT_PREFIX = "//";
    private static final String CFML_COMMENT_PREFIX = "<!---";
    private static final String CFML_COMMENT_SUFFIX = "--->";

    public String getLineCommentPrefix() {
        return null;
    }

    public String getBlockCommentPrefix() {
        return CFML_COMMENT_PREFIX;
    }

    public String getBlockCommentSuffix() {
        return CFML_COMMENT_SUFFIX;
    }

    public String getCommentedBlockCommentPrefix() {
        return "&lt;!&mdash;";
    }

    public String getCommentedBlockCommentSuffix() {
        return "&mdash;&gt;";
    }

    private static boolean isOffsetWithinCfscript(int offset, @NotNull Document document, @NotNull PsiFile file) {
        PsiElement at;
        if (document == null) {
            CfmlCommenter.$$$reportNull$$$0(0);
        }
        if (file == null) {
            CfmlCommenter.$$$reportNull$$$0(1);
        }
        if ((at = CfmlCommenter.getCfmlElementAtOffset(offset, file)) != null) {
            CfmlTagScriptImpl scriptTag = (CfmlTagScriptImpl)PsiTreeUtil.getParentOfType((PsiElement)at, CfmlTagScriptImpl.class);
            if (scriptTag != null) {
                return scriptTag.isInsideTag(offset);
            }
            PsiElement firstChild = file.getFirstChild();
            if (firstChild != null) {
                ASTNode theDeepestChild = firstChild.getNode();
                if (theDeepestChild == null) {
                    return false;
                }
                while (theDeepestChild.getFirstChildNode() != null) {
                    theDeepestChild = theDeepestChild.getFirstChildNode();
                }
                IElementType elementType = theDeepestChild.getElementType();
                if (elementType == CfscriptTokenTypes.COMMENT || elementType == CfscriptTokenTypes.COMPONENT_KEYWORD || elementType == CfscriptTokenTypes.INTERFACE_KEYWORD || elementType == CfscriptTokenTypes.IMPORT_KEYWORD) {
                    return true;
                }
            }
        }
        return false;
    }

    private static PsiElement getCfmlElementAtOffset(int offset, PsiFile file) {
        FileViewProvider fileViewProvider = file.getViewProvider();
        file = fileViewProvider.getPsi(fileViewProvider.getBaseLanguage());
        Language cfmlLanguage = file.getLanguage();
        return fileViewProvider.findElementAt(offset, cfmlLanguage);
    }

    private static int skipWhiteSpaces(int offset, PsiFile file) {
        PsiElement at = CfmlCommenter.getCfmlElementAtOffset(offset, file);
        if (at != null && at.getNode().getElementType() == CfmlTokenTypes.WHITE_SPACE) {
            return at.getTextRange().getEndOffset();
        }
        return offset;
    }

    public MyCommenterData createLineCommentingState(int startLine, int endLine, @NotNull Document document, @NotNull PsiFile file) {
        if (document == null) {
            CfmlCommenter.$$$reportNull$$$0(2);
        }
        if (file == null) {
            CfmlCommenter.$$$reportNull$$$0(3);
        }
        int lineStartOffset = document.getLineStartOffset(startLine);
        return new MyCommenterData(CfmlCommenter.isOffsetWithinCfscript(lineStartOffset, document, file), lineStartOffset);
    }

    public MyCommenterData createBlockCommentingState(int selectionStart, int selectionEnd, @NotNull Document document, @NotNull PsiFile file) {
        if (document == null) {
            CfmlCommenter.$$$reportNull$$$0(4);
        }
        if (file == null) {
            CfmlCommenter.$$$reportNull$$$0(5);
        }
        return new MyCommenterData(CfmlCommenter.isOffsetWithinCfscript(selectionStart, document, file), selectionStart);
    }

    public void commentLine(int line, int offset, @NotNull Document document, @NotNull MyCommenterData data) {
        if (document == null) {
            CfmlCommenter.$$$reportNull$$$0(6);
        }
        if (data == null) {
            CfmlCommenter.$$$reportNull$$$0(7);
        }
        int originalLineEndOffset = document.getLineEndOffset(line);
        offset = CharArrayUtil.shiftForward((CharSequence)document.getCharsSequence(), (int)offset, (String)" \t");
        if (data.isIsWithinCfscript()) {
            document.insertString(offset, (CharSequence)CF_SCRIPT_LINE_COMMENT_PREFIX);
        } else {
            document.insertString(originalLineEndOffset, (CharSequence)CFML_COMMENT_SUFFIX);
            document.insertString(offset, (CharSequence)CFML_COMMENT_PREFIX);
        }
    }

    public void uncommentLine(int line, int offset, @NotNull Document document, @NotNull MyCommenterData data) {
        if (document == null) {
            CfmlCommenter.$$$reportNull$$$0(8);
        }
        if (data == null) {
            CfmlCommenter.$$$reportNull$$$0(9);
        }
        int rangeEnd = document.getLineEndOffset(line);
        if (!data.isIsWithinCfscript()) {
            document.deleteString(rangeEnd - CFML_COMMENT_SUFFIX.length(), rangeEnd);
        }
        String commentPrefix = data.getLineCommentPrefix();
        document.deleteString(offset, offset + commentPrefix.length());
    }

    public boolean isLineCommented(int line, int offset, @NotNull Document document, @NotNull MyCommenterData data) {
        if (document == null) {
            CfmlCommenter.$$$reportNull$$$0(10);
        }
        if (data == null) {
            CfmlCommenter.$$$reportNull$$$0(11);
        }
        int rangeEnd = document.getLineEndOffset(line);
        boolean commented = true;
        if (!data.isIsWithinCfscript()) {
            String commentSuffix = CFML_COMMENT_SUFFIX;
            if (!CharArrayUtil.regionMatches((CharSequence)document.getCharsSequence(), (int)(rangeEnd - CFML_COMMENT_SUFFIX.length()), (CharSequence)CFML_COMMENT_SUFFIX)) {
                commented = false;
            }
        }
        String commentPrefix = data.getLineCommentPrefix();
        if (commented && !CharArrayUtil.regionMatches((CharSequence)document.getCharsSequence(), (int)offset, (CharSequence)commentPrefix)) {
            commented = false;
        }
        return commented;
    }

    public String getCommentPrefix(int line, @NotNull Document document, @NotNull MyCommenterData data) {
        if (document == null) {
            CfmlCommenter.$$$reportNull$$$0(12);
        }
        if (data == null) {
            CfmlCommenter.$$$reportNull$$$0(13);
        }
        return data.getLineCommentPrefix();
    }

    public TextRange getBlockCommentRange(int selectionStart, int selectionEnd, @NotNull Document document, @NotNull MyCommenterData data) {
        if (document == null) {
            CfmlCommenter.$$$reportNull$$$0(14);
        }
        if (data == null) {
            CfmlCommenter.$$$reportNull$$$0(15);
        }
        String commentSuffix = data.getBlockCommentSuffix();
        String commentPrefix = data.getBlockCommentPrefix();
        selectionStart = CharArrayUtil.shiftForward((CharSequence)document.getCharsSequence(), (int)selectionStart, (String)" \t\n");
        selectionEnd = CharArrayUtil.shiftBackward((CharSequence)document.getCharsSequence(), (int)(selectionEnd - 1), (String)" \t\n") + 1;
        if (selectionEnd < selectionStart) {
            selectionEnd = selectionStart;
        }
        if (CharArrayUtil.regionMatches((CharSequence)document.getCharsSequence(), (int)(selectionEnd - commentSuffix.length()), (CharSequence)commentSuffix) && CharArrayUtil.regionMatches((CharSequence)document.getCharsSequence(), (int)selectionStart, (CharSequence)commentPrefix)) {
            return new TextRange(selectionStart, selectionEnd);
        }
        return null;
    }

    public String getBlockCommentPrefix(int selectionStart, @NotNull Document document, @NotNull MyCommenterData data) {
        if (document == null) {
            CfmlCommenter.$$$reportNull$$$0(16);
        }
        if (data == null) {
            CfmlCommenter.$$$reportNull$$$0(17);
        }
        return data.getBlockCommentPrefix();
    }

    public String getBlockCommentSuffix(int selectionEnd, @NotNull Document document, @NotNull MyCommenterData data) {
        if (document == null) {
            CfmlCommenter.$$$reportNull$$$0(18);
        }
        if (data == null) {
            CfmlCommenter.$$$reportNull$$$0(19);
        }
        return data.getBlockCommentSuffix();
    }

    public void uncommentBlockComment(int startOffset, int endOffset, Document document, MyCommenterData data) {
        String commentSuffix = data.getBlockCommentSuffix();
        String commentPrefix = data.getBlockCommentPrefix();
        int startBlockLine = document.getLineNumber(startOffset);
        int endBlockLine = document.getLineNumber(endOffset);
        if (document.getCharsSequence().subSequence(document.getLineStartOffset(startBlockLine), document.getLineEndOffset(startBlockLine)).toString().matches("\\s*\\Q" + commentPrefix + "\\E\\s*") && document.getCharsSequence().subSequence(document.getLineStartOffset(endBlockLine), document.getLineEndOffset(endBlockLine)).toString().matches("\\s*\\Q" + commentSuffix + "\\E\\s*")) {
            document.deleteString(document.getLineStartOffset(endBlockLine), document.getLineEndOffset(endBlockLine) + 1);
            document.deleteString(document.getLineStartOffset(startBlockLine), document.getLineEndOffset(startBlockLine) + 1);
            return;
        }
        document.deleteString(endOffset - commentSuffix.length(), endOffset);
        document.deleteString(startOffset, startOffset + commentPrefix.length());
    }

    @NotNull
    public TextRange insertBlockComment(int startOffset, int endOffset, Document document, MyCommenterData data) {
        int endLineNumber;
        int endLineStart;
        int startLineNumber = document.getLineNumber(startOffset);
        int startLineStart = document.getLineStartOffset(startLineNumber);
        if (startLineStart == startOffset && (endLineStart = document.getLineStartOffset(endLineNumber = document.getLineNumber(endOffset))) == endOffset) {
            String commentStart = data.getBlockCommentPrefix() + "\n";
            String commentEnd = data.getBlockCommentSuffix() + "\n";
            document.insertString(endOffset, (CharSequence)commentEnd);
            document.insertString(startOffset, (CharSequence)commentStart);
            TextRange textRange = new TextRange(startOffset, endOffset + commentStart.length() + commentEnd.length());
            if (textRange == null) {
                CfmlCommenter.$$$reportNull$$$0(20);
            }
            return textRange;
        }
        document.insertString(endOffset, (CharSequence)data.getBlockCommentSuffix());
        document.insertString(startOffset, (CharSequence)data.getBlockCommentPrefix());
        TextRange textRange = new TextRange(startOffset, endOffset + data.getBlockCommentSuffix().length() + data.getBlockCommentPrefix().length());
        if (textRange == null) {
            CfmlCommenter.$$$reportNull$$$0(21);
        }
        return textRange;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 20: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 20: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/coldFusion/UI/editorActions/typedHandlers/CfmlCommenter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/coldFusion/UI/editorActions/typedHandlers/CfmlCommenter";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "insertBlockComment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isOffsetWithinCfscript";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createLineCommentingState";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createBlockCommentingState";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "commentLine";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "uncommentLine";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isLineCommented";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getCommentPrefix";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getBlockCommentRange";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getBlockCommentPrefix";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getBlockCommentSuffix";
                break;
            }
            case 20: 
            case 21: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 20: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class MyCommenterData
    extends CommenterDataHolder {
        private final boolean myIsWithinCfscript;
        private final int myStartOffset;

        private MyCommenterData(boolean isWithinCfscript, int startOffset) {
            this.myIsWithinCfscript = isWithinCfscript;
            this.myStartOffset = startOffset;
        }

        public boolean isIsWithinCfscript() {
            return this.myIsWithinCfscript;
        }

        public String getLineCommentPrefix() {
            if (this.myIsWithinCfscript) {
                return CfmlCommenter.CF_SCRIPT_LINE_COMMENT_PREFIX;
            }
            return CfmlCommenter.CFML_COMMENT_PREFIX;
        }

        public String getBlockCommentSuffix() {
            if (this.myIsWithinCfscript) {
                return CfmlCommenter.CF_SCRIPT_BLOCK_COMMENT_SUFFIX;
            }
            return CfmlCommenter.CFML_COMMENT_SUFFIX;
        }

        public String getBlockCommentPrefix() {
            if (this.myIsWithinCfscript) {
                return CfmlCommenter.CF_SCRIPT_BLOCK_COMMENT_PREFIX;
            }
            return CfmlCommenter.CFML_COMMENT_PREFIX;
        }

        public int getStartOffset() {
            return this.myStartOffset;
        }
    }
}

