/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coldFusion.UI.runner;

import com.intellij.coldFusion.CfmlBundle;
import com.intellij.coldFusion.UI.runner.CfmlRunConfiguration;
import com.intellij.coldFusion.UI.runner.CfmlRunConfigurationType;
import com.intellij.coldFusion.UI.runner.CfmlRunnerParameters;
import com.intellij.coldFusion.model.files.CfmlFileType;
import com.intellij.coldFusion.model.files.CfmlFileViewProvider;
import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.ide.scratch.ScratchFileType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.PathUtil;
import java.net.MalformedURLException;
import java.net.URL;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CfmlRunConfigurationProducer
extends RunConfigurationProducer<CfmlRunConfiguration> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.coldFusion.UI.runner.CfmlRunConfigurationProducer");
    public static final String WWW_ROOT = "wwwroot";
    public static final String DEFAULT_HOST = "http://localhost:8500";

    public CfmlRunConfigurationProducer() {
        super(CfmlRunConfigurationType.class);
    }

    protected boolean setupConfigurationFromContext(CfmlRunConfiguration configuration, ConfigurationContext context, Ref<PsiElement> sourceElement) {
        String serverUrl;
        VirtualFile root;
        Location location = context.getLocation();
        if (!(location instanceof PsiLocation)) {
            return false;
        }
        PsiElement element = location.getPsiElement();
        PsiFile containingFile = element.getContainingFile();
        if (!CfmlRunConfigurationProducer.isValid(containingFile)) {
            return false;
        }
        VirtualFile file = containingFile.getVirtualFile();
        sourceElement.set((Object)containingFile);
        if (!FileTypeManager.getInstance().isFileOfType(file, (FileType)ScratchFileType.INSTANCE) && (root = ProjectRootManager.getInstance((Project)element.getProject()).getFileIndex().getContentRootForFile(file)) == null) {
            return false;
        }
        if (configuration == null) {
            return false;
        }
        CfmlRunnerParameters params = configuration.getRunnerParameters();
        String urlStr = configuration.getRunnerParameters().getUrl();
        if (!urlStr.isEmpty()) {
            try {
                URL url = new URL(urlStr);
                serverUrl = url.getProtocol() + "://" + url.getAuthority();
            }
            catch (MalformedURLException e) {
                LOG.error(CfmlBundle.message("cfml.producer.error.url", urlStr));
                return false;
            }
        } else {
            serverUrl = DEFAULT_HOST;
            configuration.setFromDefaultHost(true);
        }
        String path = CfmlRunConfigurationProducer.buildPageUrl(context, file);
        if (StringUtil.endsWith((CharSequence)serverUrl, (CharSequence)"/") && !StringUtil.startsWith((CharSequence)path, (CharSequence)"/")) {
            params.setUrl(serverUrl + path);
        } else if (!StringUtil.endsWith((CharSequence)serverUrl, (CharSequence)"/") && !StringUtil.startsWith((CharSequence)path, (CharSequence)"/")) {
            params.setUrl(serverUrl + "/" + path);
        } else if (!StringUtil.endsWith((CharSequence)serverUrl, (CharSequence)"/") && StringUtil.startsWith((CharSequence)path, (CharSequence)"/")) {
            params.setUrl(serverUrl + path);
        } else if (StringUtil.endsWith((CharSequence)serverUrl, (CharSequence)"/") && StringUtil.startsWith((CharSequence)path, (CharSequence)"/")) {
            params.setUrl(serverUrl + path.substring(1));
        }
        configuration.setName(CfmlRunConfigurationProducer.generateName(containingFile));
        return true;
    }

    @NotNull
    private static String generateName(PsiFile containingFile) {
        String string = StringUtil.isNotEmpty((String)containingFile.getVirtualFile().getPath()) ? PathUtil.getFileName((String)containingFile.getVirtualFile().getPath()) : "";
        if (string == null) {
            CfmlRunConfigurationProducer.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    private static String buildPageUrl(ConfigurationContext context, VirtualFile file) {
        String result;
        String absolutePageUrl = file.getUrl();
        int wwwrootIndex = absolutePageUrl.indexOf(WWW_ROOT);
        if (wwwrootIndex == -1) {
            VirtualFile projectBaseDir = context.getProject().getBaseDir();
            String relativePath = FileUtil.getRelativePath((String)projectBaseDir.getPath(), (String)file.getPath(), (char)'/');
            result = projectBaseDir.getName() + "/" + relativePath;
        } else {
            result = absolutePageUrl.substring(wwwrootIndex + WWW_ROOT.length());
        }
        String string = result;
        if (string == null) {
            CfmlRunConfigurationProducer.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isConfigurationFromContext(CfmlRunConfiguration configuration, ConfigurationContext context) {
        Location location = context.getLocation();
        if (location == null) {
            return false;
        }
        PsiElement anchor = location.getPsiElement();
        PsiFile containingFile = anchor.getContainingFile();
        if (CfmlRunConfigurationProducer.isValid(containingFile)) {
            String path = CfmlRunConfigurationProducer.buildPageUrl(context, containingFile.getVirtualFile());
            String urlFromRunnerParameters = configuration.getRunnerParameters().getUrl();
            if (urlFromRunnerParameters.isEmpty()) {
                return false;
            }
            try {
                URL url = new URL(urlFromRunnerParameters);
                return StringUtil.equals((CharSequence)url.getPath(), (CharSequence)path);
            }
            catch (MalformedURLException e) {
                LOG.error(CfmlBundle.message("cfml.producer.error.url", urlFromRunnerParameters));
            }
        }
        return false;
    }

    private static boolean isValid(@Nullable PsiFile containingFile) {
        return containingFile != null && (containingFile.getFileType() == CfmlFileType.INSTANCE || containingFile.getViewProvider() instanceof CfmlFileViewProvider) && containingFile.getVirtualFile() != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/coldFusion/UI/runner/CfmlRunConfigurationProducer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "generateName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildPageUrl";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

