/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coldFusion.model;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.coldFusion.model.CfmlDocUtil;
import com.intellij.coldFusion.model.info.CfmlAttributeDescription;
import com.intellij.coldFusion.model.info.CfmlLangInfo;
import com.intellij.coldFusion.model.info.CfmlTagDescription;
import com.intellij.coldFusion.model.lexer.CfmlTokenTypes;
import com.intellij.coldFusion.model.lexer.CfscriptTokenTypes;
import com.intellij.coldFusion.model.parsers.CfmlKeywords;
import com.intellij.coldFusion.model.psi.CfmlImport;
import com.intellij.coldFusion.model.psi.CfmlReferenceExpression;
import com.intellij.coldFusion.model.psi.impl.CfmlTagImpl;
import com.intellij.lang.PsiBuilder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CfmlUtil {
    private static final String[] EMPTY_STRING_ARRAY = ArrayUtil.EMPTY_STRING_ARRAY;

    @Nullable
    public static VirtualFile findFileByLibTag(PsiFile originalFile, @NotNull String libtag) {
        VirtualFile base;
        if (libtag == null) {
            CfmlUtil.$$$reportNull$$$0(0);
        }
        Module module = (base = CfmlUtil.getRealVirtualFile(originalFile)) == null ? null : ModuleUtilCore.findModuleForFile((VirtualFile)base, (Project)originalFile.getProject());
        base = module == null ? null : module.getModuleFile();
        base = base == null ? null : base.getParent();
        libtag = StringUtil.trimStart((String)libtag, (String)"/");
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            VirtualFile virtualFile = CfmlUtil.getRealVirtualFile(originalFile);
            assert (virtualFile != null);
            base = virtualFile.getParent();
        }
        return VfsUtil.findRelativeFile((VirtualFile)base, (String[])libtag.split("/"));
    }

    @Nullable
    public static CfmlImport getImportByPrefix(@Nullable PsiElement context, @Nullable String prefix) {
        if (prefix == null || context == null) {
            return null;
        }
        Object[] cfmlImports = (CfmlImport[])PsiTreeUtil.getChildrenOfType((PsiElement)context.getContainingFile(), CfmlImport.class);
        if (cfmlImports == null) {
            return null;
        }
        return (CfmlImport)ContainerUtil.find((Object[])cfmlImports, anImport -> prefix.equalsIgnoreCase(anImport.getPrefix()));
    }

    public static boolean isSearchedScope(String scopeText) {
        return scopeText.equalsIgnoreCase("variables") || scopeText.equalsIgnoreCase("arguments") || scopeText.equalsIgnoreCase("url") || scopeText.equalsIgnoreCase("form");
    }

    public static boolean hasEqualScope(CfmlReferenceExpression ref1, CfmlReferenceExpression ref2) {
        if (ref1.getScope() == null && ref2.getScope() == null) {
            return true;
        }
        if (ref2.getScope() == null) {
            return CfmlUtil.isSearchedScope(ref1.getScope().getText());
        }
        if (ref1.getScope() == null) {
            return CfmlUtil.isSearchedScope(ref2.getScope().getText());
        }
        return ref2.getScope().getText().equalsIgnoreCase(ref1.getScope().getText());
    }

    public static Set<String> getTagList(@NotNull Project project) {
        if (project == null) {
            CfmlUtil.$$$reportNull$$$0(1);
        }
        return CfmlUtil.getCfmlLangInfo(project).getTagAttributes().keySet();
    }

    @NotNull
    private static Project anyProject(Project project) {
        if (project != null) {
            Project project2 = project;
            if (project2 == null) {
                CfmlUtil.$$$reportNull$$$0(2);
            }
            return project2;
        }
        Project[] projects = ProjectManager.getInstance().getOpenProjects();
        if (projects.length != 0) {
            Project project3 = projects[0];
            if (project3 == null) {
                CfmlUtil.$$$reportNull$$$0(3);
            }
            return project3;
        }
        Project project4 = ProjectManager.getInstance().getDefaultProject();
        if (project4 == null) {
            CfmlUtil.$$$reportNull$$$0(4);
        }
        return project4;
    }

    public static boolean hasAnyAttributes(String tagName, Project project) {
        if (CfmlUtil.isUserDefined(tagName)) {
            return true;
        }
        if (CfmlUtil.getCfmlLangInfo(project).getTagAttributes().get(tagName) != null && CfmlUtil.getCfmlLangInfo(project).getTagAttributes().get(tagName).getAttributes() != null) {
            return CfmlUtil.getCfmlLangInfo(project).getTagAttributes().get(tagName).getAttributes().size() != 0;
        }
        return false;
    }

    public static CfmlLangInfo getCfmlLangInfo(Project project) {
        if (ApplicationManager.getApplication() == null) {
            return CfmlLangInfo.getInstance(null);
        }
        return CfmlLangInfo.getInstance(CfmlUtil.anyProject(project));
    }

    public static Collection<CfmlAttributeDescription> getAttributes(String tagName, Project project) {
        if (CfmlUtil.getCfmlLangInfo(project).getTagAttributes().get(tagName) != null && CfmlUtil.getCfmlLangInfo(project).getTagAttributes().get(tagName).getAttributes() != null) {
            return Collections.unmodifiableCollection(CfmlUtil.getCfmlLangInfo(project).getTagAttributes().get(tagName).getAttributes());
        }
        return Collections.emptyList();
    }

    public static boolean isStandardTag(String tagName, Project project) {
        return CfmlUtil.getCfmlLangInfo(project).getTagAttributes().containsKey(tagName);
    }

    public static boolean isUserDefined(String tagName) {
        return tagName != null && (tagName.toLowerCase().startsWith("cf_") || tagName.contains(":"));
    }

    public static boolean isSingleCfmlTag(String tagName, Project project) {
        if (CfmlUtil.isUserDefined(tagName)) {
            return false;
        }
        if (!CfmlUtil.getCfmlLangInfo(project).getTagAttributes().containsKey(tagName)) {
            return false;
        }
        return !CfmlUtil.getCfmlLangInfo(project).getTagAttributes().get(tagName).isEndTagRequired() && CfmlUtil.getCfmlLangInfo(project).getTagAttributes().get(tagName).isSingle();
    }

    public static boolean isEndTagRequired(String tagName, Project project) {
        if (!CfmlUtil.getCfmlLangInfo(project).getTagAttributes().containsKey(tagName)) {
            return true;
        }
        return CfmlUtil.getCfmlLangInfo(project).getTagAttributes().get(tagName).isEndTagRequired();
    }

    public static String getTagDescription(String tagName, Project project) {
        return CfmlDocUtil.tagDescription(tagName, project);
    }

    public static String getAttributeDescription(String tagName, String attributeName, Project project) {
        CfmlAttributeDescription cfmlAttributeDescription = CfmlUtil.getAttribute(tagName, attributeName, project);
        return CfmlDocUtil.attributeDescription(tagName, cfmlAttributeDescription, project);
    }

    @Nullable
    public static CfmlAttributeDescription getAttribute(String tagName, String attributeName, Project project) {
        CfmlTagDescription tagDescription2 = CfmlUtil.getCfmlLangInfo(project).getTagAttributes().get(tagName);
        if (tagDescription2 == null) {
            return null;
        }
        Collection<CfmlAttributeDescription> attributesCollection = tagDescription2.getAttributes();
        for (CfmlAttributeDescription af : attributesCollection) {
            if (!af.acceptName(attributeName)) continue;
            return af;
        }
        return null;
    }

    public static boolean isControlToken(IElementType type) {
        return type == CfmlTokenTypes.OPENER || type == CfmlTokenTypes.CLOSER || type == CfmlTokenTypes.LSLASH_ANGLEBRACKET || type == CfmlTokenTypes.R_ANGLEBRACKET || type == CfscriptTokenTypes.L_CURLYBRACKET || type == CfscriptTokenTypes.SEMICOLON;
    }

    public static boolean isActionName(PsiBuilder builder) {
        String tokenText = builder.getTokenText();
        if (tokenText == null) {
            return false;
        }
        String name = tokenText.toLowerCase();
        boolean isKeyword = Arrays.stream(CfmlKeywords.values()).anyMatch(cfmlKeyword -> cfmlKeyword.getKeyword().equals(name));
        return isKeyword && CfmlUtil.checkAheadActionTokens(builder.lookAhead(1), builder.lookAhead(2));
    }

    private static boolean checkAheadActionTokens(@Nullable IElementType second, @Nullable IElementType third) {
        return second == CfscriptTokenTypes.IDENTIFIER || second == CfscriptTokenTypes.L_CURLYBRACKET || second == CfmlTokenTypes.ASSIGN && third == CfscriptTokenTypes.L_CURLYBRACKET;
    }

    public static String[] getPredifinedFunctions(Project project) {
        return CfmlUtil.getCfmlLangInfo(project).getPredefinedFunctions();
    }

    public static boolean isPredefinedFunction(String functionName, Project project) {
        return ArrayUtil.find((Object[])CfmlUtil.getCfmlLangInfo(project).getPredefinedFunctionsInLowCase(), (Object)functionName.toLowerCase()) != -1;
    }

    public static boolean isPredefinedTagVariables(CfmlReferenceExpression cfmlRef, Project project) {
        String predefVarText = cfmlRef.getLastChild() != null ? cfmlRef.getLastChild().getText() : null;
        PsiElement referenceName = cfmlRef.getFirstChild();
        if (!(referenceName instanceof CfmlReferenceExpression) || predefVarText == null) {
            return false;
        }
        PsiElement psiElement = referenceName = (referenceName = ((CfmlReferenceExpression)referenceName).resolve()) != null ? referenceName.getParent() : null;
        if (!(referenceName instanceof CfmlTagImpl)) {
            return false;
        }
        String tagName = ((CfmlTagImpl)referenceName).getTagName();
        String tagNameWithoutCf = tagName.startsWith("cf") ? tagName.substring(2) : tagName;
        return CfmlUtil.getCfmlLangInfo(project).getPredefinedVariables().keySet().contains(tagNameWithoutCf.toLowerCase() + "." + predefVarText.toLowerCase());
    }

    @NotNull
    public static String[] getAttributeValues(String tagName, String attributeName, Project project) {
        CfmlAttributeDescription attribute = CfmlUtil.getAttribute(tagName, attributeName, project);
        if (attribute != null) {
            String[] values = attribute.getValues();
            String[] stringArray = values != null ? values : EMPTY_STRING_ARRAY;
            if (stringArray == null) {
                CfmlUtil.$$$reportNull$$$0(5);
            }
            return stringArray;
        }
        if (EMPTY_STRING_ARRAY == null) {
            CfmlUtil.$$$reportNull$$$0(6);
        }
        return EMPTY_STRING_ARRAY;
    }

    @NotNull
    public static String[] getCreateObjectArgumentValues() {
        String[] stringArray = new String[]{"component", "java", "com", "corba", "webservice"};
        if (stringArray == null) {
            CfmlUtil.$$$reportNull$$$0(7);
        }
        return stringArray;
    }

    public static String[] getVariableScopes(Project project) {
        return CfmlUtil.getCfmlLangInfo(project).getVariableScopes();
    }

    @NotNull
    public static String getFileName(PsiElement element) {
        String fileName = element.getContainingFile().getName();
        if (fileName.indexOf(46) == -1) {
            String string = fileName;
            if (string == null) {
                CfmlUtil.$$$reportNull$$$0(8);
            }
            return string;
        }
        String string = fileName.substring(0, fileName.indexOf(46));
        if (string == null) {
            CfmlUtil.$$$reportNull$$$0(9);
        }
        return string;
    }

    public static void showCompletion(Editor editor) {
        AutoPopupController.getInstance((Project)editor.getProject()).autoPopupMemberLookup(editor, null);
    }

    @Nullable
    public static VirtualFile getRealVirtualFile(PsiFile psiFile) {
        return psiFile.getOriginalFile().getVirtualFile();
    }

    public static Couple<String> getPrefixAndName(String name) {
        if (name == null) {
            return Couple.getEmpty();
        }
        int index = name.indexOf(58);
        if (index == -1) {
            return Couple.of(null, (Object)name);
        }
        return Couple.of((Object)name.substring(0, index), (Object)name.substring(index + 1));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libtag";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/coldFusion/model/CfmlUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/coldFusion/model/CfmlUtil";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "anyProject";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributeValues";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCreateObjectArgumentValues";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findFileByLibTag";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getTagList";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

