/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coldFusion.model.files;

import com.intellij.coldFusion.model.CfmlLanguage;
import com.intellij.coldFusion.model.parsers.CfmlElementTypes;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.StdLanguages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.MultiplePsiFilesPerDocumentFileViewProvider;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.psi.SqlLanguage;
import gnu.trove.THashSet;
import java.util.Arrays;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CfmlFileViewProvider
extends MultiplePsiFilesPerDocumentFileViewProvider
implements TemplateLanguageFileViewProvider {
    private static final THashSet<Language> ourRelevantLanguages = new THashSet(Arrays.asList(new Language[]{StdLanguages.HTML, CfmlLanguage.INSTANCE}));

    public CfmlFileViewProvider(PsiManager manager, VirtualFile virtualFile, boolean physical) {
        super(manager, virtualFile, physical);
    }

    @NotNull
    public Language getBaseLanguage() {
        CfmlLanguage cfmlLanguage = CfmlLanguage.INSTANCE;
        if (cfmlLanguage == null) {
            CfmlFileViewProvider.$$$reportNull$$$0(0);
        }
        return cfmlLanguage;
    }

    @NotNull
    public Set<Language> getLanguages() {
        THashSet<Language> tHashSet = ourRelevantLanguages;
        if (tHashSet == null) {
            CfmlFileViewProvider.$$$reportNull$$$0(1);
        }
        return tHashSet;
    }

    @Nullable
    protected PsiFile createFile(@NotNull Language lang) {
        if (lang == null) {
            CfmlFileViewProvider.$$$reportNull$$$0(2);
        }
        if (lang == this.getTemplateDataLanguage()) {
            PsiFileImpl file = (PsiFileImpl)((ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(StdLanguages.HTML)).createFile((FileViewProvider)this);
            file.setContentElementType((IElementType)CfmlElementTypes.TEMPLATE_DATA);
            return file;
        }
        if (lang == SqlLanguage.INSTANCE) {
            PsiFileImpl file = (PsiFileImpl)((ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage((Language)SqlLanguage.INSTANCE)).createFile((FileViewProvider)this);
            file.setContentElementType(CfmlElementTypes.SQL_DATA);
            return file;
        }
        if (lang == this.getBaseLanguage()) {
            return ((ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(lang)).createFile((FileViewProvider)this);
        }
        return null;
    }

    @NotNull
    protected CfmlFileViewProvider cloneInner(@NotNull VirtualFile copy) {
        if (copy == null) {
            CfmlFileViewProvider.$$$reportNull$$$0(3);
        }
        CfmlFileViewProvider cfmlFileViewProvider = new CfmlFileViewProvider((PsiManager)this.getManager(), copy, false);
        if (cfmlFileViewProvider == null) {
            CfmlFileViewProvider.$$$reportNull$$$0(4);
        }
        return cfmlFileViewProvider;
    }

    @NotNull
    public Language getTemplateDataLanguage() {
        Language language = StdLanguages.HTML;
        if (language == null) {
            CfmlFileViewProvider.$$$reportNull$$$0(5);
        }
        return language;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/coldFusion/model/files/CfmlFileViewProvider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lang";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseLanguage";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguages";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/coldFusion/model/files/CfmlFileViewProvider";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "cloneInner";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplateDataLanguage";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createFile";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "cloneInner";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

