/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coldFusion.model.formatter;

import com.intellij.coldFusion.model.formatter.CfmlFormatterUtil;
import com.intellij.coldFusion.model.lexer.CfmlTokenTypes;
import com.intellij.coldFusion.model.lexer.CfscriptTokenTypes;
import com.intellij.coldFusion.model.parsers.CfmlElementTypes;
import com.intellij.coldFusion.model.psi.CfmlTag;
import com.intellij.coldFusion.model.psi.stubs.CfmlStubElementTypes;
import com.intellij.formatting.Indent;
import com.intellij.lang.ASTNode;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;

public class CfmlIndentProcessor
extends CfmlFormatterUtil {
    private final CommonCodeStyleSettings mySettings;
    private final int myIndentSize;

    CfmlIndentProcessor(CommonCodeStyleSettings settings, int indentSize) {
        this.mySettings = settings;
        this.myIndentSize = indentSize;
    }

    Indent getChildIndent(ASTNode child) {
        int braceStyle;
        IElementType myType = child.getElementType();
        ASTNode parent = child.getTreeParent();
        IElementType parentType = parent != null ? parent.getElementType() : null;
        IElementType superParentType = parent != null && parent.getTreeParent() != null ? parent.getTreeParent().getElementType() : null;
        int n = braceStyle = myType == CfmlElementTypes.FUNCTIONBODY || superParentType == CfmlElementTypes.FUNCTIONBODY ? this.mySettings.METHOD_BRACE_STYLE : this.mySettings.BRACE_STYLE;
        if (parentType == CfmlStubElementTypes.CFML_FILE || myType == CfmlTokenTypes.LSLASH_ANGLEBRACKET) {
            return Indent.getNoneIndent();
        }
        if (!(parentType != CfmlElementTypes.TAG && parentType != CfmlElementTypes.FORTAGEXPRESSION && parentType != CfmlElementTypes.COMPONENT_TAG && parentType != CfmlElementTypes.FUNCTION_DEFINITION && parentType != CfmlElementTypes.FUNCTION_TAG || myType != CfmlElementTypes.TAG && myType != CfmlElementTypes.FUNCTION_TAG && myType != CfmlElementTypes.PROPERTY_TAG && myType != CfmlElementTypes.ARGUMENT_TAG && myType != CfmlElementTypes.FORTAGEXPRESSION && myType != CfmlElementTypes.TEMPLATE_TEXT)) {
            if (parentType == CfmlElementTypes.TAG && myType == CfmlElementTypes.TAG && "cfif".equals(((CfmlTag)parent.getPsi()).getTagName()) && "cfelse".equals(((CfmlTag)child.getPsi()).getTagName())) {
                return Indent.getNoneIndent();
            }
            return Indent.getNormalIndent();
        }
        if (myType == CfmlTokenTypes.START_EXPRESSION) {
            return Indent.getNormalIndent();
        }
        if (myType == CfmlTokenTypes.COMMENT || myType == CfscriptTokenTypes.COMMENT) {
            if (this.mySettings.KEEP_FIRST_COLUMN_COMMENT) {
                return Indent.getAbsoluteNoneIndent();
            }
            return Indent.getNormalIndent();
        }
        if (myType == CfscriptTokenTypes.R_CURLYBRACKET || myType == CfscriptTokenTypes.L_CURLYBRACKET) {
            switch (braceStyle) {
                case 1: {
                    return Indent.getNoneIndent();
                }
                case 2: {
                    return Indent.getNoneIndent();
                }
                case 5: {
                    return Indent.getNoneIndent();
                }
                case 3: {
                    return Indent.getNormalIndent();
                }
                case 4: {
                    return Indent.getNormalIndent();
                }
            }
            return Indent.getNoneIndent();
        }
        if (myType == CfmlTokenTypes.ASSIGN) {
            return Indent.getNormalIndent();
        }
        if (CfmlIndentProcessor.isAssignmentOperator(myType)) {
            return Indent.getSpaceIndent((int)(this.myIndentSize * 2));
        }
        if (myType == CfmlElementTypes.FUNCTION_CALL_EXPRESSION && FormatterUtil.isPrecededBy((ASTNode)child, (TokenSet)ASSIGNMENT_OPERATORS) && parentType != CfmlElementTypes.ASSIGNMENT) {
            return Indent.getSpaceIndent((int)(this.myIndentSize * 2));
        }
        if ((myType == CfmlElementTypes.REFERENCE_EXPRESSION || myType == CfmlElementTypes.BINARY_EXPRESSION) && FormatterUtil.isPrecededBy((ASTNode)child, (TokenSet)ASSIGNMENT_OPERATORS) && parentType != CfmlElementTypes.ASSIGNMENT) {
            return Indent.getSpaceIndent((int)(this.myIndentSize * 2));
        }
        if (myType == CfmlElementTypes.FUNCTION_CALL_EXPRESSION || myType == CfmlElementTypes.SWITCHEXPRESSION || myType == CfmlElementTypes.ASSIGNMENT || myType == CfmlElementTypes.FOREXPRESSION || myType == CfmlElementTypes.IFEXPRESSION || myType == CfmlElementTypes.WHILEEXPRESSION || myType == CfmlElementTypes.CASEEXPRESSION || myType == CfmlElementTypes.DOWHILEEXPRESSION || myType == CfscriptTokenTypes.BREAK_KEYWORD || myType == CfmlElementTypes.TRYCATCHEXPRESSION || myType == CfmlElementTypes.FUNCTION_DEFINITION || myType == CfscriptTokenTypes.RETURN_KEYWORD || parentType == CfmlElementTypes.BLOCK_OF_STATEMENTS) {
            if (parentType != CfmlElementTypes.SCRIPT_TAG) {
                if (superParentType == CfmlElementTypes.FUNCTIONBODY && this.mySettings.METHOD_BRACE_STYLE == 4) {
                    return Indent.getSpaceIndent((int)(this.myIndentSize * 2));
                }
                if (superParentType != CfmlElementTypes.FUNCTIONBODY && this.mySettings.BRACE_STYLE == 4) {
                    return Indent.getSpaceIndent((int)(this.myIndentSize * 2));
                }
                if (myType == IFEXPRESSION && this.mySettings.SPECIAL_ELSE_IF_TREATMENT && FormatterUtil.isPrecededBy((ASTNode)child, (IElementType)CfscriptTokenTypes.ELSE_KEYWORD)) {
                    return Indent.getNoneIndent();
                }
            }
            return Indent.getNormalIndent();
        }
        if (myType == CfmlElementTypes.BLOCK_OF_STATEMENTS || myType == CfmlElementTypes.ARGUMENT_LIST || myType == CfscriptTokenTypes.ELSE_KEYWORD || myType == CfmlElementTypes.CATCHEXPRESSION || myType == CfmlElementTypes.FUNCTIONBODY || myType == CfmlElementTypes.NONE) {
            return Indent.getNoneIndent();
        }
        if (myType == CfmlElementTypes.REFERENCE_EXPRESSION && parentType != CfmlElementTypes.FUNCTION_CALL_EXPRESSION && parentType != CfmlElementTypes.FUNCTION_DEFINITION && parentType != CfmlElementTypes.ASSIGNMENT && parentType != CfmlElementTypes.BINARY_EXPRESSION && parentType != CfmlElementTypes.NONE && parentType != CfmlElementTypes.REFERENCE_EXPRESSION) {
            return Indent.getNormalIndent();
        }
        if (parentType == CfmlElementTypes.ASSIGNMENT) {
            return child.getTreePrev() != null ? Indent.getNormalIndent() : Indent.getNoneIndent();
        }
        if (parentType == CfmlElementTypes.BINARY_EXPRESSION) {
            return Indent.getNoneIndent();
        }
        if (myType == CfmlElementTypes.BINARY_EXPRESSION) {
            return Indent.getSpaceIndent((int)(this.myIndentSize * 2));
        }
        if (myType == CfmlElementTypes.PROPERTY) {
            return Indent.getNormalIndent();
        }
        if (myType == CfmlElementTypes.SCRIPT_TAG) {
            return Indent.getNormalIndent();
        }
        if (myType == ACTION) {
            return Indent.getNormalIndent();
        }
        return null;
    }
}

