/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coldFusion.model.parsers;

import com.intellij.coldFusion.model.CfmlLanguage;
import com.intellij.coldFusion.model.lexer.CfscriptTokenTypes;
import com.intellij.coldFusion.model.psi.CfmlArgumentList;
import com.intellij.coldFusion.model.psi.CfmlArgumentNameReference;
import com.intellij.coldFusion.model.psi.CfmlAssignmentExpression;
import com.intellij.coldFusion.model.psi.CfmlComponentConstructorCall;
import com.intellij.coldFusion.model.psi.CfmlComponentReference;
import com.intellij.coldFusion.model.psi.CfmlCompositeElement;
import com.intellij.coldFusion.model.psi.CfmlCompositeElementType;
import com.intellij.coldFusion.model.psi.CfmlElementType;
import com.intellij.coldFusion.model.psi.CfmlFunctionCallExpression;
import com.intellij.coldFusion.model.psi.CfmlLeafElementType;
import com.intellij.coldFusion.model.psi.CfmlLiteralExpressionType;
import com.intellij.coldFusion.model.psi.CfmlNewExpression;
import com.intellij.coldFusion.model.psi.CfmlOperatorExpression;
import com.intellij.coldFusion.model.psi.CfmlParametersList;
import com.intellij.coldFusion.model.psi.CfmlReferenceExpression;
import com.intellij.coldFusion.model.psi.CfmlStringLiteralExpressionType;
import com.intellij.coldFusion.model.psi.CfmlSuperComponentReference;
import com.intellij.coldFusion.model.psi.CfmlThisComponentReference;
import com.intellij.coldFusion.model.psi.impl.CfmlAttributeImpl;
import com.intellij.coldFusion.model.psi.impl.CfmlAttributeNameImpl;
import com.intellij.coldFusion.model.psi.impl.CfmlForImpl;
import com.intellij.coldFusion.model.psi.impl.CfmlFunctionImpl;
import com.intellij.coldFusion.model.psi.impl.CfmlFunctionParameterImpl;
import com.intellij.coldFusion.model.psi.impl.CfmlImportImpl;
import com.intellij.coldFusion.model.psi.impl.CfmlNamedAttributeImpl;
import com.intellij.coldFusion.model.psi.impl.CfmlPropertyImpl;
import com.intellij.coldFusion.model.psi.impl.CfmlScriptImportImpl;
import com.intellij.coldFusion.model.psi.impl.CfmlTagFunctionImpl;
import com.intellij.coldFusion.model.psi.impl.CfmlTagFunctionParameterImpl;
import com.intellij.coldFusion.model.psi.impl.CfmlTagImpl;
import com.intellij.coldFusion.model.psi.impl.CfmlTagInvokeImpl;
import com.intellij.coldFusion.model.psi.impl.CfmlTagLoopImpl;
import com.intellij.coldFusion.model.psi.impl.CfmlTagPropertyImpl;
import com.intellij.coldFusion.model.psi.impl.CfmlTagScriptImpl;
import com.intellij.coldFusion.model.psi.stubs.CfmlStubElementTypes;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.psi.PsiElement;
import com.intellij.psi.templateLanguages.TemplateDataElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;

public interface CfmlElementTypes
extends CfmlStubElementTypes {
    public static final IElementType CF_SCRIPT = new CfmlElementType("CF_SCRIPT");
    public static final IElementType TEMPLATE_TEXT = new CfmlLeafElementType("CFML_TEMPLATE_TEXT");
    public static final IElementType OUTER_ELEMENT_TYPE = new CfmlElementType("CFML_FRAGMENT");
    public static final IElementType SQL = new CfmlElementType("SQL");
    public static final IElementType SQL_DATA = new TemplateDataElementType("SQL_DATA", (Language)CfmlLanguage.INSTANCE, SQL, OUTER_ELEMENT_TYPE);
    public static final TemplateDataElementType TEMPLATE_DATA = new TemplateDataElementType("CFML_TEMPLATE_DATA", (Language)CfmlLanguage.INSTANCE, TEMPLATE_TEXT, OUTER_ELEMENT_TYPE);
    public static final IElementType VALUE = new CfmlCompositeElementType("VALUE");
    public static final IElementType TYPE = new CfmlCompositeElementType("TYPE");
    public static final IElementType IFEXPRESSION = new CfmlCompositeElementType("IFEXPRESSION");
    public static final IElementType WHILEEXPRESSION = new CfmlCompositeElementType("WHILEEXPRESSION");
    public static final IElementType DOWHILEEXPRESSION = new CfmlCompositeElementType("DOWHILEEXPRESSION");
    public static final IElementType FORVARIABLE = new CfmlCompositeElementType("FORVARIABLE"){

        @Override
        public PsiElement createPsiElement(ASTNode node) {
            return new CfmlForImpl.Variable(node);
        }
    };
    public static final IElementType FOREXPRESSION = new CfmlCompositeElementType("FOREXPRESSION"){

        @Override
        public PsiElement createPsiElement(ASTNode node) {
            return new CfmlForImpl(node);
        }
    };
    public static final IElementType FORTAGINDEXATTRIBUTE = new CfmlCompositeElementType("FORTAGINDEXATTRIBUTE"){

        @Override
        public PsiElement createPsiElement(ASTNode node) {
            return new CfmlTagLoopImpl.Variable(node);
        }
    };
    public static final IElementType FORTAGEXPRESSION = new CfmlCompositeElementType("FORTAGEXPRESSION"){

        @Override
        public PsiElement createPsiElement(ASTNode node) {
            return new CfmlTagLoopImpl(node);
        }
    };
    public static final IElementType FUNCTIONBODY = new CfmlCompositeElementType("FUNCTIONBODY");
    public static final IElementType PROPERTY = new CfmlCompositeElementType("PROPERTY"){

        @Override
        public PsiElement createPsiElement(ASTNode node) {
            return new CfmlPropertyImpl(node);
        }
    };
    public static final IElementType ACTION = new CfmlCompositeElementType("ACTION");
    public static final IElementType SWITCHEXPRESSION = new CfmlCompositeElementType("SWITCHEXPRESSION");
    public static final IElementType CASEEXPRESSION = new CfmlCompositeElementType("CASEEXPRESSION");
    public static final IElementType TRYCATCHEXPRESSION = new CfmlCompositeElementType("TRYCATCHEXPRESSION");
    public static final IElementType BLOCK_OF_STATEMENTS = new CfmlCompositeElementType("BLOCK_OF_STATEMENTS");
    public static final IElementType CATCHEXPRESSION = new CfmlCompositeElementType("CATCH_EXPRESSION");
    public static final IElementType INCLUDEEXPRESSION = new CfmlCompositeElementType("INCLUDE_EXPRESSION");
    public static final IElementType IMPORTEXPRESSION = new CfmlCompositeElementType("IMPORT_EXPRESSION"){

        @Override
        public PsiElement createPsiElement(ASTNode node) {
            return new CfmlScriptImportImpl(node);
        }
    };
    public static final IElementType FUNCTION_ARGUMENT = new CfmlCompositeElementType("FUNCTION_ARGUMENT"){

        @Override
        public PsiElement createPsiElement(ASTNode node) {
            return new CfmlFunctionParameterImpl(node);
        }
    };
    public static final IElementType COMPONENT_REFERENCE = new CfmlCompositeElementType("COMPONENT_REFERENCE"){

        @Override
        public PsiElement createPsiElement(ASTNode node) {
            return new CfmlComponentReference(node);
        }
    };
    public static final IElementType COMPONENT_CONSTRUCTOR_CALL = new CfmlCompositeElementType("COMPONENT_CONSTRUCTOR_CALL"){

        @Override
        public PsiElement createPsiElement(ASTNode node) {
            return new CfmlComponentConstructorCall(node);
        }
    };
    public static final CfmlCompositeElementType TAG_IMPORT = new CfmlCompositeElementType("ImportTag"){

        @Override
        public PsiElement createPsiElement(ASTNode node) {
            return new CfmlImportImpl(node);
        }
    };
    public static final CfmlCompositeElementType NEW_EXPRESSION = new CfmlCompositeElementType("NewExpression"){

        @Override
        public PsiElement createPsiElement(ASTNode node) {
            return new CfmlNewExpression(node);
        }
    };
    public static final CfmlCompositeElementType SCRIPT_EXPRESSION = new CfmlCompositeElementType("SomeScriptExression");
    public static final CfmlCompositeElementType REFERENCE_EXPRESSION = new CfmlCompositeElementType("ReferenceExpression"){

        @Override
        public PsiElement createPsiElement(ASTNode node) {
            if ("super".equalsIgnoreCase(node.getText())) {
                return new CfmlSuperComponentReference(node);
            }
            if ("this".equalsIgnoreCase(node.getText())) {
                return new CfmlThisComponentReference(node);
            }
            return new CfmlReferenceExpression(node);
        }
    };
    public static final CfmlCompositeElementType FUNCTION_CALL_EXPRESSION = new CfmlCompositeElementType("FunctionCallExpression"){

        @Override
        public PsiElement createPsiElement(ASTNode node) {
            return new CfmlFunctionCallExpression(node);
        }
    };
    public static final CfmlCompositeElementType FUNCTION_DEFINITION = new CfmlCompositeElementType("FunctionDefinition"){

        @Override
        public PsiElement createPsiElement(ASTNode node) {
            return new CfmlFunctionImpl(node);
        }
    };
    public static final CfmlCompositeElementType TAG_FUNCTION_CALL = new CfmlCompositeElementType("FunctionInvoke"){

        @Override
        public PsiElement createPsiElement(ASTNode node) {
            return new CfmlTagInvokeImpl(node);
        }
    };
    public static final CfmlCompositeElementType PARAMETERS_LIST = new CfmlCompositeElementType("ParametersList"){

        @Override
        public PsiElement createPsiElement(ASTNode node) {
            return new CfmlParametersList(node);
        }
    };
    public static final CfmlCompositeElementType ARGUMENT_LIST = new CfmlCompositeElementType("ArgumentList"){

        @Override
        public PsiElement createPsiElement(ASTNode node) {
            return new CfmlArgumentList(node);
        }
    };
    public static final CfmlCompositeElementType PROPERTY_TAG = new CfmlCompositeElementType("PropertyTag"){

        @Override
        public PsiElement createPsiElement(ASTNode node) {
            return new CfmlTagPropertyImpl(node);
        }
    };
    public static final CfmlCompositeElementType FUNCTION_TAG = new CfmlCompositeElementType("Tag"){

        @Override
        public PsiElement createPsiElement(ASTNode node) {
            return new CfmlTagFunctionImpl(node);
        }
    };
    public static final CfmlCompositeElementType INVOKE_TAG = new CfmlCompositeElementType("Tag"){

        @Override
        public PsiElement createPsiElement(ASTNode node) {
            return new CfmlTagInvokeImpl(node);
        }
    };
    public static final CfmlCompositeElementType ARGUMENT_TAG = new CfmlCompositeElementType("Tag"){

        @Override
        public PsiElement createPsiElement(ASTNode node) {
            return new CfmlTagFunctionParameterImpl(node);
        }
    };
    public static final CfmlCompositeElementType SCRIPT_TAG = new CfmlCompositeElementType("Tag"){

        @Override
        public PsiElement createPsiElement(ASTNode node) {
            return new CfmlTagScriptImpl(node);
        }
    };
    public static final CfmlCompositeElementType TAG = new CfmlCompositeElementType("Tag"){

        @Override
        public PsiElement createPsiElement(ASTNode node) {
            return new CfmlTagImpl(node);
        }
    };
    public static final CfmlCompositeElementType ATTRIBUTE = new CfmlCompositeElementType("Attribute"){

        @Override
        public PsiElement createPsiElement(ASTNode node) {
            return new CfmlAttributeImpl(node);
        }
    };
    public static final CfmlCompositeElementType UNARY_EXPRESSION = new CfmlCompositeElementType("UnaryExpression"){

        @Override
        public PsiElement createPsiElement(ASTNode node) {
            return new CfmlOperatorExpression(node, false);
        }
    };
    public static final CfmlCompositeElementType TERNARY_EXPRESSION = new CfmlCompositeElementType("TernaryExpression");
    public static final CfmlCompositeElementType BINARY_EXPRESSION = new CfmlCompositeElementType("BinaryExpression"){

        @Override
        public PsiElement createPsiElement(ASTNode node) {
            return new CfmlOperatorExpression(node, true);
        }
    };
    public static final CfmlCompositeElementType NAMED_ATTRIBUTE = new CfmlCompositeElementType("NamedAttribute"){

        @Override
        public PsiElement createPsiElement(ASTNode node) {
            return new CfmlNamedAttributeImpl(node);
        }
    };
    public static final CfmlCompositeElementType ATTRIBUTE_NAME = new CfmlCompositeElementType("AttributeName"){

        @Override
        public PsiElement createPsiElement(ASTNode node) {
            return new CfmlAttributeNameImpl(node);
        }
    };
    public static final CfmlCompositeElementType ATTRIBUTE_VALUE = new CfmlCompositeElementType("AttributeValue");
    public static final CfmlCompositeElementType NONE = new CfmlCompositeElementType("None");
    public static final CfmlCompositeElementType ASSIGNMENT = new CfmlCompositeElementType("Assignment"){

        @Override
        public PsiElement createPsiElement(ASTNode node) {
            return new CfmlAssignmentExpression(node);
        }
    };
    public static final CfmlCompositeElementType INTEGER_LITERAL = new CfmlLiteralExpressionType("IntegerLiteral", "java.lang.Integer");
    public static final CfmlCompositeElementType DOUBLE_LITERAL = new CfmlLiteralExpressionType("DoubleLiteral", "java.lang.Double");
    public static final CfmlCompositeElementType BOOLEAN_LITERAL = new CfmlLiteralExpressionType("BooleanLiteral", "java.lang.Boolean");
    public static final CfmlCompositeElementType STRING_LITERAL = new CfmlStringLiteralExpressionType();
    public static final CfmlCompositeElementType ARGUMENT_NAME = new CfmlCompositeElementType("ArgumentName"){

        @Override
        public PsiElement createPsiElement(ASTNode node) {
            if ("argumentCollection".equalsIgnoreCase(node.getText())) {
                return new CfmlCompositeElement(node);
            }
            return new CfmlArgumentNameReference(node);
        }
    };
    public static final TokenSet EXPRESSIONS = TokenSet.create((IElementType[])new IElementType[]{INTEGER_LITERAL, REFERENCE_EXPRESSION, DOUBLE_LITERAL, BOOLEAN_LITERAL, STRING_LITERAL, BINARY_EXPRESSION, CfscriptTokenTypes.L_BRACKET, CfscriptTokenTypes.R_BRACKET});
}

