/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coldFusion.model.parsers;

import com.intellij.coldFusion.CfmlBundle;
import com.intellij.coldFusion.model.lexer.CfmlTokenTypes;
import com.intellij.coldFusion.model.lexer.CfscriptTokenTypes;
import com.intellij.coldFusion.model.parsers.CfmlElementTypes;
import com.intellij.coldFusion.model.parsers.CfscriptParser;
import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.Nullable;

public class CfmlExpressionParser {
    private PsiBuilder myBuilder = null;

    public CfmlExpressionParser(PsiBuilder builder) {
        this.myBuilder = builder;
    }

    public boolean parseExpression() {
        if (this.myBuilder.getTokenType() == CfscriptTokenTypes.FUNCTION_KEYWORD) {
            new CfscriptParser().parseFunctionExpression(this.myBuilder, true);
        }
        PsiBuilder.Marker expr = this.myBuilder.mark();
        if (!this.parseBinaryExpression()) {
            expr.drop();
            return false;
        }
        if (this.getTokenType() == CfscriptTokenTypes.QUESTION) {
            this.advance();
            if (!this.parseExpression()) {
                this.myBuilder.error(CfmlBundle.message("cfml.parsing.expression.expected", new Object[0]));
                expr.drop();
                return true;
            }
            if (this.getTokenType() == CfscriptTokenTypes.DOTDOT) {
                this.advance();
                if (!this.parseExpression()) {
                    this.myBuilder.error(CfmlBundle.message("cfml.parsing.expression.expected", new Object[0]));
                    expr.drop();
                    return true;
                }
            } else {
                this.myBuilder.error(CfmlBundle.message("cfml.parsing.dot.dot.expected", new Object[0]));
                expr.drop();
                return true;
            }
            expr.done((IElementType)CfmlElementTypes.TERNARY_EXPRESSION);
        } else if (this.myBuilder.getTokenType() == CfscriptTokenTypes.ELVIS) {
            this.advance();
            if (!this.parseExpression()) {
                this.myBuilder.error(CfmlBundle.message("cfml.parsing.expression.expected", new Object[0]));
                expr.drop();
                return true;
            }
            expr.done((IElementType)CfmlElementTypes.BINARY_EXPRESSION);
        } else {
            expr.drop();
        }
        return true;
    }

    private boolean parseBinaryExpression() {
        PsiBuilder.Marker expr = this.myBuilder.mark();
        if (!this.parseRelationalExpression()) {
            expr.drop();
            return false;
        }
        while (CfscriptTokenTypes.LOGICAL_OPERATIONS.contains(this.myBuilder.getTokenType())) {
            this.myBuilder.advanceLexer();
            if (!this.parseRelationalExpression()) {
                this.myBuilder.error(CfmlBundle.message("cfml.parsing.expression.expected", new Object[0]));
            }
            expr.done((IElementType)CfmlElementTypes.BINARY_EXPRESSION);
            expr = expr.precede();
        }
        expr.drop();
        return true;
    }

    private boolean parseRelationalExpression() {
        PsiBuilder.Marker expr = this.myBuilder.mark();
        if (!this.parseAdditiveExpression()) {
            expr.drop();
            return false;
        }
        while (CfscriptTokenTypes.RELATIONAL_OPERATIONS.contains(this.myBuilder.getTokenType())) {
            this.myBuilder.advanceLexer();
            if (!this.parseAdditiveExpression()) {
                this.myBuilder.error(CfmlBundle.message("cfml.parsing.expression.expected", new Object[0]));
            }
            expr.done((IElementType)CfmlElementTypes.BINARY_EXPRESSION);
            expr = expr.precede();
        }
        expr.drop();
        return true;
    }

    private boolean parseAdditiveExpression() {
        PsiBuilder.Marker expr = this.myBuilder.mark();
        if (!this.parseMultiplicativeExpression()) {
            expr.drop();
            return false;
        }
        while (CfscriptTokenTypes.ADDITIVE_OPERATIONS.contains(this.myBuilder.getTokenType())) {
            this.myBuilder.advanceLexer();
            if (!this.parseMultiplicativeExpression()) {
                this.myBuilder.error(CfmlBundle.message("cfml.parsing.expression.expected", new Object[0]));
            }
            expr.done((IElementType)CfmlElementTypes.BINARY_EXPRESSION);
            expr = expr.precede();
        }
        expr.drop();
        return true;
    }

    private boolean parseMultiplicativeExpression() {
        PsiBuilder.Marker expr = this.myBuilder.mark();
        if (this.parseAssignmentIfValid()) {
            expr.drop();
            return true;
        }
        if (!this.parseUnaryExpression()) {
            expr.drop();
            return false;
        }
        while (CfscriptTokenTypes.MULTIPLICATIVE_OPERATIONS.contains(this.myBuilder.getTokenType())) {
            this.myBuilder.advanceLexer();
            if (!this.parseUnaryExpression()) {
                this.myBuilder.error(CfmlBundle.message("cfml.parsing.expression.expected", new Object[0]));
            }
            expr.done((IElementType)CfmlElementTypes.BINARY_EXPRESSION);
            expr = expr.precede();
        }
        expr.drop();
        return true;
    }

    private boolean parseAssignmentIfValid() {
        PsiBuilder.Marker marker = this.myBuilder.mark();
        if (!this.parseAssignmentExpression(false)) {
            marker.rollbackTo();
            return false;
        }
        marker.drop();
        return true;
    }

    private boolean parseUnaryExpression() {
        IElementType tokenType = this.myBuilder.getTokenType();
        if (CfscriptTokenTypes.UNARY_OPERATIONS.contains(tokenType)) {
            PsiBuilder.Marker expr = this.myBuilder.mark();
            this.myBuilder.advanceLexer();
            if (!this.parseUnaryExpression()) {
                this.myBuilder.error(CfmlBundle.message("cfml.parsing.expression.expected", new Object[0]));
            }
            expr.done((IElementType)CfmlElementTypes.UNARY_EXPRESSION);
            return true;
        }
        this.parseOperand();
        return true;
    }

    private boolean parseAssignmentExpression(boolean allowDotDot) {
        PsiBuilder.Marker statementMarker = this.myBuilder.mark();
        int statementMarkerPosition = this.myBuilder.getCurrentOffset();
        if (this.getTokenType() == CfscriptTokenTypes.VAR_KEYWORD) {
            this.advance();
        }
        if (!this.parseLValue()) {
            statementMarker.done((IElementType)CfmlElementTypes.SCRIPT_EXPRESSION);
            this.myBuilder.error(CfmlBundle.message("cfml.parsing.l.value.expected", new Object[0]));
            return false;
        }
        IElementType tokenType = this.getTokenType();
        if (!(tokenType == CfmlTokenTypes.ASSIGN || allowDotDot && tokenType == CfscriptTokenTypes.DOTDOT)) {
            statementMarker.done((IElementType)CfmlElementTypes.SCRIPT_EXPRESSION);
            this.myBuilder.error(CfmlBundle.message("cfml.parsing.assignment.expected", new Object[0]));
            return false;
        }
        this.advance();
        if (!this.parseRValue()) {
            statementMarker.done((IElementType)CfmlElementTypes.SCRIPT_EXPRESSION);
            this.myBuilder.error(CfmlBundle.message("cfml.parsing.right.operand.missed", new Object[0]));
            return false;
        }
        if (statementMarkerPosition != this.myBuilder.getCurrentOffset()) {
            statementMarker.done((IElementType)CfmlElementTypes.ASSIGNMENT);
        } else {
            statementMarker.drop();
        }
        return true;
    }

    public boolean parseRValue() {
        if (!this.parseStructureDefinition()) {
            PsiBuilder.Marker referenceExpression = this.myBuilder.mark();
            if (!this.parseNewExpression()) {
                referenceExpression.rollbackTo();
                if (!this.parseArrayDefinition() && !this.parseExpression()) {
                    return false;
                }
            } else if (this.myBuilder.getTokenType() == CfscriptTokenTypes.POINT) {
                referenceExpression.rollbackTo();
                this.parseReference(false);
            } else {
                referenceExpression.drop();
            }
        }
        return true;
    }

    public void parsePrefixOperationExpression() {
        if (!CfscriptTokenTypes.PREFIX_OPERATIONS.contains(this.getTokenType())) {
            return;
        }
        PsiBuilder.Marker prefixExpressionMarker = this.myBuilder.mark();
        this.advance();
        if (!this.parseLValue()) {
            this.myBuilder.error(CfmlBundle.message("cfml.parsing.l.value.expected", new Object[0]));
        }
        prefixExpressionMarker.done((IElementType)CfmlElementTypes.NONE);
    }

    public void parseStatement() {
        if (this.myBuilder.eof() || this.closeExpressionToken()) {
            return;
        }
        int offset = this.myBuilder.getCurrentOffset();
        if (CfscriptTokenTypes.PREFIX_OPERATIONS.contains(this.getTokenType())) {
            this.parsePrefixOperationExpression();
            return;
        }
        PsiBuilder.Marker statementMarker = this.myBuilder.mark();
        if (this.getTokenType() == CfscriptTokenTypes.VAR_KEYWORD) {
            this.parseAssignmentExpression(false);
            statementMarker.drop();
            return;
        }
        if (!this.parseLValue()) {
            statementMarker.drop();
            return;
        }
        boolean isClearAssign = false;
        boolean isProbableVariableDef = false;
        if (CfscriptTokenTypes.POSTFIX_OPERATIONS.contains(this.getTokenType())) {
            this.advance();
            statementMarker.done((IElementType)CfmlElementTypes.NONE);
            return;
        }
        if (!CfscriptTokenTypes.ASSIGN_OPERATORS.contains(this.getTokenType())) {
            this.myBuilder.error(CfmlBundle.message("cfml.parsing.statement.expected", new Object[0]));
            if (CfscriptTokenTypes.OPERATIONS.contains(this.getTokenType())) {
                this.advance();
                this.myBuilder.error(CfmlBundle.message("cfml.parsing.assignment.expected", new Object[0]));
                isClearAssign = true;
            }
        } else {
            isClearAssign = this.getTokenType() == CfmlTokenTypes.ASSIGN;
            isProbableVariableDef = isClearAssign;
            if (this.myBuilder.eof()) {
                statementMarker.drop();
                return;
            }
            this.advance();
        }
        if (!(isClearAssign && this.parseStructureDefinition() || isClearAssign && this.parseNewExpression() || isClearAssign && this.parseArrayDefinition() || this.parseExpression())) {
            if (offset == this.myBuilder.getCurrentOffset()) {
                statementMarker.drop();
                this.myBuilder.error(CfmlBundle.message("cfml.parsing.unexpected.token", new Object[0]));
                this.advance();
                return;
            }
            this.myBuilder.error(CfmlBundle.message("cfml.parsing.right.operand.missed", new Object[0]));
            statementMarker.drop();
            return;
        }
        if (offset == this.myBuilder.getCurrentOffset()) {
            statementMarker.drop();
            this.myBuilder.error(CfmlBundle.message("cfml.parsing.unexpected.token", new Object[0]));
            this.advance();
            return;
        }
        if (isProbableVariableDef) {
            statementMarker.done((IElementType)CfmlElementTypes.ASSIGNMENT);
        } else {
            statementMarker.drop();
        }
    }

    private boolean closeExpressionToken() {
        return this.getTokenType() == CfmlTokenTypes.END_EXPRESSION || this.getTokenType() == CfscriptTokenTypes.CLOSESHARP || this.getTokenType() == CfmlTokenTypes.CLOSER || this.getTokenType() == CfmlTokenTypes.R_ANGLEBRACKET || this.myBuilder.eof() || this.getTokenType() == CfscriptTokenTypes.R_BRACKET || this.getTokenType() == CfscriptTokenTypes.R_SQUAREBRACKET || this.getTokenType() == CfscriptTokenTypes.COMMA || this.getTokenType() == CfmlTokenTypes.ASSIGN || this.getTokenType() == CfmlTokenTypes.OPENER || this.getTokenType() == CfmlTokenTypes.LSLASH_ANGLEBRACKET || this.getTokenType() == CfscriptTokenTypes.SEMICOLON || this.getTokenType() == CfscriptTokenTypes.R_CURLYBRACKET || this.getTokenType() == CfscriptTokenTypes.L_CURLYBRACKET;
    }

    private void parseArrayAccess() {
        if (this.getTokenType() != CfscriptTokenTypes.L_SQUAREBRACKET) {
            return;
        }
        this.advance();
        this.parseExpression();
        if (this.getTokenType() != CfscriptTokenTypes.R_SQUAREBRACKET) {
            this.myBuilder.error(CfmlBundle.message("cfml.parsing.square.bracket.expected", new Object[0]));
        } else {
            this.advance();
        }
    }

    private boolean parseID(boolean ifSharpsInIDs) {
        if (!ifSharpsInIDs) {
            if (this.getTokenType() == CfscriptTokenTypes.IDENTIFIER || CfscriptTokenTypes.KEYWORDS.contains(this.getTokenType())) {
                this.advance();
                return true;
            }
        } else {
            if (this.getTokenType() != CfscriptTokenTypes.OPENSHARP && this.getTokenType() != CfscriptTokenTypes.IDENTIFIER) {
                return false;
            }
            while (this.getTokenType() == CfscriptTokenTypes.OPENSHARP || this.getTokenType() == CfscriptTokenTypes.IDENTIFIER) {
                while (this.getTokenType() == CfscriptTokenTypes.OPENSHARP) {
                    this.parseSharpExpr();
                }
                if (this.getTokenType() == CfscriptTokenTypes.IDENTIFIER) {
                    this.advance();
                }
                while (this.getTokenType() == CfscriptTokenTypes.OPENSHARP) {
                    this.parseSharpExpr();
                }
            }
            return true;
        }
        return false;
    }

    public void parseComponentReference() {
        assert (this.myBuilder.getTokenType() == CfscriptTokenTypes.IDENTIFIER);
        PsiBuilder.Marker componentReferenceMarker = this.myBuilder.mark();
        while (this.myBuilder.getTokenType() == CfscriptTokenTypes.IDENTIFIER || CfscriptTokenTypes.KEYWORDS.contains(this.myBuilder.getTokenType())) {
            this.myBuilder.advanceLexer();
            if (this.myBuilder.getTokenType() != CfscriptTokenTypes.POINT) break;
            this.myBuilder.advanceLexer();
        }
        componentReferenceMarker.done(CfmlElementTypes.COMPONENT_REFERENCE);
    }

    public boolean parseReference(boolean ifSharpsInIDs) {
        boolean isReference = false;
        PsiBuilder.Marker referenceExpression = this.myBuilder.mark();
        boolean start = true;
        while (this.getTokenType() == CfscriptTokenTypes.POINT || start) {
            int arrayAccessNumber;
            if (start) {
                if (this.getTokenType() == CfscriptTokenTypes.SCOPE_KEYWORD) {
                    this.advance();
                    if (this.getTokenType() == CfscriptTokenTypes.POINT) {
                        this.advance();
                    } else {
                        this.myBuilder.error(CfmlBundle.message("cfml.parsing.dot.expected", new Object[0]));
                    }
                } else if (this.parseNewExpression() && this.getTokenType() == CfscriptTokenTypes.POINT) {
                    this.advance();
                }
            }
            if (!start && this.getTokenType() == CfscriptTokenTypes.POINT) {
                this.advance();
            }
            start = false;
            if (!this.parseID(ifSharpsInIDs)) break;
            isReference = true;
            referenceExpression.done((IElementType)CfmlElementTypes.REFERENCE_EXPRESSION);
            do {
                if (this.getTokenType() == CfscriptTokenTypes.L_BRACKET) {
                    isReference = false;
                    referenceExpression = referenceExpression.precede();
                    this.parseArgumentsList();
                    referenceExpression.done((IElementType)CfmlElementTypes.FUNCTION_CALL_EXPRESSION);
                }
                arrayAccessNumber = 0;
                while (this.getTokenType() == CfscriptTokenTypes.L_SQUAREBRACKET) {
                    isReference = true;
                    referenceExpression = referenceExpression.precede();
                    this.parseArrayAccess();
                    referenceExpression.done((IElementType)CfmlElementTypes.NONE);
                    ++arrayAccessNumber;
                }
            } while (arrayAccessNumber == 1 && this.getTokenType() == CfscriptTokenTypes.L_BRACKET);
            referenceExpression = referenceExpression.precede();
        }
        referenceExpression.drop();
        return isReference;
    }

    private boolean parseLValue() {
        if (this.getTokenType() == CfmlTokenTypes.DOUBLE_QUOTE || this.getTokenType() == CfmlTokenTypes.SINGLE_QUOTE) {
            boolean isReference;
            this.advance();
            PsiBuilder.Marker lValueMarker = this.myBuilder.mark();
            boolean bl = isReference = this.parseReference(true) || this.parseStringReference(true);
            if (!isReference) {
                lValueMarker.error(CfmlBundle.message("cfml.parsing.l.value.expected", new Object[0]));
            } else {
                lValueMarker.drop();
            }
            if (this.getTokenType() == CfscriptTokenTypes.OPENSHARP) {
                this.parseSharpExpr();
            }
            if (this.getTokenType() != CfmlTokenTypes.DOUBLE_QUOTE_CLOSER && this.getTokenType() != CfmlTokenTypes.SINGLE_QUOTE_CLOSER) {
                this.myBuilder.error(CfmlBundle.message("cfml.parsing.quote.expected", new Object[0]));
            } else {
                this.advance();
            }
            return true;
        }
        boolean result = this.parseReference(false);
        if (CfscriptTokenTypes.POSTFIX_OPERATIONS.contains(this.getTokenType())) {
            this.advance();
            return false;
        }
        return result;
    }

    public boolean parseStringReference(boolean isLValueInQuotes) {
        boolean isReference = false;
        if (isLValueInQuotes) {
            PsiBuilder.Marker stringReferenceExpression = this.myBuilder.mark();
            this.advance();
            stringReferenceExpression.drop();
            isReference = true;
        }
        return isReference;
    }

    private boolean parseArgumentsList() {
        if (this.getTokenType() == CfscriptTokenTypes.L_BRACKET) {
            PsiBuilder.Marker argumentList = this.myBuilder.mark();
            this.advance();
            if (this.getTokenType() != CfscriptTokenTypes.R_BRACKET) {
                boolean first = true;
                while (first || this.getTokenType() == CfscriptTokenTypes.COMMA) {
                    if (!first) {
                        this.advance();
                    }
                    first = false;
                    PsiBuilder.Marker markArgumentName = this.myBuilder.mark();
                    if (this.getTokenType() == CfscriptTokenTypes.IDENTIFIER) {
                        this.advance();
                        if (this.getTokenType() == CfmlTokenTypes.ASSIGN) {
                            PsiBuilder.Marker assignment = markArgumentName.precede();
                            markArgumentName.done((IElementType)CfmlElementTypes.ARGUMENT_NAME);
                            this.advance();
                            this.parseExpression();
                            assignment.done((IElementType)CfmlElementTypes.ASSIGNMENT);
                            continue;
                        }
                        if (this.getTokenType() == CfscriptTokenTypes.COMMA || this.getTokenType() == CfscriptTokenTypes.R_BRACKET) {
                            markArgumentName.done((IElementType)CfmlElementTypes.ARGUMENT_NAME);
                            continue;
                        }
                    } else if (this.parseRValue()) {
                        markArgumentName.drop();
                        continue;
                    }
                    markArgumentName.rollbackTo();
                    this.parseExpression();
                }
            }
            if (this.getTokenType() != CfscriptTokenTypes.R_BRACKET) {
                argumentList.done((IElementType)CfmlElementTypes.SCRIPT_EXPRESSION);
                this.myBuilder.error(CfmlBundle.message("cfml.parsing.close.bracket.expected", new Object[0]));
                return true;
            }
            this.advance();
            argumentList.done((IElementType)CfmlElementTypes.ARGUMENT_LIST);
            return true;
        }
        return false;
    }

    private void parseAssignsList() {
        while (true) {
            this.parseAssignmentExpression(true);
            if (this.getTokenType() != CfscriptTokenTypes.COMMA) break;
            this.advance();
        }
    }

    public boolean parseNewExpression() {
        if (this.getTokenType() != CfscriptTokenTypes.IDENTIFIER) {
            return false;
        }
        if (!"new".equalsIgnoreCase(this.getTokenText())) {
            return false;
        }
        PsiBuilder.Marker newExpression = this.mark();
        this.advance();
        PsiBuilder.Marker constructorCall = this.mark();
        if (this.getTokenType() == CfmlTokenTypes.DOUBLE_QUOTE) {
            this.parseString();
        } else if (this.getTokenType() == CfscriptTokenTypes.IDENTIFIER) {
            this.parseComponentReference();
        } else {
            this.myBuilder.error(CfmlBundle.message("cfml.parsing.identifier.expected", new Object[0]));
        }
        this.parseArgumentsList();
        constructorCall.done(CfmlElementTypes.COMPONENT_CONSTRUCTOR_CALL);
        newExpression.done((IElementType)CfmlElementTypes.NEW_EXPRESSION);
        return true;
    }

    public boolean parseStructureDefinition() {
        PsiBuilder.Marker structDefMarker = this.mark();
        IElementType tokenType = this.getTokenType();
        if (tokenType == CfscriptTokenTypes.L_CURLYBRACKET) {
            this.advance();
            if (this.getTokenType() != CfscriptTokenTypes.R_CURLYBRACKET) {
                this.parseAssignsList();
            }
        } else {
            structDefMarker.drop();
            return false;
        }
        if (this.getTokenType() != CfscriptTokenTypes.R_CURLYBRACKET) {
            structDefMarker.done((IElementType)CfmlElementTypes.SCRIPT_EXPRESSION);
            this.myBuilder.error(CfmlBundle.message("cfml.parsing.close.bracket.expected", new Object[0]));
            return true;
        }
        this.advance();
        structDefMarker.drop();
        return true;
    }

    public boolean parseArrayDefinition() {
        IElementType tokenType = this.getTokenType();
        if (tokenType != CfscriptTokenTypes.L_SQUAREBRACKET) {
            return false;
        }
        PsiBuilder.Marker arrayDefMarker = this.mark();
        this.getTokenType();
        this.advance();
        if (this.getTokenType() != CfscriptTokenTypes.R_SQUAREBRACKET) {
            this.parseRValuesList();
        }
        if (this.getTokenType() != CfscriptTokenTypes.R_SQUAREBRACKET) {
            arrayDefMarker.done((IElementType)CfmlElementTypes.SCRIPT_EXPRESSION);
            this.myBuilder.error(CfmlBundle.message("cfml.parsing.square.bracket.expected", new Object[0]));
            return true;
        }
        this.advance();
        arrayDefMarker.drop();
        return true;
    }

    public void parseString() {
        IElementType tokenType = this.getTokenType();
        assert (tokenType == CfmlTokenTypes.SINGLE_QUOTE || tokenType == CfmlTokenTypes.DOUBLE_QUOTE);
        PsiBuilder.Marker stringLiteral = this.myBuilder.mark();
        this.advance();
        if (this.getTokenType() != CfmlTokenTypes.SINGLE_QUOTE_CLOSER && this.getTokenType() != CfmlTokenTypes.DOUBLE_QUOTE_CLOSER && !this.myBuilder.eof()) {
            this.parseStringText();
        }
        if (this.getTokenType() != CfmlTokenTypes.SINGLE_QUOTE_CLOSER && this.getTokenType() != CfmlTokenTypes.DOUBLE_QUOTE_CLOSER) {
            this.myBuilder.error(CfmlBundle.message("cfml.parsing.quote.expected", new Object[0]));
            stringLiteral.done((IElementType)CfmlElementTypes.STRING_LITERAL);
            return;
        }
        this.advance();
        stringLiteral.done((IElementType)CfmlElementTypes.STRING_LITERAL);
    }

    private void parseOperand() {
        IElementType tokenType = this.getTokenType();
        if (tokenType == CfscriptTokenTypes.L_BRACKET) {
            this.advance();
            this.parseExpression();
            if (this.getTokenType() != CfscriptTokenTypes.R_BRACKET) {
                this.myBuilder.error(CfmlBundle.message("cfml.parsing.close.bracket.expected", new Object[0]));
                return;
            }
            this.advance();
        }
        if (!this.parseArrayDefinition() && !this.parseStructureDefinition()) {
            if (tokenType == CfmlTokenTypes.SINGLE_QUOTE || tokenType == CfmlTokenTypes.DOUBLE_QUOTE) {
                this.parseString();
            } else if (tokenType == CfscriptTokenTypes.INTEGER) {
                PsiBuilder.Marker integerLiteral = this.myBuilder.mark();
                this.advance();
                integerLiteral.done((IElementType)CfmlElementTypes.INTEGER_LITERAL);
            } else if (tokenType == CfscriptTokenTypes.BOOLEAN) {
                PsiBuilder.Marker integerLiteral = this.myBuilder.mark();
                this.advance();
                integerLiteral.done((IElementType)CfmlElementTypes.BOOLEAN_LITERAL);
            } else if (tokenType == CfscriptTokenTypes.DOUBLE) {
                PsiBuilder.Marker integerLiteral = this.myBuilder.mark();
                this.advance();
                integerLiteral.done((IElementType)CfmlElementTypes.DOUBLE_LITERAL);
            } else if (tokenType == CfscriptTokenTypes.OPENSHARP) {
                this.parseSharpExpr();
            } else if (CfscriptTokenTypes.PREFIX_OPERATIONS.contains(tokenType)) {
                this.advance();
                this.parseOperand();
            } else if (tokenType == CfscriptTokenTypes.BAD_CHARACTER) {
                PsiBuilder.Marker badCharMark = this.myBuilder.mark();
                while (this.getTokenType() == CfscriptTokenTypes.BAD_CHARACTER) {
                    this.advance();
                }
                badCharMark.error(CfmlBundle.message("cfml.parsing.unexpected.token", new Object[0]));
            } else {
                this.parseReference(false);
                if (CfscriptTokenTypes.POSTFIX_OPERATIONS.contains(this.getTokenType())) {
                    this.advance();
                }
            }
        }
    }

    private void parseSharpExpr() {
        if (this.getTokenType() != CfscriptTokenTypes.OPENSHARP) {
            this.myBuilder.error(CfmlBundle.message("cfml.parsing.sharp.expected", new Object[0]));
            return;
        }
        this.advance();
        this.parseExpression();
        if (this.getTokenType() != CfscriptTokenTypes.CLOSESHARP) {
            this.myBuilder.error(CfmlBundle.message("cfml.parsing.sharp.expected", new Object[0]));
        } else {
            this.advance();
        }
    }

    private void parseStringText() {
        IElementType tokenType = this.getTokenType();
        if (tokenType != CfmlTokenTypes.STRING_TEXT && tokenType != CfscriptTokenTypes.OPENSHARP || tokenType == CfmlTokenTypes.DOUBLE_QUOTE_CLOSER || tokenType == CfmlTokenTypes.SINGLE_QUOTE_CLOSER) {
            return;
        }
        if (tokenType == CfmlTokenTypes.STRING_TEXT) {
            this.advance();
        } else {
            this.parseSharpExpr();
        }
        this.parseStringText();
    }

    private void parseRValuesList() {
        if (!this.parseStructureDefinition() && !this.parseArrayDefinition()) {
            this.parseExpression();
        }
        if (this.getTokenType() == CfscriptTokenTypes.COMMA) {
            this.advance();
            this.parseRValuesList();
        }
    }

    @Nullable
    private String getTokenText() {
        return this.myBuilder.getTokenText();
    }

    @Nullable
    private IElementType getTokenType() {
        return this.myBuilder.getTokenType();
    }

    private void advance() {
        this.myBuilder.advanceLexer();
    }

    private PsiBuilder.Marker mark() {
        return this.myBuilder.mark();
    }
}

