/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.j2meplugin.compiler.ant;

import com.intellij.compiler.ant.BuildProperties;
import com.intellij.compiler.ant.CompositeGenerator;
import com.intellij.compiler.ant.GenerationOptions;
import com.intellij.compiler.ant.GenerationUtils;
import com.intellij.compiler.ant.Generator;
import com.intellij.compiler.ant.ModuleChunk;
import com.intellij.compiler.ant.taskdefs.AntCall;
import com.intellij.compiler.ant.taskdefs.Delete;
import com.intellij.compiler.ant.taskdefs.Mkdir;
import com.intellij.compiler.ant.taskdefs.Property;
import com.intellij.compiler.ant.taskdefs.Target;
import com.intellij.j2meplugin.J2MEBundle;
import com.intellij.j2meplugin.compiler.MobileMakeUtil;
import com.intellij.j2meplugin.compiler.ant.J2MEBuildProperties;
import com.intellij.j2meplugin.module.J2MEModuleType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import java.io.File;
import java.util.HashSet;

public class CompositeJ2METarget
extends CompositeGenerator {
    public CompositeJ2METarget(ModuleChunk chunk, GenerationOptions genOptions) {
        File moduleBaseDir = chunk.getBaseDir();
        Module module = chunk.getModules()[0];
        String moduleName = module.getName();
        Target buildTarget = new Target(J2MEBuildProperties.getMobileBuildTargetName(moduleName), CompositeJ2METarget.getDepends(module), J2MEBundle.message("ant.suite.description", chunk.getName()), null);
        File jarDir = new File(moduleBaseDir.getParentFile(), "temp");
        String tempDir = GenerationUtils.toRelativePath((String)jarDir.getPath(), (ModuleChunk)chunk, (GenerationOptions)genOptions);
        String tempDirProperty = BuildProperties.getTempDirForModuleProperty((String)moduleName);
        buildTarget.add((Generator)new Property(tempDirProperty, tempDir));
        buildTarget.add((Generator)new Mkdir(BuildProperties.propertyRef((String)tempDirProperty)));
        AntCall preverifyCall = new AntCall(J2MEBuildProperties.getPreverifyTargetName(moduleName));
        buildTarget.add((Generator)preverifyCall);
        AntCall jarCall = new AntCall(J2MEBuildProperties.getJarBuildTargetName(moduleName));
        buildTarget.add((Generator)jarCall);
        buildTarget.add((Generator)new Delete(BuildProperties.propertyRef((String)tempDirProperty)));
        this.add((Generator)buildTarget);
    }

    private static String getDepends(Module module) {
        HashSet modules = new HashSet();
        MobileMakeUtil.getDependencies(module, modules);
        String depends = BuildProperties.getCompileTargetName((String)module.getName());
        for (Module dependentModule : modules) {
            String name = dependentModule.getName();
            if (ModuleType.get((Module)dependentModule) == J2MEModuleType.getInstance()) {
                depends = depends + ", " + J2MEBuildProperties.getMobileBuildTargetName(name);
                continue;
            }
            depends = depends + ", " + BuildProperties.getCompileTargetName((String)name);
        }
        return depends;
    }
}

