/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.jboss.server;

import com.intellij.javaee.ExternalResourceConfigurable;
import com.intellij.javaee.ExternalResourceListener;
import com.intellij.javaee.ExternalResourceManagerEx;
import com.intellij.javaee.NameLocationPair;
import com.intellij.javaee.oss.jboss.server.JBossIntegration;
import com.intellij.javaee.oss.jboss.version.JBossVersionHandler;
import com.intellij.javaee.oss.server.JavaeePersistentData;
import com.intellij.javaee.oss.server.JavaeePersistentDataEditor;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.hash.LinkedHashMap;
import com.intellij.xml.index.XsdNamespaceBuilder;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;

public class JBossPersistentDataEditor
extends JavaeePersistentDataEditor<JavaeePersistentData> {
    @NonNls
    private static final String JBOSS_SCHEMA_PREFIX = "urn:jboss:";
    private JButton myRegisterSchemasButton;
    private JPanel myMainPanel;
    private final Map<String, String> myUnregisteredUrl2Path;

    public JBossPersistentDataEditor() {
        super(JBossIntegration.getInstance());
        this.$$$setupUI$$$();
        this.getCustomPanelPlaceHolder().add(this.myMainPanel);
        this.myUnregisteredUrl2Path = new LinkedHashMap();
        this.myRegisterSchemasButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JBossPersistentDataEditor.this.registerSchemas();
            }
        });
        ExternalResourceManagerEx.getInstanceEx().addExternalResourceListener(new ExternalResourceListener(){

            public void externalResourceChanged() {
                JBossPersistentDataEditor.this.onResourcesChanged();
            }
        });
    }

    protected void onHomeChanged() {
        this.reset(this.isValidHomeSelected() ? JBossIntegration.getVersionHandler(this.getHome()) : null);
    }

    private void onResourcesChanged() {
        for (String resourceUrl : JBossPersistentDataEditor.getResourcesUrls()) {
            if (!this.myUnregisteredUrl2Path.containsKey(resourceUrl)) continue;
            this.myUnregisteredUrl2Path.remove(resourceUrl);
        }
        this.myRegisterSchemasButton.setEnabled(!this.myUnregisteredUrl2Path.isEmpty());
    }

    private void registerSchemas() {
        ArrayList<NameLocationPair> newResources = new ArrayList<NameLocationPair>();
        for (Map.Entry<String, String> url2path : this.myUnregisteredUrl2Path.entrySet()) {
            newResources.add(new NameLocationPair(url2path.getKey(), url2path.getValue(), true));
        }
        ExternalResourceConfigurable component = new ExternalResourceConfigurable(null, newResources);
        ShowSettingsUtil.getInstance().editConfigurable((Component)this.getMainPanel(), (Configurable)component);
    }

    public JPanel getMainPanel() {
        return this.myMainPanel;
    }

    private static List<String> getResourcesUrls() {
        return Arrays.asList(ExternalResourceManagerEx.getInstanceEx().getResourceUrls(null, true));
    }

    public void reset(JBossVersionHandler versionHandler) {
        this.myUnregisteredUrl2Path.clear();
        this.myRegisterSchemasButton.setEnabled(false);
        if (versionHandler == null) {
            return;
        }
        List<File> schemaFiles = versionHandler.getSchemas();
        if (schemaFiles == null) {
            return;
        }
        HashSet<String> registeredUrls = new HashSet<String>(JBossPersistentDataEditor.getResourcesUrls());
        for (File file : schemaFiles) {
            String namespace;
            try {
                namespace = XsdNamespaceBuilder.computeNamespace((InputStream)new FileInputStream(file));
            }
            catch (FileNotFoundException e) {
                continue;
            }
            if (namespace == null || !namespace.startsWith(JBOSS_SCHEMA_PREFIX) || registeredUrls.contains(namespace)) continue;
            this.myUnregisteredUrl2Path.put(namespace, file.getAbsolutePath());
        }
        if (!this.myUnregisteredUrl2Path.isEmpty()) {
            this.myRegisterSchemasButton.setEnabled(true);
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myRegisterSchemasButton = jButton = new JButton();
        jButton.setText("Register schemas...");
        jPanel.add((Component)jButton, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(0, 0, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

