/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.android.builder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.android.AndroidJpsUtil;
import org.jetbrains.jps.android.builder.AndroidBuildTargetType;
import org.jetbrains.jps.android.model.JpsAndroidModuleExtension;
import org.jetbrains.jps.builders.BuildRootDescriptor;
import org.jetbrains.jps.builders.BuildRootIndex;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.BuildTargetRegistry;
import org.jetbrains.jps.builders.BuildTargetType;
import org.jetbrains.jps.builders.TargetOutputIndex;
import org.jetbrains.jps.builders.java.JavaModuleBuildTargetType;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.indices.IgnoredFileIndex;
import org.jetbrains.jps.indices.ModuleExcludeIndex;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.module.JpsModule;

public abstract class AndroidBuildTarget
extends BuildTarget<BuildRootDescriptor> {
    private final AndroidBuildTargetType myTargetType;
    protected final JpsModule myModule;

    public AndroidBuildTarget(@NotNull AndroidBuildTargetType targetType, @NotNull JpsModule module) {
        if (targetType == null) {
            AndroidBuildTarget.$$$reportNull$$$0(0);
        }
        if (module == null) {
            AndroidBuildTarget.$$$reportNull$$$0(1);
        }
        super((BuildTargetType)targetType);
        this.myTargetType = targetType;
        this.myModule = module;
    }

    @NotNull
    public JpsModule getModule() {
        JpsModule jpsModule = this.myModule;
        if (jpsModule == null) {
            AndroidBuildTarget.$$$reportNull$$$0(2);
        }
        return jpsModule;
    }

    public String getId() {
        return this.myModule.getName();
    }

    @NotNull
    public final List<BuildRootDescriptor> computeRootDescriptors(JpsModel model, ModuleExcludeIndex index, IgnoredFileIndex ignoredFileIndex, BuildDataPaths dataPaths) {
        JpsAndroidModuleExtension extension = AndroidJpsUtil.getExtension(this.myModule);
        assert (extension != null);
        if (extension.isGradleProject()) {
            List<BuildRootDescriptor> list = Collections.emptyList();
            if (list == null) {
                AndroidBuildTarget.$$$reportNull$$$0(3);
            }
            return list;
        }
        List<BuildRootDescriptor> list = this.doComputeRootDescriptors(model, index, ignoredFileIndex, dataPaths);
        if (list == null) {
            AndroidBuildTarget.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    protected abstract List<BuildRootDescriptor> doComputeRootDescriptors(JpsModel var1, ModuleExcludeIndex var2, IgnoredFileIndex var3, BuildDataPaths var4);

    public Collection<BuildTarget<?>> computeDependencies(BuildTargetRegistry registry, TargetOutputIndex outputIndex) {
        ArrayList result = new ArrayList(3);
        this.fillDependencies(result);
        result.add((BuildTarget<?>)new ModuleBuildTarget(this.myModule, JavaModuleBuildTargetType.PRODUCTION));
        JpsAndroidModuleExtension extension = AndroidJpsUtil.getExtension(this.myModule);
        if (extension != null && extension.isPackTestCode()) {
            result.add((BuildTarget<?>)new ModuleBuildTarget(this.myModule, JavaModuleBuildTargetType.TEST));
        }
        return result;
    }

    protected void fillDependencies(List<BuildTarget<?>> result) {
    }

    @NotNull
    public String getPresentableName() {
        String string = "Android " + this.myTargetType.getPresentableName();
        if (string == null) {
            AndroidBuildTarget.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Nullable
    public BuildRootDescriptor findRootDescriptor(String rootId, BuildRootIndex rootIndex) {
        for (BuildRootDescriptor descriptor : rootIndex.getTargetRoots((BuildTarget)this, null)) {
            if (!descriptor.getRootId().equals(rootId)) continue;
            return descriptor;
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof AndroidBuildTarget)) {
            return false;
        }
        AndroidBuildTarget target = (AndroidBuildTarget)((Object)o);
        return this.getTargetType() == target.getTargetType() && this.getId().equals(target.getId());
    }

    public int hashCode() {
        return 31 * this.getId().hashCode() + this.getTargetType().hashCode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/android/builder/AndroidBuildTarget";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/android/builder/AndroidBuildTarget";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getModule";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "computeRootDescriptors";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

