/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archetype.common;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.maven.archetype.common.ArchetypeRegistryManager;
import org.apache.maven.archetype.common.Constants;
import org.apache.maven.archetype.registry.ArchetypeRegistry;
import org.apache.maven.archetype.registry.io.xpp3.ArchetypeRegistryXpp3Reader;
import org.apache.maven.archetype.registry.io.xpp3.ArchetypeRegistryXpp3Writer;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class DefaultArchetypeRegistryManager
extends AbstractLogEnabled
implements ArchetypeRegistryManager {
    private ArtifactRepositoryFactory artifactRepositoryFactory;
    private ArtifactRepositoryLayout defaultArtifactRepositoryLayout;

    public List getFilteredExtensions(String archetypeFilteredExtentions, File archetypeRegistryFile) throws IOException {
        ArrayList<String> filteredExtensions = new ArrayList<String>();
        if (StringUtils.isNotEmpty((String)archetypeFilteredExtentions)) {
            filteredExtensions.addAll(Arrays.asList(StringUtils.split((String)archetypeFilteredExtentions, (String)",")));
        }
        try {
            ArchetypeRegistry registry = this.readArchetypeRegistry(archetypeRegistryFile);
            filteredExtensions.addAll(registry.getFilteredExtensions());
        }
        catch (IOException e) {
            this.getLogger().warn("Can not read ~/m2/archetype.xml");
        }
        catch (XmlPullParserException e) {
            this.getLogger().warn("Can not read ~/m2/archetype.xml");
        }
        if (filteredExtensions.isEmpty()) {
            filteredExtensions.addAll(Constants.DEFAULT_FILTERED_EXTENSIONS);
        }
        return filteredExtensions;
    }

    public List getLanguages(String archetypeLanguages, File archetypeRegistryFile) throws IOException {
        ArrayList<String> languages = new ArrayList<String>();
        if (StringUtils.isNotEmpty((String)archetypeLanguages)) {
            languages.addAll(Arrays.asList(StringUtils.split((String)archetypeLanguages, (String)",")));
        }
        try {
            ArchetypeRegistry registry = this.readArchetypeRegistry(archetypeRegistryFile);
            languages.addAll(registry.getLanguages());
        }
        catch (IOException e) {
            this.getLogger().warn("Can not read ~/m2/archetype.xml");
        }
        catch (XmlPullParserException e) {
            this.getLogger().warn("Can not read ~/m2/archetype.xml");
        }
        if (languages.isEmpty()) {
            languages.addAll(Constants.DEFAULT_LANGUAGES);
        }
        return languages;
    }

    public ArchetypeRegistry readArchetypeRegistry(File archetypeRegistryFile) throws IOException, XmlPullParserException {
        if (!archetypeRegistryFile.exists()) {
            return this.getDefaultArchetypeRegistry();
        }
        return this.readArchetypeRegistry(new FileReader(archetypeRegistryFile));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArchetypeRegistry readArchetypeRegistry(Reader reader) throws IOException, XmlPullParserException {
        ArchetypeRegistryXpp3Reader xpp3Reader = new ArchetypeRegistryXpp3Reader();
        try {
            ArchetypeRegistry archetypeRegistry = xpp3Reader.read(reader);
            return archetypeRegistry;
        }
        finally {
            IOUtil.close((Reader)reader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeArchetypeRegistry(File archetypeRegistryFile, ArchetypeRegistry archetypeRegistry) throws IOException {
        ArchetypeRegistryXpp3Writer writer = new ArchetypeRegistryXpp3Writer();
        FileWriter fileWriter = new FileWriter(archetypeRegistryFile);
        try {
            writer.write(fileWriter, archetypeRegistry);
        }
        finally {
            IOUtil.close((Writer)fileWriter);
        }
    }

    public ArtifactRepository createRepository(String url, String repositoryId) {
        String updatePolicyFlag = "always";
        String checksumPolicyFlag = "warn";
        ArtifactRepositoryPolicy snapshotsPolicy = new ArtifactRepositoryPolicy(true, updatePolicyFlag, checksumPolicyFlag);
        ArtifactRepositoryPolicy releasesPolicy = new ArtifactRepositoryPolicy(true, updatePolicyFlag, checksumPolicyFlag);
        return this.artifactRepositoryFactory.createArtifactRepository(repositoryId, url, this.defaultArtifactRepositoryLayout, snapshotsPolicy, releasesPolicy);
    }

    public ArchetypeRegistry getDefaultArchetypeRegistry() {
        ArchetypeRegistry registry = new ArchetypeRegistry();
        registry.getLanguages().addAll(Constants.DEFAULT_LANGUAGES);
        registry.getFilteredExtensions().addAll(Constants.DEFAULT_FILTERED_EXTENSIONS);
        return registry;
    }
}

