/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.android;

import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.resources.ResourceResolver;
import com.android.resources.ResourceType;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.res.AppResourceRepository;
import com.android.tools.idea.res.ResourceHelper;
import com.android.tools.idea.ui.resourcechooser.ColorPicker;
import com.android.utils.XmlUtils;
import com.google.common.base.Charsets;
import com.google.common.io.Files;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ui.ColorIcon;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.nio.charset.Charset;
import javax.swing.Icon;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ResourceReferenceAnnotatorUtil {
    public static final int ICON_SIZE = 8;

    @Nullable
    public static File pickBitmapFromXml(@NotNull File file, @NotNull ResourceResolver resourceResolver, @NotNull Project project) {
        block11: {
            try {
                String src;
                ResourceValue value;
                String xml = Files.toString((File)file, (Charset)Charsets.UTF_8);
                Document document = XmlUtils.parseDocumentSilently((String)xml, (boolean)true);
                if (document == null || document.getDocumentElement() == null) break block11;
                Element root = document.getDocumentElement();
                String tag = root.getTagName();
                Element target = null;
                String attribute = null;
                if ("vector".equals(tag)) {
                    return file;
                }
                if ("bitmap".equals(tag) || "nine-patch".equals(tag)) {
                    target = root;
                    attribute = "src";
                } else if ("selector".equals(tag) || "level-list".equals(tag) || "layer-list".equals(tag) || "transition".equals(tag)) {
                    NodeList children = root.getChildNodes();
                    for (int i = children.getLength() - 1; i >= 0; --i) {
                        Node item = children.item(i);
                        if (item.getNodeType() != 1 || !"item".equals(item.getNodeName()) || !(target = (Element)item).hasAttributeNS("http://schemas.android.com/apk/res/android", "drawable")) continue;
                        attribute = "drawable";
                        break;
                    }
                } else if ("clip".equals(tag) || "inset".equals(tag) || "scale".equals(tag)) {
                    target = root;
                    attribute = "drawable";
                } else {
                    return null;
                }
                if (attribute != null && target.hasAttributeNS("http://schemas.android.com/apk/res/android", attribute) && (value = resourceResolver.findResValue(src = target.getAttributeNS("http://schemas.android.com/apk/res/android", attribute), false)) != null) {
                    return ResourceHelper.resolveDrawable((RenderResources)resourceResolver, (ResourceValue)value, (Project)project);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    public static ResourceValue findResourceValue(ResourceType type, String name, boolean isFramework, Module module, Configuration configuration) {
        if (isFramework) {
            ResourceRepository frameworkResources = configuration.getFrameworkResources();
            if (frameworkResources == null) {
                return null;
            }
            if (!frameworkResources.hasResourceItem(type, name)) {
                return null;
            }
            ResourceItem item = frameworkResources.getResourceItem(type, name);
            return item.getResourceValue(type, configuration.getFullConfig(), false);
        }
        AppResourceRepository appResources = AppResourceRepository.getOrCreateInstance((Module)module);
        if (appResources == null) {
            return null;
        }
        if (!appResources.hasResourceItem(type, name)) {
            return null;
        }
        return appResources.getConfiguredValue(type, name, configuration.getFullConfig());
    }

    @Nullable
    public static Configuration pickConfiguration(AndroidFacet facet, Module module, PsiFile file) {
        VirtualFile layout;
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        VirtualFile parent2 = virtualFile.getParent();
        if (parent2 == null) {
            return null;
        }
        String parentName = parent2.getName();
        if (!parentName.startsWith("layout")) {
            layout = ResourceHelper.pickAnyLayoutFile((Module)module, (AndroidFacet)facet);
            if (layout == null) {
                return null;
            }
        } else {
            layout = virtualFile;
        }
        return ConfigurationManager.getOrCreateInstance((Module)module).getConfiguration(layout);
    }

    public static class ColorRenderer
    extends GutterIconRenderer {
        private final PsiElement myElement;
        private final Color myColor;

        ColorRenderer(@NotNull PsiElement element, @Nullable Color color) {
            this.myElement = element;
            this.myColor = color;
        }

        @NotNull
        public Icon getIcon() {
            Color color = this.getCurrentColor();
            return JBUI.scale((JBUI.JBIcon)(color == null ? EmptyIcon.create((int)8) : new ColorIcon(8, color)));
        }

        @Nullable
        private Color getCurrentColor() {
            if (this.myColor != null) {
                return this.myColor;
            }
            if (this.myElement instanceof XmlTag) {
                return ResourceHelper.parseColor((String)((XmlTag)this.myElement).getValue().getText());
            }
            if (this.myElement instanceof XmlAttributeValue) {
                return ResourceHelper.parseColor((String)((XmlAttributeValue)this.myElement).getValue());
            }
            return null;
        }

        public AnAction getClickAction() {
            if (this.myColor != null) {
                return null;
            }
            return new AnAction(){

                public void actionPerformed(AnActionEvent e) {
                    Color color;
                    Editor editor = (Editor)CommonDataKeys.EDITOR.getData(e.getDataContext());
                    if (editor != null && (color = ColorPicker.showDialog((Component)editor.getComponent(), (String)"Choose Color", (Color)this.getCurrentColor(), (boolean)true, null, (boolean)false)) != null) {
                        ApplicationManager.getApplication().runWriteAction(new Runnable(){

                            @Override
                            public void run() {
                                XmlAttribute attribute;
                                if (myElement instanceof XmlTag) {
                                    ((XmlTag)myElement).getValue().setText(ResourceHelper.colorToString((Color)color));
                                } else if (myElement instanceof XmlAttributeValue && (attribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)myElement, XmlAttribute.class)) != null) {
                                    attribute.setValue(ResourceHelper.colorToString((Color)color));
                                }
                            }
                        });
                    }
                }
            };
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            ColorRenderer that = (ColorRenderer)((Object)o);
            if (this.myColor != null ? !this.myColor.equals(that.myColor) : that.myColor != null) {
                return false;
            }
            return this.myElement.equals(that.myElement);
        }

        public int hashCode() {
            int result = this.myElement.hashCode();
            result = 31 * result + (this.myColor != null ? this.myColor.hashCode() : 0);
            return result;
        }
    }
}

