/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.flex;

import com.intellij.javascript.flex.refactoring.RenameMoveUtils;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.findUsages.JSSuperMethodUtil;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.SearchScope;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlexRenameHandler
extends RenamePsiElementProcessor {
    public boolean canProcessElement(@NotNull PsiElement element) {
        if (element == null) {
            FlexRenameHandler.$$$reportNull$$$0(0);
        }
        return (element instanceof JSFunction || element instanceof JSFile) && DialectDetector.isActionScript((PsiElement)element.getContainingFile());
    }

    public void renameElement(@NotNull PsiElement element, @NotNull String newName, @NotNull UsageInfo[] usages, @Nullable RefactoringElementListener listener) throws IncorrectOperationException {
        PsiFile file;
        if (element == null) {
            FlexRenameHandler.$$$reportNull$$$0(1);
        }
        if (newName == null) {
            FlexRenameHandler.$$$reportNull$$$0(2);
        }
        if (usages == null) {
            FlexRenameHandler.$$$reportNull$$$0(3);
        }
        super.renameElement(element, newName, usages, listener);
        if (element instanceof JSFile && (file = element.getManager().findFile(element.getContainingFile().getVirtualFile())) instanceof JSFile) {
            RenameMoveUtils.updateFileWithChangedName((JSFile)file);
        }
    }

    public PsiElement substituteElementToRename(@NotNull PsiElement element, Editor editor) {
        if (element == null) {
            FlexRenameHandler.$$$reportNull$$$0(4);
        }
        if (element instanceof JSFunction) {
            return JSSuperMethodUtil.checkSuperMethod((JSFunction)((JSFunction)element), (String)RefactoringBundle.message((String)"rename.title"), (String)RefactoringBundle.message((String)"to.rename"));
        }
        return super.substituteElementToRename(element, editor);
    }

    public void prepareRenaming(@NotNull PsiElement element, final @NotNull String newName, final @NotNull Map<PsiElement, String> allRenames, @NotNull SearchScope scope) {
        if (element == null) {
            FlexRenameHandler.$$$reportNull$$$0(5);
        }
        if (newName == null) {
            FlexRenameHandler.$$$reportNull$$$0(6);
        }
        if (allRenames == null) {
            FlexRenameHandler.$$$reportNull$$$0(7);
        }
        if (scope == null) {
            FlexRenameHandler.$$$reportNull$$$0(8);
        }
        if (!(element instanceof JSFunction)) {
            return;
        }
        JSInheritanceUtil.iterateMethodsDown((JSFunction)((JSFunction)element), (Processor)new Processor<JSFunction>(){

            public synchronized boolean process(JSFunction jsFunction) {
                allRenames.put(jsFunction, newName);
                return true;
            }
        }, (boolean)true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allRenames";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
        }
        objectArray2[1] = "com/intellij/javascript/flex/FlexRenameHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "canProcessElement";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "renameElement";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "substituteElementToRename";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "prepareRenaming";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

