/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.flex.css;

import com.intellij.javascript.flex.css.FlexCssElementDescriptorProvider;
import com.intellij.javascript.flex.css.FlexCssUtil;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssElementDescriptorProvider;
import com.intellij.psi.css.CssPropertyDescriptor;
import com.intellij.psi.css.impl.util.table.CssDescriptorsUtil;
import com.intellij.psi.css.reference.CssReference;
import com.intellij.psi.impl.source.resolve.reference.impl.PsiPolyVariantCachingReference;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssPropertyValueReference
extends PsiPolyVariantCachingReference
implements CssReference {
    private final PsiElement myElement;
    private final int myStart;
    private final int myEnd;

    public CssPropertyValueReference(@NotNull PsiElement element) {
        if (element == null) {
            CssPropertyValueReference.$$$reportNull$$$0(0);
        }
        this.myElement = element;
        String text = element.getText();
        if (FlexCssUtil.inQuotes(text)) {
            this.myStart = 1;
            this.myEnd = text.length() - 1;
        } else {
            this.myStart = 0;
            this.myEnd = 0;
        }
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        String string = CssBundle.message((String)"invalid.css.property.name.message", (Object[])new Object[0]);
        if (string == null) {
            CssPropertyValueReference.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    protected ResolveResult[] resolveInner(boolean incompleteCode, @NotNull PsiFile containingFile) {
        FlexCssElementDescriptorProvider provider;
        CssPropertyDescriptor descriptor;
        String value;
        if (containingFile == null) {
            CssPropertyValueReference.$$$reportNull$$$0(2);
        }
        if (FlexCssUtil.inQuotes(value = this.myElement.getText()) && (descriptor = (provider = (FlexCssElementDescriptorProvider)((Object)CssElementDescriptorProvider.EP_NAME.findExtension(FlexCssElementDescriptorProvider.class))).getPropertyDescriptor(value.substring(1, value.length() - 1), this.myElement)) != null) {
            ResolveResult[] resolveResultArray = PsiElementResolveResult.createResults((PsiElement[])descriptor.getDeclarations(this.myElement));
            if (resolveResultArray == null) {
                CssPropertyValueReference.$$$reportNull$$$0(3);
            }
            return resolveResultArray;
        }
        if (ResolveResult.EMPTY_ARRAY == null) {
            CssPropertyValueReference.$$$reportNull$$$0(4);
        }
        return ResolveResult.EMPTY_ARRAY;
    }

    @NotNull
    public PsiElement getElement() {
        PsiElement psiElement = this.myElement;
        if (psiElement == null) {
            CssPropertyValueReference.$$$reportNull$$$0(5);
        }
        return psiElement;
    }

    @NotNull
    public TextRange getRangeInElement() {
        TextRange textRange = new TextRange(this.myStart, this.myEnd);
        if (textRange == null) {
            CssPropertyValueReference.$$$reportNull$$$0(6);
        }
        return textRange;
    }

    @NotNull
    public String getCanonicalText() {
        String text = this.myElement.getText();
        if (FlexCssUtil.inQuotes(text)) {
            String string = text.substring(1, text.length() - 1);
            if (string == null) {
                CssPropertyValueReference.$$$reportNull$$$0(7);
            }
            return string;
        }
        if ("" == null) {
            CssPropertyValueReference.$$$reportNull$$$0(8);
        }
        return "";
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        if (newElementName == null) {
            CssPropertyValueReference.$$$reportNull$$$0(9);
        }
        ElementManipulator manipulator = ElementManipulators.getManipulator((PsiElement)this.myElement);
        assert (manipulator != null);
        return manipulator.handleContentChange(this.myElement, this.getRangeInElement(), newElementName);
    }

    @Nullable
    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            CssPropertyValueReference.$$$reportNull$$$0(10);
        }
        return null;
    }

    @NotNull
    public Object[] getVariants() {
        FlexCssElementDescriptorProvider flexDescriptorProvider = (FlexCssElementDescriptorProvider)((Object)CssElementDescriptorProvider.EP_NAME.findExtension(FlexCssElementDescriptorProvider.class));
        Object[] objectArray = CssDescriptorsUtil.extractDescriptorsIdsAsArray(flexDescriptorProvider.getAllPropertyDescriptors(this.myElement));
        if (objectArray == null) {
            CssPropertyValueReference.$$$reportNull$$$0(11);
        }
        return objectArray;
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        ResolveResult[] results;
        if (element == null) {
            CssPropertyValueReference.$$$reportNull$$$0(12);
        }
        for (ResolveResult result : results = this.multiResolve(false)) {
            if (!this.myElement.getManager().areElementsEquivalent(result.getElement(), element)) continue;
            return true;
        }
        return false;
    }

    public boolean isSoft() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/flex/css/CssPropertyValueReference";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/flex/css/CssPropertyValueReference";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnresolvedMessagePattern";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveInner";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInElement";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "resolveInner";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

