/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.flex.mxml;

import com.intellij.flex.model.bc.TargetPlatform;
import com.intellij.lang.javascript.flex.FlexModuleType;
import com.intellij.lang.javascript.flex.PredefinedImportSet;
import com.intellij.lang.javascript.flex.ScopedImportSet;
import com.intellij.lang.javascript.flex.projectStructure.model.FlexBuildConfiguration;
import com.intellij.lang.javascript.flex.projectStructure.model.FlexBuildConfigurationManager;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class MxmlImplicitImports {
    @NonNls
    private static final ScopedImportSet standardMxmlImports = new PredefinedImportSet(new String[]{"mx.styles.*", "mx.binding.*", "mx.core.mx_internal", "mx.core.IDeferredInstance", "mx.core.IFactory", "mx.core.IPropertyChangeNotifier", "mx.core.ClassFactory", "mx.core.DeferredInstanceFromClass", "mx.core.DeferredInstanceFromFunction"});
    @NonNls
    private static final ScopedImportSet airOnlyImplicitImports = new PredefinedImportSet(new String[]{"flash.data.*", "flash.desktop.*", "flash.filesystem.*", "flash.html.*", "flash.html.script.*"});
    @NonNls
    private static final String[] commonImplicitImports = new String[]{"flash.accessibility.*", "flash.debugger.*", "flash.display.*", "flash.errors.*", "flash.events.*", "flash.external.*", "flash.geom.*", "flash.media.*", "flash.net.*", "flash.printing.*", "flash.profiler.*", "flash.system.*", "flash.text.*", "flash.ui.*", "flash.utils.*", "flash.xml.*"};
    @NonNls
    private static final ScopedImportSet flex3ImplicitImports = new PredefinedImportSet((String[])ArrayUtil.append((Object[])commonImplicitImports, (Object)"flash.filters.*"));
    @NonNls
    private static final ScopedImportSet flex4ImplicitImports = new PredefinedImportSet(ArrayUtil.mergeArrays((String[])commonImplicitImports, (String[])new String[]{"mx.filters.*", "mx.core.IFlexModuleFactory"}));

    public static boolean resolveTypeNameUsingImplicitImports(ResolveProcessor resolveProcessor, @NotNull PsiNamedElement scope) {
        PsiElement context;
        if (scope == null) {
            MxmlImplicitImports.$$$reportNull$$$0(0);
        }
        if ((context = scope.getContext()) != null) {
            ScopedImportSet flexImplicitImports;
            XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)context, XmlTag.class, (boolean)false);
            boolean flex4ns = tag != null && ArrayUtil.contains((String)"http://ns.adobe.com/mxml/2009", (String[])tag.knownNamespaces());
            ScopedImportSet scopedImportSet = flexImplicitImports = flex4ns ? flex4ImplicitImports : flex3ImplicitImports;
            if (!flexImplicitImports.tryResolveImportedClass(scope, resolveProcessor)) {
                return false;
            }
            if (!standardMxmlImports.tryResolveImportedClass(scope, resolveProcessor)) {
                return false;
            }
            if (MxmlImplicitImports.isAirImportsNeeded((PsiElement)scope) && !airOnlyImplicitImports.tryResolveImportedClass(scope, resolveProcessor)) {
                return false;
            }
        }
        return true;
    }

    private static boolean isAirImportsNeeded(PsiElement element) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        if (module != null) {
            FlexBuildConfiguration bc = ModuleType.get((Module)module) instanceof FlexModuleType ? FlexBuildConfigurationManager.getInstance(module).getActiveConfiguration() : null;
            return bc != null && (bc.getTargetPlatform() == TargetPlatform.Desktop || bc.getTargetPlatform() == TargetPlatform.Mobile);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/javascript/flex/mxml/MxmlImplicitImports", "resolveTypeNameUsingImplicitImports"));
    }
}

