/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.flex.mxml.schema;

import com.intellij.ProjectTopics;
import com.intellij.javascript.flex.mxml.schema.CodeContext;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeContextHolder {
    private final Set<Module> myModulesWithSdkComponentsHandled = new HashSet<Module>();
    private final Map<String, Map<Module, CodeContext>> myStandardContexts = new HashMap<String, Map<Module, CodeContext>>();
    private final Map<String, Map<Module, CodeContext>> myNSToCodeContextMap = new THashMap();
    static final CodeContext EMPTY = new CodeContext(null, null);

    public CodeContextHolder(Project project) {
        project.getMessageBus().connect().subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void rootsChanged(@NotNull ModuleRootEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                CodeContextHolder codeContextHolder = CodeContextHolder.this;
                synchronized (codeContextHolder) {
                    CodeContextHolder.this.myNSToCodeContextMap.clear();
                    CodeContextHolder.this.myStandardContexts.clear();
                    CodeContextHolder.this.myModulesWithSdkComponentsHandled.clear();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/javascript/flex/mxml/schema/CodeContextHolder$1", "rootsChanged"));
            }
        });
    }

    @Nullable
    public synchronized CodeContext getCodeContext(@NotNull String namespace, @NotNull Module module) {
        Map<Module, CodeContext> map;
        if (namespace == null) {
            CodeContextHolder.$$$reportNull$$$0(0);
        }
        if (module == null) {
            CodeContextHolder.$$$reportNull$$$0(1);
        }
        if ((map = this.myNSToCodeContextMap.get(namespace)) != null) {
            return map.get(module);
        }
        return null;
    }

    public synchronized void putCodeContext(@NotNull String namespace, @NotNull Module module, @NotNull CodeContext codeContext) {
        THashMap map;
        if (namespace == null) {
            CodeContextHolder.$$$reportNull$$$0(2);
        }
        if (module == null) {
            CodeContextHolder.$$$reportNull$$$0(3);
        }
        if (codeContext == null) {
            CodeContextHolder.$$$reportNull$$$0(4);
        }
        if ((map = this.myNSToCodeContextMap.get(namespace)) == null) {
            map = new THashMap();
            this.myNSToCodeContextMap.put(namespace, (Map<Module, CodeContext>)map);
        }
        map.put(module, codeContext);
    }

    public synchronized void clearCodeContext(@NotNull String namespace, @NotNull Module module) {
        Map<Module, CodeContext> map;
        if (namespace == null) {
            CodeContextHolder.$$$reportNull$$$0(5);
        }
        if (module == null) {
            CodeContextHolder.$$$reportNull$$$0(6);
        }
        if ((map = this.myNSToCodeContextMap.get(namespace)) != null) {
            map.remove(module);
        }
    }

    public static CodeContextHolder getInstance(@NotNull Project project) {
        if (project == null) {
            CodeContextHolder.$$$reportNull$$$0(7);
        }
        return (CodeContextHolder)project.getComponent(CodeContextHolder.class);
    }

    @Nullable
    public synchronized CodeContext getStandardContext(String namespace, Module module) {
        Map<Module, CodeContext> map = this.myStandardContexts.get(namespace);
        return map == null ? null : map.get(module);
    }

    public synchronized Collection<String> getNamespaces(Module module) {
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry<String, Map<Module, CodeContext>> entry : this.myStandardContexts.entrySet()) {
            if (!entry.getValue().containsKey(module)) continue;
            result.add(entry.getKey());
        }
        for (Map.Entry<String, Map<Module, CodeContext>> entry : this.myNSToCodeContextMap.entrySet()) {
            if (!entry.getValue().containsKey(module)) continue;
            result.add(entry.getKey());
        }
        return result;
    }

    synchronized void putStandardContext(String namespace, Module module, CodeContext codeContext) {
        Map<Module, CodeContext> map = this.myStandardContexts.get(namespace);
        if (map == null) {
            map = new HashMap<Module, CodeContext>();
            this.myStandardContexts.put(namespace, map);
        }
        map.put(module, codeContext);
    }

    synchronized boolean areSdkComponentsHandledForModule(Module module) {
        return this.myModulesWithSdkComponentsHandled.contains(module);
    }

    synchronized boolean setSdkComponentsHandledForModule(Module module) {
        return this.myModulesWithSdkComponentsHandled.add(module);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codeContext";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/intellij/javascript/flex/mxml/schema/CodeContextHolder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getCodeContext";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "putCodeContext";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "clearCodeContext";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getInstance";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

