/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.flex.refactoring.extractSuper;

import com.intellij.ide.util.PlatformPackageUtil;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.ActionScriptResolveUtil;
import com.intellij.lang.javascript.refactoring.extractSuper.JSExtractSuperMode;
import com.intellij.lang.javascript.refactoring.ui.JSReferenceEditor;
import com.intellij.lang.javascript.refactoring.util.ActionScriptRefactoringUtil;
import com.intellij.lang.javascript.refactoring.util.JSMemberInfo;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.extractSuperclass.ExtractSuperBaseDialog;
import com.intellij.util.ThreeState;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FlexExtractSuperBaseDialog
extends ExtractSuperBaseDialog<JSClass, JSMemberInfo> {
    private static final String DESTINATION_PACKAGE_RECENT_KEY = "JSExtractSuperBase.RECENT_KEYS";
    private JRadioButton myExtractAndTurnRefsRB;

    public FlexExtractSuperBaseDialog(@NotNull JSClass sourceClass, @NotNull List<JSMemberInfo> members, String refactoringName) {
        if (sourceClass == null) {
            FlexExtractSuperBaseDialog.$$$reportNull$$$0(0);
        }
        if (members == null) {
            FlexExtractSuperBaseDialog.$$$reportNull$$$0(1);
        }
        super(sourceClass.getProject(), (PsiElement)sourceClass, members, refactoringName);
    }

    protected void customizeRadiobuttons(Box box, ButtonGroup buttonGroup) {
        this.myExtractAndTurnRefsRB = new JRadioButton(JSBundle.message((String)"extract.0.turn.refs", (Object[])new Object[]{StringUtil.decapitalize((String)this.getEntityName())}));
        buttonGroup.add(this.myExtractAndTurnRefsRB);
        box.add((Component)this.myExtractAndTurnRefsRB, 1);
        this.myExtractAndTurnRefsRB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                FlexExtractSuperBaseDialog.this.updateDialog();
            }
        });
    }

    protected ComponentWithBrowseButton createPackageNameField() {
        String packageName = StringUtil.getPackageName((String)((JSClass)this.mySourceClass).getQualifiedName());
        return JSReferenceEditor.forPackageName((String)packageName, (Project)this.myProject, (String)DESTINATION_PACKAGE_RECENT_KEY, (GlobalSearchScope)this.getScope(), (String)RefactoringBundle.message((String)"choose.destination.package"));
    }

    protected String getTargetPackageName() {
        return ((JSReferenceEditor)this.myPackageNameField).getText();
    }

    protected JTextField createSourceClassField() {
        JTextField result = new JTextField(((JSClass)this.mySourceClass).getQualifiedName());
        result.setEditable(false);
        return result;
    }

    @Nullable
    protected String validateName(String name) {
        if (name != null && name.isEmpty()) {
            return RefactoringBundle.message((String)"no.destination.class.specified");
        }
        if (!ActionScriptRefactoringUtil.isValidClassName((String)name, (boolean)false)) {
            return JSBundle.message((String)"0.is.not.a.legal.name", (Object[])new Object[]{name});
        }
        return null;
    }

    protected void preparePackage() throws ExtractSuperBaseDialog.OperationFailedException {
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)this.mySourceClass);
        PsiDirectory baseDir = PlatformPackageUtil.getDirectory((PsiElement)this.mySourceClass);
        this.myTargetDirectory = JSRefactoringUtil.chooseOrCreateDirectoryForClass((Project)this.myProject, (Module)module, (GlobalSearchScope)this.getScope(), (String)this.getTargetPackageName(), (String)this.getExtractedSuperName(), (PsiDirectory)baseDir, (ThreeState)ThreeState.UNSURE);
        if (this.myTargetDirectory == null) {
            throw new ExtractSuperBaseDialog.OperationFailedException("");
        }
    }

    private GlobalSearchScope getScope() {
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)this.mySourceClass);
        PsiDirectory baseDir = PlatformPackageUtil.getDirectory((PsiElement)this.mySourceClass);
        if (this.getMode() == JSExtractSuperMode.RenameImplementation) {
            return PlatformPackageUtil.adjustScope((PsiDirectory)baseDir, (GlobalSearchScope)GlobalSearchScope.moduleWithDependentsScope((Module)module), (boolean)true, (boolean)false);
        }
        return PlatformPackageUtil.adjustScope((PsiDirectory)baseDir, (GlobalSearchScope)GlobalSearchScope.moduleWithDependenciesScope((Module)module), (boolean)false, (boolean)true);
    }

    protected String getDestinationPackageRecentKey() {
        return DESTINATION_PACKAGE_RECENT_KEY;
    }

    public Collection<JSMemberInfo> getSelectedMemberInfos() {
        return Arrays.asList(JSMemberInfo.getSelected((Collection)this.myMemberInfos, (JSClass)((JSClass)this.mySourceClass), (Condition)Conditions.alwaysTrue()));
    }

    protected void executeRefactoring() {
        this.invokeRefactoring(this.createProcessor());
    }

    protected JSExtractSuperMode getMode() {
        if (this.isExtractSuperclass()) {
            return JSExtractSuperMode.ExtractSuper;
        }
        if (this.myExtractAndTurnRefsRB != null && this.myExtractAndTurnRefsRB.isSelected()) {
            return JSExtractSuperMode.ExtractSuperTurnRefs;
        }
        return JSExtractSuperMode.RenameImplementation;
    }

    protected String getDocCommentPanelName() {
        return JSBundle.message((String)"asdoc", (Object[])new Object[0]);
    }

    protected int getDocCommentPolicySetting() {
        return 1;
    }

    protected void setDocCommentPolicySetting(int policy) {
    }

    protected void updateDialog() {
        super.updateDialog();
        boolean canSetPackage = this.getMode() != JSExtractSuperMode.RenameImplementation || !ActionScriptResolveUtil.isFileLocalSymbol((PsiElement)this.mySourceClass);
        this.myPackageNameField.setEnabled(canSetPackage);
        this.myPackageNameLabel.setEnabled(canSetPackage);
        ((JSReferenceEditor)this.myPackageNameField).setScope(this.getScope());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "sourceClass";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "members";
                break;
            }
        }
        objectArray[1] = "com/intellij/javascript/flex/refactoring/extractSuper/FlexExtractSuperBaseDialog";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

