/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.flex.refactoring.extractSuper;

import com.intellij.javascript.flex.refactoring.RenameMoveUtils;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.flex.ECMAScriptImportOptimizer;
import com.intellij.lang.javascript.flex.ImportUtils;
import com.intellij.lang.javascript.flex.XmlBackedJSClassImpl;
import com.intellij.lang.javascript.presentable.JSFormatUtil;
import com.intellij.lang.javascript.presentable.JSNamedElementPresenter;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSRecursiveElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSImportStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceList;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClass;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClassFactory;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSReferenceExpressionImpl;
import com.intellij.lang.javascript.psi.resolve.ActionScriptResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.refactoring.FormatFixer;
import com.intellij.lang.javascript.refactoring.JSVisibilityUtil;
import com.intellij.lang.javascript.refactoring.extractSuper.JSConvertReferencesToSuperUtil;
import com.intellij.lang.javascript.refactoring.extractSuper.JSExtractSuperMode;
import com.intellij.lang.javascript.refactoring.memberPullUp.JSPullUpConflictsUtil;
import com.intellij.lang.javascript.refactoring.memberPullUp.JSPullUpHelper;
import com.intellij.lang.javascript.refactoring.util.JSInterfaceContainmentVerifier;
import com.intellij.lang.javascript.refactoring.util.JSMemberInfo;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringConflictsUtil;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.lang.javascript.validation.fixes.ActionScriptCreateClassOrInterfaceFix;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.ui.UsageViewDescriptorAdapter;
import com.intellij.refactoring.util.RefactoringDescriptionLocation;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.MultiMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class FlexExtractSuperProcessor
extends BaseRefactoringProcessor {
    private static final Logger LOG = Logger.getInstance((String)FlexExtractSuperProcessor.class.getName());
    private JSClass mySourceClass;
    private final JSMemberInfo[] myMembersToMove;
    private final String myTargetName;
    private final String myTargetPackage;
    private final int myDocCommentPolicy;
    private final JSExtractSuperMode myMode;
    private final boolean myClassNotInterface;
    private final PsiDirectory myTagretDirectory;
    private JSClass myTargetClass;
    private SmartPsiElementPointer<JSClass> myTargetClassPtr;
    private Collection<JSElement> myMembersAfterMove;

    public FlexExtractSuperProcessor(JSClass sourceClass, JSMemberInfo[] membersToMove, String targetName, String targetPackage, int docCommentPolicy, JSExtractSuperMode mode, boolean classNotInterface, PsiDirectory targetDirectory) {
        super(sourceClass.getProject());
        this.mySourceClass = sourceClass;
        this.myMembersToMove = membersToMove;
        this.myTargetName = targetName;
        this.myTargetPackage = targetPackage;
        this.myDocCommentPolicy = docCommentPolicy;
        this.myMode = mode;
        this.myClassNotInterface = classNotInterface;
        this.myTagretDirectory = targetDirectory;
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            FlexExtractSuperProcessor.$$$reportNull$$$0(0);
        }
        JSExtractInterfaceUsageViewDescriptor jSExtractInterfaceUsageViewDescriptor = new JSExtractInterfaceUsageViewDescriptor();
        if (jSExtractInterfaceUsageViewDescriptor == null) {
            FlexExtractSuperProcessor.$$$reportNull$$$0(1);
        }
        return jSExtractInterfaceUsageViewDescriptor;
    }

    @NotNull
    protected UsageInfo[] findUsages() {
        if (this.myMode == JSExtractSuperMode.ExtractSuper) {
            if (UsageInfo.EMPTY_ARRAY == null) {
                FlexExtractSuperProcessor.$$$reportNull$$$0(2);
            }
            return UsageInfo.EMPTY_ARRAY;
        }
        Collection<JSReferenceExpression> candidates = Collections.synchronizedCollection(new ArrayList());
        ReferencesSearch.search((PsiElement)this.mySourceClass, (SearchScope)this.mySourceClass.getUseScope()).forEach(psiReference -> {
            PsiElement element = psiReference.getElement();
            if (!(element instanceof JSReferenceExpression)) {
                return true;
            }
            if (element == this.mySourceClass.getNameIdentifier()) {
                return true;
            }
            if (element.getParent() instanceof JSImportStatement) {
                return true;
            }
            candidates.add((JSReferenceExpression)element);
            return true;
        });
        JSConvertReferencesToSuperUtil util = new JSConvertReferencesToSuperUtil(this.myMembersToMove, this.myMembersAfterMove, this.myMode, this.mySourceClass, this.myTargetClass);
        HashMap variablesResults = new HashMap();
        Collection<UsageInfo> result = Collections.synchronizedCollection(new ArrayList());
        for (JSReferenceExpression candidate : candidates) {
            if (!(util.canTurnReferenceToSuper(candidate, variablesResults) ^ this.myMode == JSExtractSuperMode.RenameImplementation)) continue;
            result.add(new UsageInfo((PsiElement)candidate));
        }
        if (this.myMode == JSExtractSuperMode.RenameImplementation) {
            JSRefactoringUtil.addConstructorUsages((JSClass)this.mySourceClass, result);
        }
        UsageInfo[] usageInfoArray = result.toArray(UsageInfo.EMPTY_ARRAY);
        if (usageInfoArray == null) {
            FlexExtractSuperProcessor.$$$reportNull$$$0(3);
        }
        return usageInfoArray;
    }

    protected void refreshElements(@NotNull PsiElement[] elements) {
        if (elements == null) {
            FlexExtractSuperProcessor.$$$reportNull$$$0(4);
        }
    }

    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        if (refUsages == null) {
            FlexExtractSuperProcessor.$$$reportNull$$$0(5);
        }
        return this.showConflicts(this.detectConflicts((UsageInfo[])refUsages.get()), (UsageInfo[])refUsages.get());
    }

    private MultiMap<PsiElement, String> detectConflicts(UsageInfo[] usageInfos) {
        if (this.myMode == JSExtractSuperMode.ExtractSuper || this.myMode == JSExtractSuperMode.ExtractSuperTurnRefs) {
            JSInterfaceContainmentVerifier v = JSInterfaceContainmentVerifier.create(Arrays.asList(this.myMembersToMove));
            return JSPullUpConflictsUtil.checkConflicts((JSMemberInfo[])this.myMembersToMove, (JSClass)this.mySourceClass, (JSClass)this.createFakeClass(), (JSInterfaceContainmentVerifier)v, (JSVisibilityUtil.Options)JSVisibilityUtil.DEFAULT_OPTIONS);
        }
        MultiMap<PsiElement, String> conflicts = new MultiMap<PsiElement, String>(){

            @NotNull
            protected Map<PsiElement, Collection<String>> createMap() {
                Map<PsiElement, Collection<String>> map = Collections.synchronizedMap(super.createMap());
                if (map == null) {
                    1.$$$reportNull$$$0(0);
                }
                return map;
            }

            @NotNull
            protected Collection<String> createCollection() {
                Collection<String> collection = Collections.synchronizedCollection(super.createCollection());
                if (collection == null) {
                    1.$$$reportNull$$$0(1);
                }
                return collection;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/javascript/flex/refactoring/extractSuper/FlexExtractSuperProcessor$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createMap";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createCollection";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
        this.checkIncomingReferencesToSubclass(usageInfos, conflicts, JSVisibilityUtil.DEFAULT_OPTIONS);
        this.checkIncomingReferencesToPushedMembers(conflicts, JSVisibilityUtil.DEFAULT_OPTIONS);
        this.checkOutgoingReferences(conflicts, JSVisibilityUtil.DEFAULT_OPTIONS);
        return conflicts;
    }

    private void checkIncomingReferencesToPushedMembers(MultiMap<PsiElement, String> conflicts, @NotNull JSVisibilityUtil.Options options) {
        if (options == null) {
            FlexExtractSuperProcessor.$$$reportNull$$$0(6);
        }
        if (StringUtil.getPackageName((String)this.mySourceClass.getQualifiedName()).equals(this.myTargetPackage)) {
            return;
        }
        JSClass subClass = this.createFakeClass();
        for (JSFunction jSFunction : this.mySourceClass.getFunctions()) {
            this.checkIncomingReferencesToMovedMember(subClass, (JSAttributeListOwner)jSFunction, conflicts, options);
        }
        for (JSFunction jSFunction : this.mySourceClass.getFields()) {
            this.checkIncomingReferencesToMovedMember(subClass, (JSAttributeListOwner)jSFunction, conflicts, options);
        }
    }

    private void checkIncomingReferencesToMovedMember(JSClass subClass, JSAttributeListOwner member, MultiMap<PsiElement, String> conflicts, @NotNull JSVisibilityUtil.Options options) {
        if (options == null) {
            FlexExtractSuperProcessor.$$$reportNull$$$0(7);
        }
        if (JSConvertReferencesToSuperUtil.willBeInSuperclass((JSAttributeListOwner)member, (JSMemberInfo[])this.myMembersToMove, this.myMembersAfterMove)) {
            return;
        }
        ReferencesSearch.search((PsiElement)member, (SearchScope)member.getUseScope()).forEach(psiReference -> {
            PsiElement usageElement;
            if (options == null) {
                FlexExtractSuperProcessor.$$$reportNull$$$0(17);
            }
            if ((usageElement = psiReference.getElement()) instanceof JSReferenceExpression && !PsiTreeUtil.isAncestor((PsiElement)this.mySourceClass, (PsiElement)usageElement, (boolean)true) && !JSVisibilityUtil.isAccessible((PsiElement)member, (JSAttributeList)null, (JSClass)subClass, (PsiElement)usageElement, (JSVisibilityUtil.Options)options)) {
                PsiElement location = JSRefactoringConflictsUtil.getUsageLocation((PsiElement)usageElement);
                JSRefactoringConflictsUtil.reportInaccessibleElement((PsiElement)member, (JSClass)subClass, (PsiElement)location, (boolean)true, (MultiMap)conflicts, new HashSet());
            }
            return true;
        });
    }

    private void checkOutgoingReferences(MultiMap<PsiElement, String> conflicts, @NotNull JSVisibilityUtil.Options options) {
        if (options == null) {
            FlexExtractSuperProcessor.$$$reportNull$$$0(8);
        }
        if (StringUtil.getPackageName((String)this.mySourceClass.getQualifiedName()).equals(this.myTargetPackage)) {
            return;
        }
        JSClass subClass = this.createFakeClass();
        JSRefactoringConflictsUtil.checkOutgoingReferencesAccessibility((PsiElement)this.mySourceClass, Collections.singletonList(this.mySourceClass), (PsiElement)subClass, (boolean)true, conflicts, (Condition)Conditions.alwaysTrue(), (JSVisibilityUtil.Options)options);
    }

    private void checkIncomingReferencesToSubclass(UsageInfo[] usageInfos, MultiMap<PsiElement, String> conflicts, @NotNull JSVisibilityUtil.Options options) {
        if (options == null) {
            FlexExtractSuperProcessor.$$$reportNull$$$0(9);
        }
        if (StringUtil.getPackageName((String)this.mySourceClass.getQualifiedName()).equals(this.myTargetPackage)) {
            return;
        }
        JSClass subClass = this.createFakeClass();
        for (UsageInfo usageInfo : usageInfos) {
            if (JSVisibilityUtil.isAccessible((PsiElement)subClass, (JSAttributeList)null, null, (PsiElement)usageInfo.getElement(), (JSVisibilityUtil.Options)options)) continue;
            FlexExtractSuperProcessor.reportConflict((JSAttributeListOwner)subClass, usageInfo.getElement(), conflicts);
        }
    }

    private JSClass createFakeClass() {
        boolean isInterface;
        String accessModifier;
        if (this.myMode == JSExtractSuperMode.RenameImplementation) {
            String namespace = JSResolveUtil.getNamespaceValue((JSAttributeList)this.mySourceClass.getAttributeList());
            accessModifier = namespace != null ? namespace : JSFormatUtil.formatVisibility((JSAttributeList.AccessType)this.mySourceClass.getAttributeList().getAccessType());
            isInterface = this.mySourceClass.isInterface();
        } else {
            accessModifier = JSFormatUtil.formatVisibility((JSAttributeList.AccessType)JSAttributeList.AccessType.PUBLIC);
            isInterface = !this.myClassNotInterface;
        }
        try {
            String text = ActionScriptCreateClassOrInterfaceFix.getClassText((String)this.myTargetName, (String)this.myTargetPackage, (boolean)isInterface, (String)accessModifier, (Project)this.myProject);
            JSFile file = (JSFile)PsiFileFactory.getInstance((Project)this.myProject).createFileFromText(this.myTargetName + ".as", text);
            return JSPsiImplUtils.findClass((JSFile)file);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    protected void performRefactoring(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            FlexExtractSuperProcessor.$$$reportNull$$$0(10);
        }
        ArrayList<FormatFixer> formatters = new ArrayList<FormatFixer>();
        if (this.myMode == JSExtractSuperMode.ExtractSuper) {
            this.createSuperClassifier(formatters);
        } else if (this.myMode == JSExtractSuperMode.ExtractSuperTurnRefs) {
            this.createSuperClassifier(formatters);
            if (this.myTargetClass != null) {
                this.rebindReferencesToTarget(usages, formatters);
            }
        } else {
            if (ActionScriptResolveUtil.isFileLocalSymbol((PsiElement)this.mySourceClass)) {
                this.renameOriginalFileLocalClass(formatters);
            } else {
                this.renameOriginalClass(formatters);
            }
            if (this.myTargetClass != null) {
                this.rebindReferencesToTarget(usages, formatters);
            }
        }
        JSRefactoringUtil.format(formatters);
    }

    private void rebindReferencesToTarget(@NotNull UsageInfo[] usages, List<FormatFixer> formatters) {
        if (usages == null) {
            FlexExtractSuperProcessor.$$$reportNull$$$0(11);
        }
        this.bindRefsToTarget(usages, formatters);
        ArrayList<UsageInfo> usagesInMovedMembers = new ArrayList<UsageInfo>();
        HashMap<PsiElement, JSConvertReferencesToSuperUtil.Status> variablesResults = new HashMap<PsiElement, JSConvertReferencesToSuperUtil.Status>();
        JSConvertReferencesToSuperUtil util = new JSConvertReferencesToSuperUtil(this.myMembersToMove, this.myMembersAfterMove, this.myMode, this.mySourceClass, this.myTargetClass);
        for (JSElement memberAfterMove : this.myMembersAfterMove) {
            this.findUsagesAfterMove(memberAfterMove, usagesInMovedMembers, variablesResults, util);
        }
        this.bindRefsToTarget(usagesInMovedMembers.toArray(UsageInfo.EMPTY_ARRAY), formatters);
    }

    private void findUsagesAfterMove(JSElement scope, final Collection<UsageInfo> result, final Map<PsiElement, JSConvertReferencesToSuperUtil.Status> variablesResults, final JSConvertReferencesToSuperUtil util) {
        if (scope instanceof JSClass) {
            return;
        }
        scope.accept((PsiElementVisitor)new JSRecursiveElementVisitor(){

            public void visitJSReferenceExpression(JSReferenceExpression node) {
                if (util.getSubjectClass((JSElement)node).isEquivalentTo(node.resolve()) && util.canTurnReferenceToSuper(node, variablesResults) ^ FlexExtractSuperProcessor.this.myMode == JSExtractSuperMode.RenameImplementation) {
                    result.add(new UsageInfo((PsiElement)node));
                }
                super.visitJSReferenceExpression(node);
            }
        });
    }

    private void bindRefsToTarget(UsageInfo[] usages, List<FormatFixer> postponedFormatters) {
        HashSet<PsiFile> filesToOptimizeImports = new HashSet<PsiFile>();
        this.myTargetClass = (JSClass)this.myTargetClassPtr.getElement();
        String qName = this.myTargetClass.getQualifiedName();
        for (UsageInfo usage : usages) {
            JSReferenceExpression refExpr = (JSReferenceExpression)usage.getElement();
            if (refExpr == null) continue;
            if (refExpr.getQualifier() instanceof JSReferenceExpression) {
                refExpr.deleteChildRange((PsiElement)refExpr.getQualifier(), refExpr.getQualifier().getNextSibling());
            }
            refExpr = JSReferenceExpressionImpl.bindToElement((JSReferenceExpression)refExpr, (String)qName, (PsiNamedElement)this.myTargetClass, (boolean)false);
            if (!qName.contains(".") || !JSPsiImplUtils.differentPackageName((String)StringUtil.getPackageName((String)qName), (String)JSResolveUtil.getPackageNameFromPlace((PsiElement)refExpr))) continue;
            ImportUtils.doImport((PsiElement)refExpr, (String)qName, (boolean)false);
            filesToOptimizeImports.add(refExpr.getContainingFile());
            this.myTargetClass = (JSClass)this.myTargetClassPtr.getElement();
        }
        for (PsiFile affectedFile : filesToOptimizeImports) {
            postponedFormatters.addAll(ECMAScriptImportOptimizer.executeNoFormat((PsiFile)affectedFile));
        }
    }

    private void createSuperClassifier(List<FormatFixer> formatters) {
        try {
            ActionScriptCreateClassOrInterfaceFix.createClass((String)this.myTargetName, (String)this.myTargetPackage, (PsiDirectory)this.myTagretDirectory, (!this.myClassNotInterface ? 1 : 0) != 0);
        }
        catch (Exception e) {
            Messages.showErrorDialog((Project)this.mySourceClass.getProject(), (String)e.getMessage(), (String)this.getCommandName());
            return;
        }
        String targetFqn = StringUtil.getQualifiedName((String)this.myTargetPackage, (String)this.myTargetName);
        this.myTargetClass = (JSClass)JSDialectSpecificHandlersFactory.forElement((PsiElement)this.mySourceClass).getClassResolver().findClassByQName(targetFqn, (PsiElement)this.mySourceClass);
        SmartPsiElementPointer<JSClass> smartPsiElementPointer = this.myTargetClassPtr = this.myTargetClass == null ? null : SmartPointerManager.getInstance((Project)this.myProject).createSmartPsiElementPointer((PsiElement)this.myTargetClass);
        if (this.myClassNotInterface && !(this.mySourceClass instanceof XmlBackedJSClass) && this.mySourceClass.getExtendsList() != null && this.mySourceClass.getExtendsList().getReferenceTexts().length > 0) {
            JSClass existingSuperClass = this.mySourceClass.getSuperClasses()[0];
            JSRefactoringUtil.removeFromReferenceList((JSReferenceList)this.mySourceClass.getExtendsList(), (JSClass)existingSuperClass, formatters);
            JSRefactoringUtil.addToSupersList((JSClass)this.myTargetClass, (String)existingSuperClass.getName(), (boolean)false);
            if (ImportUtils.needsImport((String)this.myTargetPackage, (JSQualifiedNamedElement)existingSuperClass)) {
                ImportUtils.insertImportStatements((PsiElement)this.myTargetClass, Collections.singletonList(existingSuperClass.getQualifiedName()));
                formatters.addAll(ECMAScriptImportOptimizer.executeNoFormat((PsiFile)this.myTargetClass.getContainingFile()));
            }
        }
        JSRefactoringUtil.addToSupersList((JSClass)this.mySourceClass, (String)targetFqn, (!this.myClassNotInterface ? 1 : 0) != 0);
        if (!(this.mySourceClass instanceof XmlBackedJSClass) && ImportUtils.needsImport((JSQualifiedNamedElement)this.mySourceClass, (String)this.myTargetPackage)) {
            PsiFile file = this.mySourceClass.getContainingFile();
            ImportUtils.insertImportStatements((PsiElement)this.mySourceClass, Collections.singletonList(targetFqn));
            formatters.addAll(ECMAScriptImportOptimizer.executeNoFormat((PsiFile)file));
        }
        this.myMembersAfterMove = new JSPullUpHelper(this.mySourceClass, this.myTargetClass, this.myMembersToMove, this.myDocCommentPolicy).moveMembersToBase(formatters);
    }

    private void renameOriginalClass(List<FormatFixer> formatters) {
        try {
            Document document;
            String sourceClassQName = this.mySourceClass.getQualifiedName();
            String superClassifierText = ActionScriptCreateClassOrInterfaceFix.getClassText((String)this.mySourceClass.getName(), (String)StringUtil.getPackageName((String)sourceClassQName), (!this.myClassNotInterface ? 1 : 0) != 0, (String)JSFormatUtil.formatVisibility((JSAttributeList.AccessType)JSAttributeList.AccessType.PUBLIC), (Project)this.myProject);
            PsiFile sourceFile = this.mySourceClass.getContainingFile();
            String filename = this.myTargetName + "." + FileUtilRt.getExtension((String)sourceFile.getName());
            PsiFile file = PsiFileFactory.getInstance((Project)this.myProject).createFileFromText(filename, sourceFile.getText());
            file = (PsiFile)this.myTagretDirectory.add((PsiElement)file);
            if (this.mySourceClass instanceof XmlBackedJSClassImpl) {
                this.myTargetClass = XmlBackedJSClassFactory.getXmlBackedClass((XmlFile)((XmlFile)file));
                LOG.assertTrue(this.myTargetClass != null);
            } else {
                UserDataHolderBase dataHolder = new UserDataHolderBase();
                RenameMoveUtils.prepareMovedFile((JSFile)sourceFile, (UserDataHolder)dataHolder);
                RenameMoveUtils.updateMovedFile((JSFile)file, (UserDataHolder)dataHolder);
                JSQualifiedNamedElement element = JSPsiImplUtils.findQualifiedElement((JSFile)((JSFile)file));
                if (element instanceof JSClass) {
                    this.myTargetClass = (JSClass)element;
                    JSFunction constructor = this.myTargetClass.findFunctionByNameAndKind(this.mySourceClass.getName(), JSFunction.FunctionKind.SIMPLE);
                    if (constructor != null) {
                        constructor.setName(this.myTargetName);
                    }
                } else {
                    LOG.error("class not found in generated file:\n" + file.getText());
                }
            }
            this.myTargetClassPtr = this.myTargetClass == null ? null : SmartPointerManager.getInstance((Project)this.myProject).createSmartPsiElementPointer((PsiElement)this.myTargetClass);
            ArrayList membersToMove = new ArrayList();
            JSMemberInfo.extractSameMembers((JSClass)this.myTargetClass, (JSClass)this.mySourceClass, (JSMemberInfo[])this.myMembersToMove, membersToMove);
            for (JSMemberInfo info : membersToMove) {
                info.setChecked(true);
            }
            if (this.mySourceClass instanceof XmlBackedJSClassImpl) {
                VirtualFile vFile = sourceFile.getVirtualFile();
                vFile.rename((Object)this, FileUtil.getNameWithoutExtension((String)vFile.getName()) + "." + "as");
                document = FileDocumentManager.getInstance().getDocument(vFile);
            } else {
                document = PsiDocumentManager.getInstance((Project)this.myProject).getDocument(sourceFile);
            }
            if (document == null) {
                LOG.error("document not found for " + sourceFile);
            }
            document.setText((CharSequence)superClassifierText);
            PsiDocumentManager.getInstance((Project)this.myProject).commitDocument(document);
            JSRefactoringUtil.addToSupersList((JSClass)this.myTargetClass, (String)sourceClassQName, (!this.myClassNotInterface ? 1 : 0) != 0);
            sourceFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(document);
            JSClass superClass = (JSClass)PsiTreeUtil.getNextSiblingOfType((PsiElement)sourceFile.getFirstChild().getFirstChild(), JSClass.class);
            JSMemberInfo[] infosArray = JSMemberInfo.getSelected(membersToMove, (JSClass)this.myTargetClass, (Condition)Conditions.alwaysTrue());
            JSMemberInfo.sortByOffset((JSMemberInfo[])infosArray);
            this.myMembersAfterMove = new JSPullUpHelper(this.myTargetClass, superClass, infosArray, this.myDocCommentPolicy).moveMembersToBase(formatters);
        }
        catch (IOException e) {
            Messages.showErrorDialog((Project)this.mySourceClass.getProject(), (String)e.getMessage(), (String)this.getCommandName());
        }
        catch (IncorrectOperationException e) {
            Messages.showErrorDialog((Project)this.mySourceClass.getProject(), (String)e.getMessage(), (String)this.getCommandName());
        }
    }

    @NotNull
    public JSClass createJSClass(@NotNull Project project, PsiFile file, @NonNls @NotNull String text) {
        if (project == null) {
            FlexExtractSuperProcessor.$$$reportNull$$$0(12);
        }
        if (text == null) {
            FlexExtractSuperProcessor.$$$reportNull$$$0(13);
        }
        String filename = file.getName();
        PsiFile psiFile = PsiFileFactory.getInstance((Project)project).createFileFromText(filename, file.getFileType(), (CharSequence)text);
        JSClass jSClass = (JSClass)PsiTreeUtil.getParentOfType((PsiElement)psiFile.findElementAt(0), JSClass.class);
        if (jSClass == null) {
            FlexExtractSuperProcessor.$$$reportNull$$$0(14);
        }
        return jSClass;
    }

    private void renameOriginalFileLocalClass(List<FormatFixer> formatters) {
        JSRefactoringUtil.addToSupersList((JSClass)this.mySourceClass, (String)this.mySourceClass.getName(), (!this.myClassNotInterface ? 1 : 0) != 0);
        String superClassifierText = (this.myClassNotInterface ? "class" : "interface") + " " + this.mySourceClass.getName() + "{}";
        this.mySourceClass.setName(this.myTargetName);
        SmartPsiElementPointer subClassPointer = SmartPointerManager.getInstance((Project)this.myProject).createSmartPsiElementPointer((PsiElement)this.mySourceClass);
        PsiFile file = this.mySourceClass.getContainingFile();
        JSClass jsClass = this.createJSClass(this.myProject, this.mySourceClass.getContainingFile(), superClassifierText);
        this.mySourceClass = jsClass = (JSClass)file.addBefore((PsiElement)jsClass, (PsiElement)this.mySourceClass);
        this.myTargetClass = (JSClass)subClassPointer.getElement();
        this.myTargetClassPtr = this.myTargetClass == null ? null : SmartPointerManager.getInstance((Project)this.myProject).createSmartPsiElementPointer((PsiElement)this.myTargetClass);
        formatters.add(FormatFixer.create((PsiElement)this.mySourceClass, (PsiElement)this.myTargetClass, (FormatFixer.Mode)FormatFixer.Mode.Reformat));
        this.myMembersAfterMove = new JSPullUpHelper(this.myTargetClass, this.mySourceClass, this.myMembersToMove, this.myDocCommentPolicy).moveMembersToBase(formatters);
    }

    @NotNull
    protected String getCommandName() {
        if (this.myMode == JSExtractSuperMode.RenameImplementation) {
            String string = JSBundle.message((String)"extract.subclass.command.name", (Object[])new Object[]{StringUtil.getQualifiedName((String)this.myTargetPackage, (String)this.myTargetName), new JSNamedElementPresenter((PsiElement)this.mySourceClass).describeWithShortName()});
            if (string == null) {
                FlexExtractSuperProcessor.$$$reportNull$$$0(15);
            }
            return string;
        }
        String string = RefactoringBundle.message((String)(this.myClassNotInterface ? "extract.superclass.command.name" : "extract.interface.command.name"), (Object[])new Object[]{StringUtil.getQualifiedName((String)this.myTargetPackage, (String)this.myTargetName), new JSNamedElementPresenter((PsiElement)this.mySourceClass).describeWithShortName()});
        if (string == null) {
            FlexExtractSuperProcessor.$$$reportNull$$$0(16);
        }
        return string;
    }

    private static void reportConflict(JSAttributeListOwner subject, PsiElement from, MultiMap<PsiElement, String> conflicts) {
        String message = RefactoringBundle.message((String)"0.with.1.visibility.is.not.accessible.from.2", (Object[])new Object[]{ElementDescriptionUtil.getElementDescription((PsiElement)subject, (ElementDescriptionLocation)RefactoringDescriptionLocation.WITHOUT_PARENT), JSFormatUtil.formatVisibility((JSAttributeList.AccessType)subject.getAttributeList().getAccessType()), ElementDescriptionUtil.getElementDescription((PsiElement)JSRefactoringConflictsUtil.getUsageLocation((PsiElement)from), (ElementDescriptionLocation)RefactoringDescriptionLocation.WITH_PARENT)});
        message = StringUtil.capitalize((String)message);
        conflicts.putValue((Object)from, (Object)message);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 14: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 14: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/flex/refactoring/extractSuper/FlexExtractSuperProcessor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refUsages";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/flex/refactoring/extractSuper/FlexExtractSuperProcessor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createUsageViewDescriptor";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "findUsages";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createJSClass";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createUsageViewDescriptor";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 14: 
            case 15: 
            case 16: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "refreshElements";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "preprocessUsages";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "checkIncomingReferencesToPushedMembers";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "checkIncomingReferencesToMovedMember";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "checkOutgoingReferences";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "checkIncomingReferencesToSubclass";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "performRefactoring";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "rebindReferencesToTarget";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createJSClass";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "lambda$checkIncomingReferencesToMovedMember$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 14: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class JSExtractInterfaceUsageViewDescriptor
    extends UsageViewDescriptorAdapter {
        private JSExtractInterfaceUsageViewDescriptor() {
        }

        @NotNull
        public PsiElement[] getElements() {
            PsiElement[] psiElementArray = new PsiElement[]{FlexExtractSuperProcessor.this.mySourceClass};
            if (psiElementArray == null) {
                JSExtractInterfaceUsageViewDescriptor.$$$reportNull$$$0(0);
            }
            return psiElementArray;
        }

        public String getProcessedElementsHeader() {
            return RefactoringBundle.message((String)(FlexExtractSuperProcessor.this.myClassNotInterface ? "members.to.form.superclass" : "members.to.form.interface"));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/refactoring/extractSuper/FlexExtractSuperProcessor$JSExtractInterfaceUsageViewDescriptor", "getElements"));
        }
    }
}

