/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.flex.resolve;

import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.AccessibilityProcessingHandler;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import gnu.trove.THashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActionScriptAccessibilityProcessingHandler
extends AccessibilityProcessingHandler {
    private static final String AS3_NAMESPACE_VALUE = "http://adobe.com/AS3/2006/builtin";
    private String myTypeName;
    private Map<String, String> openedNses;
    private boolean defaultNsIsNotAllowed;
    private boolean anyNsAllowed;

    public ActionScriptAccessibilityProcessingHandler(@Nullable PsiElement _place, boolean skipNsResolving) {
        super(_place);
        JSReferenceExpression namespace;
        boolean bl = this.allowUnqualifiedStaticsFromInstance = this.place instanceof JSReferenceExpression && ((JSReferenceExpression)this.place).getQualifier() == null;
        if (this.place instanceof JSReferenceExpression && (namespace = ((JSReferenceExpression)this.place).getNamespaceElement()) != null) {
            String ns;
            String string = ns = skipNsResolving ? namespace.getText() : JSPsiImplUtils.calcNamespaceReference((PsiElement)this.place);
            if (ns != null) {
                this.openedNses = new THashMap(1);
                this.openedNses.put(ns, null);
                this.defaultNsIsNotAllowed = true;
            } else {
                this.anyNsAllowed = true;
            }
        }
    }

    public void setTypeName(String qualifiedName) {
        this.myTypeName = qualifiedName;
    }

    protected boolean acceptsForMembersVisibility(@NotNull JSPsiElementBase element, @NotNull SinkResolveProcessor resolveProcessor) {
        if (element == null) {
            ActionScriptAccessibilityProcessingHandler.$$$reportNull$$$0(0);
        }
        if (resolveProcessor == null) {
            ActionScriptAccessibilityProcessingHandler.$$$reportNull$$$0(1);
        }
        if (!(element instanceof JSAttributeListOwner)) {
            return true;
        }
        JSAttributeList attributeList = ((JSAttributeListOwner)element).getAttributeList();
        if (JSResolveUtil.getClassOfContext((PsiElement)this.place) != JSResolveUtil.getClassOfContext((PsiElement)element)) {
            if (!this.acceptPrivateMembers && attributeList != null && attributeList.getAccessType() == JSAttributeList.AccessType.PRIVATE) {
                resolveProcessor.addPossibleCandidateResult((PsiElement)element, "javascript.private.member.is.not.accessible.message");
                return false;
            }
            if (!this.acceptProtectedMembers && attributeList != null && attributeList.getAccessType() == JSAttributeList.AccessType.PROTECTED && (this.myClassScopes != null || ActionScriptAccessibilityProcessingHandler.isParentClassContext((PsiElement)element))) {
                resolveProcessor.addPossibleCandidateResult((PsiElement)element, "javascript.protected.member.is.not.accessible.message");
                return false;
            }
        }
        PsiElement elt = JSResolveUtil.findParent((PsiElement)element);
        if (this.processStatics) {
            if (attributeList == null || !attributeList.hasModifier(JSAttributeList.ModifierType.STATIC)) {
                if ("prototype".equals(resolveProcessor.getName())) {
                    return true;
                }
                resolveProcessor.addPossibleCandidateResult((PsiElement)element, "javascript.instance.member.is.not.accessible.message");
                return false;
            }
            if (this.myTypeName != null && elt instanceof JSClass && !this.myTypeName.equals(((JSClass)elt).getQualifiedName())) {
                resolveProcessor.addPossibleCandidateResult((PsiElement)element, "javascript.static.member.is.not.accessible.message");
                return false;
            }
        } else if (this.myClassDeclarationStarted && !this.allowUnqualifiedStaticsFromInstance && attributeList != null && attributeList.hasModifier(JSAttributeList.ModifierType.STATIC)) {
            JSElement expression;
            JSExpression qualifier;
            boolean referencingClass = false;
            if (this.place instanceof JSReferenceExpression && (qualifier = ((JSReferenceExpression)this.place).getQualifier()) instanceof JSReferenceExpression && (expression = JSSymbolUtil.calcRefExprValue((JSReferenceExpression)((JSReferenceExpression)qualifier))) instanceof JSReferenceExpression) {
                for (ResolveResult r : ((JSReferenceExpression)expression).multiResolve(false)) {
                    PsiElement rElement = r.getElement();
                    if (!(rElement instanceof JSClass)) continue;
                    referencingClass = true;
                    break;
                }
            }
            if (!referencingClass) {
                resolveProcessor.addPossibleCandidateResult((PsiElement)element, "javascript.static.member.is.not.accessible.message");
                return false;
            }
        }
        return !this.processActionScriptNotAllowedNsAttributes((PsiElement)element, resolveProcessor, attributeList);
    }

    private boolean processActionScriptNotAllowedNsAttributes(@NotNull PsiElement element, @NotNull SinkResolveProcessor resolveProcessor, @Nullable JSAttributeList attributeList) {
        String attributeNs;
        if (element == null) {
            ActionScriptAccessibilityProcessingHandler.$$$reportNull$$$0(2);
        }
        if (resolveProcessor == null) {
            ActionScriptAccessibilityProcessingHandler.$$$reportNull$$$0(3);
        }
        if (!resolveProcessor.getResultSink().isActionScript()) {
            return false;
        }
        String string = attributeNs = attributeList != null ? attributeList.getNamespace() : null;
        if (attributeNs != null) {
            if (!resolveProcessor.isProcessingFromIndices()) {
                String resolvedNs = attributeList.resolveNamespaceValue();
                if (resolvedNs == null && !resolveProcessor.getResultSink().isActionScript()) {
                    resolvedNs = attributeNs;
                }
                attributeNs = resolvedNs;
            } else {
                attributeNs = null;
            }
        }
        if (this.openedNses == null && attributeNs != null && !this.anyNsAllowed && this.place instanceof JSReferenceExpression && !JSResolveUtil.isExprInTypeContext((JSReferenceExpression)((JSReferenceExpression)this.place))) {
            this.openedNses = JSResolveUtil.calculateOpenNses((PsiElement)this.place);
        }
        if (!(this.openedNses == null || this.openedNses.containsKey(attributeNs) || AS3_NAMESPACE_VALUE.equals(attributeNs) || "AS3".equals(attributeNs) || attributeNs == null && !this.defaultNsIsNotAllowed)) {
            resolveProcessor.addPossibleCandidateResult(element, "javascript.member.from.unopened.namespace.message");
            return true;
        }
        return false;
    }

    protected boolean checkConstructorWithNew(@NotNull PsiElement element, @NotNull SinkResolveProcessor resolveProcessor) {
        if (element == null) {
            ActionScriptAccessibilityProcessingHandler.$$$reportNull$$$0(4);
        }
        if (resolveProcessor == null) {
            ActionScriptAccessibilityProcessingHandler.$$$reportNull$$$0(5);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveProcessor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/javascript/flex/resolve/ActionScriptAccessibilityProcessingHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "acceptsForMembersVisibility";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "processActionScriptNotAllowedNsAttributes";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "checkConstructorWithNew";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

