/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.actionscript.arrangement;

import com.intellij.lang.Language;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.arrangement.JSArrangementEntry;
import com.intellij.lang.javascript.arrangement.JSElementArrangementEntry;
import com.intellij.lang.javascript.arrangement.JSRearrangerBase;
import com.intellij.lang.javascript.generation.ActionScriptGenerateEventHandler;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.arrangement.ArrangementSettings;
import com.intellij.psi.codeStyle.arrangement.ArrangementSettingsSerializer;
import com.intellij.psi.codeStyle.arrangement.DefaultArrangementSettingsSerializer;
import com.intellij.psi.codeStyle.arrangement.group.ArrangementGroupingRule;
import com.intellij.psi.codeStyle.arrangement.match.StdArrangementMatchRule;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementSettings;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementTokens;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActionScriptRearranger
extends JSRearrangerBase {
    private static final Logger LOG = Logger.getInstance((String)ActionScriptRearranger.class.getName());
    private static final Set<ArrangementSettingsToken> SUPPORTED_TYPES = ContainerUtilRt.newLinkedHashSet((Object[])new ArrangementSettingsToken[]{StdArrangementTokens.EntryType.CONSTRUCTOR, StdArrangementTokens.EntryType.METHOD, StdArrangementTokens.EntryType.STATIC_INIT, StdArrangementTokens.EntryType.CONST, StdArrangementTokens.EntryType.VAR, StdArrangementTokens.EntryType.PROPERTY, StdArrangementTokens.EntryType.EVENT_HANDLER});
    private static final Set<ArrangementSettingsToken> SUPPORTED_MODIFIERS = ContainerUtilRt.newLinkedHashSet((Object[])new ArrangementSettingsToken[]{StdArrangementTokens.Modifier.PUBLIC, StdArrangementTokens.Modifier.PROTECTED, StdArrangementTokens.Modifier.PACKAGE_PRIVATE, StdArrangementTokens.Modifier.PRIVATE, StdArrangementTokens.Modifier.STATIC, StdArrangementTokens.Modifier.FINAL, StdArrangementTokens.Modifier.OVERRIDE});
    private static final Set<ArrangementSettingsToken> VISIBILITY_MODIFIERS = ContainerUtilRt.newLinkedHashSet((Object[])new ArrangementSettingsToken[]{StdArrangementTokens.Modifier.PUBLIC, StdArrangementTokens.Modifier.PROTECTED, StdArrangementTokens.Modifier.PACKAGE_PRIVATE, StdArrangementTokens.Modifier.PRIVATE});
    private final StdArrangementSettings DEFAULT_SETTINGS;
    private final DefaultArrangementSettingsSerializer SETTINGS_SERIALIZER;

    public ActionScriptRearranger() {
        List<ArrangementGroupingRule> groupingRules = Collections.singletonList(new ArrangementGroupingRule(StdArrangementTokens.Grouping.GROUP_PROPERTY_FIELD_WITH_GETTER_SETTER));
        List<StdArrangementMatchRule> matchRules = ActionScriptRearranger.getDefaultMatchRules();
        this.DEFAULT_SETTINGS = StdArrangementSettings.createByMatchRules(groupingRules, matchRules);
        this.SETTINGS_SERIALIZER = new DefaultArrangementSettingsSerializer(this.DEFAULT_SETTINGS);
    }

    @NotNull
    protected ArrangementSettingsToken detectFieldType(@NotNull ArrangementSettings settings, @NotNull JSVariable variable) {
        if (settings == null) {
            ActionScriptRearranger.$$$reportNull$$$0(0);
        }
        if (variable == null) {
            ActionScriptRearranger.$$$reportNull$$$0(1);
        }
        ArrangementSettingsToken arrangementSettingsToken = variable.isConst() ? StdArrangementTokens.EntryType.CONST : StdArrangementTokens.EntryType.VAR;
        if (arrangementSettingsToken == null) {
            ActionScriptRearranger.$$$reportNull$$$0(2);
        }
        return arrangementSettingsToken;
    }

    @NotNull
    protected ArrangementSettingsToken detectFunctionType(@NotNull JSFunction function) {
        if (function == null) {
            ActionScriptRearranger.$$$reportNull$$$0(3);
        }
        if (ActionScriptRearranger.isEventHandler(function)) {
            ArrangementSettingsToken arrangementSettingsToken = StdArrangementTokens.EntryType.EVENT_HANDLER;
            if (arrangementSettingsToken == null) {
                ActionScriptRearranger.$$$reportNull$$$0(4);
            }
            return arrangementSettingsToken;
        }
        ArrangementSettingsToken arrangementSettingsToken = super.detectFunctionType(function);
        if (arrangementSettingsToken == null) {
            ActionScriptRearranger.$$$reportNull$$$0(5);
        }
        return arrangementSettingsToken;
    }

    @NotNull
    protected Set<ArrangementSettingsToken> getSupportedTypes() {
        Set<ArrangementSettingsToken> set = SUPPORTED_TYPES;
        if (set == null) {
            ActionScriptRearranger.$$$reportNull$$$0(6);
        }
        return set;
    }

    @NotNull
    protected Set<ArrangementSettingsToken> getVisibilityModifiers() {
        Set<ArrangementSettingsToken> set = VISIBILITY_MODIFIERS;
        if (set == null) {
            ActionScriptRearranger.$$$reportNull$$$0(7);
        }
        return set;
    }

    @NotNull
    protected Set<ArrangementSettingsToken> getSupportedModifiers() {
        Set<ArrangementSettingsToken> set = SUPPORTED_MODIFIERS;
        if (set == null) {
            ActionScriptRearranger.$$$reportNull$$$0(8);
        }
        return set;
    }

    @Nullable
    public StdArrangementSettings getDefaultSettings() {
        return this.DEFAULT_SETTINGS;
    }

    @NotNull
    public ArrangementSettingsSerializer getSerializer() {
        DefaultArrangementSettingsSerializer defaultArrangementSettingsSerializer = this.SETTINGS_SERIALIZER;
        if (defaultArrangementSettingsSerializer == null) {
            ActionScriptRearranger.$$$reportNull$$$0(9);
        }
        return defaultArrangementSettingsSerializer;
    }

    public int getBlankLines(@NotNull CodeStyleSettings settings, @Nullable JSArrangementEntry parent, @Nullable JSArrangementEntry previous, @NotNull JSArrangementEntry target) {
        ArrangementSettingsToken type;
        if (settings == null) {
            ActionScriptRearranger.$$$reportNull$$$0(10);
        }
        if (target == null) {
            ActionScriptRearranger.$$$reportNull$$$0(11);
        }
        if (previous == null) {
            return -1;
        }
        CommonCodeStyleSettings commonSettings = settings.getCommonSettings((Language)JavaScriptSupportLoader.ECMA_SCRIPT_L4);
        JSElementArrangementEntry targetEntry = (JSElementArrangementEntry)ObjectUtils.tryCast((Object)target, JSElementArrangementEntry.class);
        ArrangementSettingsToken arrangementSettingsToken = type = targetEntry != null ? targetEntry.getType() : null;
        if (StdArrangementTokens.EntryType.VAR.equals((Object)type) || StdArrangementTokens.EntryType.CONST.equals((Object)type)) {
            return commonSettings.BLANK_LINES_AROUND_FIELD;
        }
        if (StdArrangementTokens.EntryType.STATIC_INIT.equals((Object)type) || StdArrangementTokens.EntryType.CONSTRUCTOR.equals((Object)type) || StdArrangementTokens.EntryType.METHOD.equals((Object)type) || StdArrangementTokens.EntryType.PROPERTY.equals((Object)type) || StdArrangementTokens.EntryType.EVENT_HANDLER.equals((Object)type)) {
            return commonSettings.BLANK_LINES_AROUND_METHOD;
        }
        return -1;
    }

    @NotNull
    protected Set<ArrangementSettingsToken> detectModifiers(@NotNull JSAttributeListOwner fieldOrMethod) {
        if (fieldOrMethod == null) {
            ActionScriptRearranger.$$$reportNull$$$0(12);
        }
        HashSet result = ContainerUtil.newHashSet();
        JSAttributeList attributes = fieldOrMethod.getAttributeList();
        if (attributes != null) {
            String namespace;
            JSAttributeList.AccessType accessType = attributes.getExplicitAccessType();
            if (accessType == null && (namespace = attributes.getNamespace()) == null) {
                accessType = JSAttributeList.AccessType.PACKAGE_LOCAL;
            }
            if (accessType != null) {
                switch (accessType) {
                    case PUBLIC: {
                        result.add(StdArrangementTokens.Modifier.PUBLIC);
                        break;
                    }
                    case PROTECTED: {
                        result.add(StdArrangementTokens.Modifier.PROTECTED);
                        break;
                    }
                    case PACKAGE_LOCAL: {
                        result.add(StdArrangementTokens.Modifier.PACKAGE_PRIVATE);
                        break;
                    }
                    case PRIVATE: {
                        result.add(StdArrangementTokens.Modifier.PRIVATE);
                    }
                }
            }
            if (attributes.hasModifier(JSAttributeList.ModifierType.STATIC)) {
                result.add(StdArrangementTokens.Modifier.STATIC);
            }
            if (attributes.hasModifier(JSAttributeList.ModifierType.FINAL)) {
                result.add(StdArrangementTokens.Modifier.FINAL);
            }
            if (attributes.hasModifier(JSAttributeList.ModifierType.OVERRIDE)) {
                result.add(StdArrangementTokens.Modifier.OVERRIDE);
            }
        }
        HashSet hashSet = result;
        if (hashSet == null) {
            ActionScriptRearranger.$$$reportNull$$$0(13);
        }
        return hashSet;
    }

    private static boolean isEventHandler(JSFunction function) {
        PsiElement resolve;
        PsiElement typeElement;
        JSParameter[] parameters = function.getParameterVariables();
        return parameters.length == 1 && (typeElement = parameters[0].getTypeElement()) instanceof JSReferenceExpression && (resolve = ((JSReferenceExpression)typeElement).resolve()) instanceof JSClass && ("flash.events.Event".equals(((JSClass)resolve).getQualifiedName()) || "starling.events.Event".equals(((JSClass)resolve).getQualifiedName()) || ActionScriptGenerateEventHandler.isEventClass((JSClass)resolve));
    }

    public static List<StdArrangementMatchRule> getDefaultMatchRules() {
        ArrayList<StdArrangementMatchRule> matchRules = new ArrayList<StdArrangementMatchRule>();
        Set<ArrangementSettingsToken> visibility = VISIBILITY_MODIFIERS;
        ActionScriptRearranger.addRule(matchRules, (ArrangementSettingsToken[])new ArrangementSettingsToken[]{StdArrangementTokens.EntryType.STATIC_INIT});
        ActionScriptRearranger.addRule(matchRules, (ArrangementSettingsToken[])new ArrangementSettingsToken[]{StdArrangementTokens.EntryType.CONST});
        for (ArrangementSettingsToken modifier : visibility) {
            ActionScriptRearranger.addRule(matchRules, (ArrangementSettingsToken[])new ArrangementSettingsToken[]{StdArrangementTokens.EntryType.VAR, modifier, StdArrangementTokens.Modifier.STATIC});
        }
        for (ArrangementSettingsToken modifier : visibility) {
            ActionScriptRearranger.addRule(matchRules, (ArrangementSettingsToken[])new ArrangementSettingsToken[]{StdArrangementTokens.EntryType.PROPERTY, modifier, StdArrangementTokens.Modifier.STATIC});
        }
        for (ArrangementSettingsToken modifier : visibility) {
            ActionScriptRearranger.addRule(matchRules, (ArrangementSettingsToken[])new ArrangementSettingsToken[]{StdArrangementTokens.EntryType.METHOD, modifier, StdArrangementTokens.Modifier.STATIC});
        }
        ActionScriptRearranger.addRule(matchRules, (ArrangementSettingsToken[])new ArrangementSettingsToken[]{StdArrangementTokens.EntryType.CONSTRUCTOR});
        for (ArrangementSettingsToken modifier : visibility) {
            ActionScriptRearranger.addRule(matchRules, (ArrangementSettingsToken[])new ArrangementSettingsToken[]{StdArrangementTokens.EntryType.VAR, modifier});
        }
        ActionScriptRearranger.addRule(matchRules, (ArrangementSettingsToken[])new ArrangementSettingsToken[]{StdArrangementTokens.EntryType.PROPERTY, StdArrangementTokens.Modifier.OVERRIDE});
        for (ArrangementSettingsToken modifier : visibility) {
            ActionScriptRearranger.addRule(matchRules, (ArrangementSettingsToken[])new ArrangementSettingsToken[]{StdArrangementTokens.EntryType.PROPERTY, modifier});
        }
        ActionScriptRearranger.addRule(matchRules, (ArrangementSettingsToken[])new ArrangementSettingsToken[]{StdArrangementTokens.EntryType.METHOD, StdArrangementTokens.Modifier.OVERRIDE});
        for (ArrangementSettingsToken modifier : visibility) {
            ActionScriptRearranger.addRule(matchRules, (ArrangementSettingsToken[])new ArrangementSettingsToken[]{StdArrangementTokens.EntryType.METHOD, modifier});
        }
        ActionScriptRearranger.addRule(matchRules, (ArrangementSettingsToken[])new ArrangementSettingsToken[]{StdArrangementTokens.EntryType.EVENT_HANDLER, StdArrangementTokens.Modifier.OVERRIDE});
        for (ArrangementSettingsToken modifier : visibility) {
            ActionScriptRearranger.addRule(matchRules, (ArrangementSettingsToken[])new ArrangementSettingsToken[]{StdArrangementTokens.EntryType.EVENT_HANDLER, modifier});
        }
        return matchRules;
    }

    protected boolean isModifierEnabled(@NotNull ArrangementSettingsToken modifier, @NotNull ArrangementSettingsToken type, @NotNull Set<ArrangementSettingsToken> existingModifiers) {
        if (modifier == null) {
            ActionScriptRearranger.$$$reportNull$$$0(14);
        }
        if (type == null) {
            ActionScriptRearranger.$$$reportNull$$$0(15);
        }
        if (existingModifiers == null) {
            ActionScriptRearranger.$$$reportNull$$$0(16);
        }
        if (StdArrangementTokens.EntryType.STATIC_INIT.equals((Object)type)) {
            return false;
        }
        if (StdArrangementTokens.EntryType.CONST.equals((Object)type)) {
            return StdArrangementTokens.Modifier.PUBLIC.equals((Object)modifier) || StdArrangementTokens.Modifier.PROTECTED.equals((Object)modifier) || StdArrangementTokens.Modifier.PACKAGE_PRIVATE.equals((Object)modifier) || StdArrangementTokens.Modifier.PRIVATE.equals((Object)modifier);
        }
        if (StdArrangementTokens.EntryType.VAR.equals((Object)type)) {
            return StdArrangementTokens.Modifier.STATIC.equals((Object)modifier) || StdArrangementTokens.Modifier.PUBLIC.equals((Object)modifier) || StdArrangementTokens.Modifier.PROTECTED.equals((Object)modifier) || StdArrangementTokens.Modifier.PACKAGE_PRIVATE.equals((Object)modifier) || StdArrangementTokens.Modifier.PRIVATE.equals((Object)modifier);
        }
        if (StdArrangementTokens.EntryType.CONSTRUCTOR.equals((Object)type)) {
            return false;
        }
        if (StdArrangementTokens.EntryType.METHOD.equals((Object)type) || StdArrangementTokens.EntryType.PROPERTY.equals((Object)type) || StdArrangementTokens.EntryType.EVENT_HANDLER.equals((Object)type)) {
            if (StdArrangementTokens.Modifier.OVERRIDE.equals((Object)modifier) && existingModifiers.contains(StdArrangementTokens.Modifier.STATIC)) {
                return false;
            }
            if (StdArrangementTokens.Modifier.STATIC.equals((Object)modifier) && (existingModifiers.contains(StdArrangementTokens.Modifier.OVERRIDE) || existingModifiers.contains(StdArrangementTokens.Modifier.FINAL))) {
                return false;
            }
            return !StdArrangementTokens.Modifier.FINAL.equals((Object)modifier) || !existingModifiers.contains(StdArrangementTokens.Modifier.STATIC);
        }
        LOG.error((Object)type);
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/actionscript/arrangement/ActionScriptRearranger";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldOrMethod";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifier";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existingModifiers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/actionscript/arrangement/ActionScriptRearranger";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "detectFieldType";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "detectFunctionType";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedTypes";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisibilityModifiers";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedModifiers";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSerializer";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "detectModifiers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "detectFieldType";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 13: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "detectFunctionType";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getBlankLines";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "detectModifiers";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isModifierEnabled";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

