/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.actions.addAsLib;

import com.intellij.flex.model.bc.LinkageType;
import com.intellij.icons.AllIcons;
import com.intellij.lang.javascript.flex.FlexBundle;
import com.intellij.lang.javascript.flex.actions.FlexBCTree;
import com.intellij.lang.javascript.flex.library.FlexLibraryProperties;
import com.intellij.lang.javascript.flex.library.FlexLibraryType;
import com.intellij.lang.javascript.flex.projectStructure.FlexBuildConfigurationsExtension;
import com.intellij.lang.javascript.flex.projectStructure.model.DependencyEntry;
import com.intellij.lang.javascript.flex.projectStructure.model.FlexBuildConfiguration;
import com.intellij.lang.javascript.flex.projectStructure.model.FlexBuildConfigurationManager;
import com.intellij.lang.javascript.flex.projectStructure.model.ModifiableFlexBuildConfiguration;
import com.intellij.lang.javascript.flex.projectStructure.model.ModifiableModuleLibraryEntry;
import com.intellij.lang.javascript.flex.projectStructure.model.ModifiableSharedLibraryEntry;
import com.intellij.lang.javascript.flex.projectStructure.model.ModuleLibraryEntry;
import com.intellij.lang.javascript.flex.projectStructure.model.SharedLibraryEntry;
import com.intellij.lang.javascript.flex.projectStructure.model.impl.FlexProjectConfigurationEditor;
import com.intellij.lang.javascript.flex.projectStructure.options.FlexProjectRootsUtil;
import com.intellij.lang.javascript.flex.projectStructure.ui.DependenciesConfigurable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.ApplicationLibraryTable;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.impl.libraries.ProjectLibraryTable;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryProperties;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.navigation.Place;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.IconUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddAsSwcLibDialog
extends DialogWrapper {
    private final Project myProject;
    private final List<VirtualFile> myRoots;
    private JPanel myMainPanel;
    private FlexBCTree myBCTree;
    private JBList myLibComponentsList;
    private JCheckBox myOpenProjectStructureCheckBox;

    public AddAsSwcLibDialog(@NotNull Project project, @Nullable Module preferredModule, List<VirtualFile> roots) {
        if (project == null) {
            AddAsSwcLibDialog.$$$reportNull$$$0(0);
        }
        super(project);
        this.myProject = project;
        this.myRoots = roots;
        Object[] objectArray = new Object[]{};
        this.$$$setupUI$$$();
        this.setTitle(FlexBundle.message("add.as.library.title", objectArray));
        if (preferredModule != null) {
            FlexBuildConfiguration bc = FlexBuildConfigurationManager.getInstance(preferredModule).getActiveConfiguration();
            this.myBCTree.selectRow(preferredModule, bc);
        }
        this.myLibComponentsList.setModel((ListModel)JBList.createDefaultListModel((Object[])roots.toArray(VirtualFile.EMPTY_ARRAY)));
        this.myLibComponentsList.setCellRenderer((ListCellRenderer)new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel component = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                VirtualFile file = (VirtualFile)value;
                component.setText(FileUtil.toSystemDependentName((String)file.getPath()));
                if (file.isDirectory() && file.isInLocalFileSystem()) {
                    component.setIcon(AllIcons.Nodes.JarDirectory);
                } else {
                    VirtualFile localFile = JarFileSystem.getInstance().getLocalByEntry(file);
                    if (localFile != null) {
                        component.setText(FileUtil.toSystemDependentName((String)localFile.getPath()));
                        component.setIcon(IconUtil.getIcon((VirtualFile)localFile, (int)0, null));
                    }
                }
                return component;
            }
        });
        this.myLibComponentsList.setVisibleRowCount(this.myLibComponentsList.getItemsCount());
        this.init();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myMainPanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myBCTree;
    }

    private void createUIComponents() {
        this.myBCTree = new FlexBCTree(this.myProject);
        this.myBCTree.setCheckedStatusForAll(false);
        this.myBCTree.setVisibleRowCount(Math.min(this.myBCTree.getRowCount(), 15));
    }

    @Nullable
    protected ValidationInfo doValidate() {
        if (this.myBCTree.getSelectedBCs().isEmpty()) {
            return new ValidationInfo("No build configurations selected");
        }
        return null;
    }

    protected void doOKAction() {
        Collection<Pair<Module, FlexBuildConfiguration>> modulesAndBCs = this.myBCTree.getSelectedBCs();
        THashMap moduleToModifiableModelMap = new THashMap();
        for (Pair<Module, FlexBuildConfiguration> moduleAndBC : modulesAndBCs) {
            moduleToModifiableModelMap.put(moduleAndBC.first, ModuleRootManager.getInstance((Module)((Module)moduleAndBC.first)).getModifiableModel());
        }
        LibraryTable.ModifiableModel projectLibsModel = ProjectLibraryTable.getInstance((Project)this.myProject).getModifiableModel();
        LibraryTable.ModifiableModel globalLibsModel = ApplicationLibraryTable.getApplicationTable().getModifiableModel();
        FlexProjectConfigurationEditor flexConfigEditor = FlexProjectConfigurationEditor.createEditor(this.myProject, (Map<Module, ModifiableRootModel>)moduleToModifiableModelMap, projectLibsModel, globalLibsModel);
        AddAsSwcLibDialog.addLib(flexConfigEditor, modulesAndBCs, this.myRoots);
        try {
            flexConfigEditor.commit();
        }
        catch (ConfigurationException e) {
            Logger.getInstance(AddAsSwcLibDialog.class).error((Throwable)e);
        }
        ApplicationManager.getApplication().runWriteAction(() -> AddAsSwcLibDialog.lambda$doOKAction$0(globalLibsModel, projectLibsModel, (Map)moduleToModifiableModelMap));
        if (this.myOpenProjectStructureCheckBox.isSelected()) {
            Pair<Module, FlexBuildConfiguration> moduleAndBc = modulesAndBCs.iterator().next();
            this.openProjectStructure((Module)moduleAndBc.first, (FlexBuildConfiguration)moduleAndBc.second);
        }
        super.doOKAction();
    }

    private static void addLib(FlexProjectConfigurationEditor flexConfigEditor, Collection<Pair<Module, FlexBuildConfiguration>> modulesAndBCs, List<VirtualFile> roots) {
        for (Pair<Module, FlexBuildConfiguration> moduleAndBc : modulesAndBCs) {
            ModifiableFlexBuildConfiguration[] bcs;
            Module module = (Module)moduleAndBc.first;
            ModifiableFlexBuildConfiguration bc = null;
            for (ModifiableFlexBuildConfiguration each : bcs = flexConfigEditor.getConfigurations(module)) {
                if (!each.getName().equals(((FlexBuildConfiguration)moduleAndBc.second).getName())) continue;
                bc = each;
                break;
            }
            if (bc == null) continue;
            Collection<VirtualFile> filteredRoots = AddAsSwcLibDialog.filterAlreadyExistingRoots(roots, flexConfigEditor, module, bc);
            LibraryTable.ModifiableModel libraryModel = flexConfigEditor.getLibraryModel(bc.getDependencies());
            for (VirtualFile file : filteredRoots) {
                Library library = libraryModel.createLibrary(null, FlexLibraryType.FLEX_LIBRARY);
                LibraryEx.ModifiableModelEx libraryModifiableModel = (LibraryEx.ModifiableModelEx)library.getModifiableModel();
                String libraryId = UUID.randomUUID().toString();
                libraryModifiableModel.setProperties((LibraryProperties)new FlexLibraryProperties(libraryId));
                if (file.isInLocalFileSystem() && file.isDirectory()) {
                    libraryModifiableModel.addJarDirectory(file, false);
                } else {
                    libraryModifiableModel.addRoot(file, OrderRootType.CLASSES);
                }
                ApplicationManager.getApplication().runWriteAction(() -> libraryModifiableModel.commit());
                ModifiableModuleLibraryEntry libraryEntry = flexConfigEditor.createModuleLibraryEntry(bc.getDependencies(), libraryId);
                libraryEntry.getDependencyType().setLinkageType(LinkageType.Merged);
                bc.getDependencies().getModifiableEntries().add(libraryEntry);
            }
        }
    }

    private static Collection<VirtualFile> filterAlreadyExistingRoots(Collection<VirtualFile> roots, FlexProjectConfigurationEditor flexConfigEditor, Module module, ModifiableFlexBuildConfiguration bc) {
        DependencyEntry[] entries;
        THashSet result = new THashSet(roots);
        for (DependencyEntry entry : entries = bc.getDependencies().getEntries()) {
            Library library;
            if (entry instanceof ModifiableModuleLibraryEntry) {
                LibraryOrderEntry orderEntry = FlexProjectRootsUtil.findOrderEntry((ModuleLibraryEntry)entry, (ModuleRootModel)flexConfigEditor.getModifiableRootModel(module));
                if (orderEntry == null) continue;
                for (VirtualFile file : orderEntry.getRootFiles(OrderRootType.CLASSES)) {
                    if (!result.contains(file)) continue;
                    result.remove(file);
                }
                continue;
            }
            if (!(entry instanceof ModifiableSharedLibraryEntry) || (library = FlexProjectRootsUtil.findOrderEntry(module.getProject(), (SharedLibraryEntry)entry)) == null) continue;
            for (VirtualFile file : library.getFiles(OrderRootType.CLASSES)) {
                if (!result.contains(file)) continue;
                result.remove(file);
            }
        }
        return result;
    }

    private void openProjectStructure(Module module, FlexBuildConfiguration bc) {
        ApplicationManager.getApplication().invokeLater(() -> {
            ProjectStructureConfigurable configurable = ProjectStructureConfigurable.getInstance((Project)this.myProject);
            ShowSettingsUtil.getInstance().editConfigurable(this.myProject, (Configurable)configurable, () -> {
                Place place = FlexBuildConfigurationsExtension.getInstance().getConfigurator().getPlaceFor(module, bc.getName()).putPath("tabName", (Object)DependenciesConfigurable.TAB_NAME);
                configurable.navigateTo(place, true);
            });
        });
    }

    private static /* synthetic */ void lambda$doOKAction$0(LibraryTable.ModifiableModel globalLibsModel, LibraryTable.ModifiableModel projectLibsModel, Map moduleToModifiableModelMap) {
        globalLibsModel.commit();
        projectLibsModel.commit();
        for (ModifiableRootModel modifiableRootModel : moduleToModifiableModelMap.values()) {
            modifiableRootModel.commit();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/flex/actions/addAsLib/AddAsSwcLibDialog", "<init>"));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBList jBList;
        JCheckBox jCheckBox;
        JPanel jPanel;
        this.createUIComponents();
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(6, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myOpenProjectStructureCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Open Project Structure after adding a library");
        jCheckBox.setMnemonic('O');
        jCheckBox.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jCheckBox, new GridConstraints(5, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, new Dimension(-1, 10), null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 0, null, null, null));
        this.myLibComponentsList = jBList = new JBList();
        jBScrollPane.setViewportView((Component)jBList);
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Library contents:");
        jPanel.add((Component)jBLabel, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Add library to the dependencies of the following Flash build configurations: ");
        jPanel.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBScrollPane jBScrollPane2 = new JBScrollPane();
        jPanel.add((Component)jBScrollPane2, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        FlexBCTree flexBCTree = this.myBCTree;
        jBScrollPane2.setViewportView((Component)((Object)flexBCTree));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

