/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.build;

import com.intellij.lang.javascript.flex.FlexUtils;
import com.intellij.lang.javascript.flex.projectStructure.model.Dependencies;
import com.intellij.lang.javascript.flex.projectStructure.model.DependencyEntry;
import com.intellij.lang.javascript.flex.projectStructure.model.ModuleLibraryEntry;
import com.intellij.lang.javascript.flex.projectStructure.model.SharedLibraryEntry;
import com.intellij.lang.javascript.flex.projectStructure.options.FlexProjectRootsUtil;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.ZipUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Logger;
import org.jetbrains.annotations.Nullable;

public class FlexCompilationUtils {
    private FlexCompilationUtils() {
    }

    public static Collection<VirtualFile> getANEFiles(ModuleRootModel moduleRootModel, Dependencies dependencies) {
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        for (DependencyEntry entry : dependencies.getEntries()) {
            Library library;
            if (entry instanceof ModuleLibraryEntry) {
                LibraryOrderEntry orderEntry = FlexProjectRootsUtil.findOrderEntry((ModuleLibraryEntry)entry, moduleRootModel);
                if (orderEntry == null) continue;
                for (VirtualFile libFile : orderEntry.getRootFiles(OrderRootType.CLASSES)) {
                    FlexCompilationUtils.addIfANE(result, libFile);
                }
                continue;
            }
            if (!(entry instanceof SharedLibraryEntry) || (library = FlexProjectRootsUtil.findOrderEntry(moduleRootModel.getModule().getProject(), (SharedLibraryEntry)entry)) == null) continue;
            for (VirtualFile libFile : library.getFiles(OrderRootType.CLASSES)) {
                FlexCompilationUtils.addIfANE(result, libFile);
            }
        }
        return result;
    }

    private static void addIfANE(Collection<? super VirtualFile> result, VirtualFile libFile) {
        VirtualFile realFile = FlexCompilationUtils.getRealFile(libFile);
        if (realFile != null && !realFile.isDirectory() && "ane".equalsIgnoreCase(realFile.getExtension())) {
            result.add((VirtualFile)realFile);
        }
    }

    public static String[] getAirExtensionIDs(ModuleRootModel moduleRootModel, Dependencies dependencies) {
        Collection<VirtualFile> aneFiles = FlexCompilationUtils.getANEFiles(moduleRootModel, dependencies);
        ArrayList extensionIDs = new ArrayList();
        for (VirtualFile aneFile : aneFiles) {
            String extensionId = FlexCompilationUtils.getExtensionId(aneFile);
            ContainerUtil.addIfNotNull(extensionIDs, (Object)extensionId);
        }
        return extensionIDs.toArray(ArrayUtil.EMPTY_STRING_ARRAY);
    }

    @Nullable
    private static String getExtensionId(VirtualFile aneFile) {
        VirtualFile jarRoot = JarFileSystem.getInstance().getJarRootForLocalFile(aneFile);
        if (jarRoot == null) {
            return null;
        }
        VirtualFile xmlFile = VfsUtilCore.findRelativeFile((String)"META-INF/ANE/extension.xml", (VirtualFile)jarRoot);
        if (xmlFile == null) {
            return null;
        }
        try {
            return FlexUtils.findXMLElement(xmlFile.getInputStream(), "<extension><id>");
        }
        catch (IOException e) {
            return null;
        }
    }

    public static void unzipANEFiles(Collection<? extends VirtualFile> aneFiles, ProgressIndicator indicator) {
        File baseDir = new File(FlexCompilationUtils.getPathToUnzipANE());
        if (!baseDir.exists() && !baseDir.mkdir()) {
            Logger.getLogger(FlexCompilationUtils.class.getName()).warning("Failed to create " + baseDir.getPath());
            return;
        }
        for (VirtualFile virtualFile : aneFiles) {
            if (indicator != null && indicator.isCanceled()) {
                return;
            }
            File subDir = new File(baseDir, virtualFile.getName());
            if (!subDir.exists() && !subDir.mkdir()) {
                Logger.getLogger(FlexCompilationUtils.class.getName()).warning("Failed to create " + baseDir.getPath());
                continue;
            }
            try {
                ZipUtil.extract((File)new File(virtualFile.getPath()), (File)subDir, null, (boolean)true);
            }
            catch (IOException e) {
                Logger.getLogger(FlexCompilationUtils.class.getName()).warning("Failed to unzip " + virtualFile.getPath() + " to " + baseDir.getPath());
            }
        }
    }

    public static void deleteUnzippedANEFiles() {
        FileUtil.delete((File)new File(FlexCompilationUtils.getPathToUnzipANE()));
    }

    public static String getPathToUnzipANE() {
        return FileUtil.getTempDirectory() + File.separator + "IntelliJ_ANE_unzipped";
    }

    static VirtualFile refreshAndFindFileInWriteAction(final String outputFilePath, final String ... possibleBaseDirs) {
        final LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
        Ref outputFileRef = new Ref();
        Application app = ApplicationManager.getApplication();
        app.invokeAndWait(() -> outputFileRef.set(app.runWriteAction((Computable)new NullableComputable<VirtualFile>(){

            public VirtualFile compute() {
                VirtualFile outputFile = localFileSystem.refreshAndFindFileByPath(outputFilePath);
                if (outputFile == null) {
                    String baseDir;
                    String[] stringArray = possibleBaseDirs;
                    int n = stringArray.length;
                    for (int i = 0; i < n && (outputFile = localFileSystem.refreshAndFindFileByPath((baseDir = stringArray[i]) + "/" + outputFilePath)) == null; ++i) {
                    }
                }
                if (outputFile == null) {
                    return null;
                }
                outputFile.refresh(false, false);
                return outputFile;
            }
        })));
        return (VirtualFile)outputFileRef.get();
    }

    @Nullable
    public static VirtualFile getRealFile(VirtualFile libFile) {
        if (libFile.getFileSystem() instanceof JarFileSystem) {
            return JarFileSystem.getInstance().getVirtualFileForJar(libFile);
        }
        return libFile;
    }
}

