/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.debug;

import com.intellij.lang.javascript.flex.debug.CommandOutputProcessingMode;
import com.intellij.lang.javascript.flex.debug.CommandOutputProcessingType;
import com.intellij.lang.javascript.flex.debug.DebuggerCommand;
import com.intellij.lang.javascript.flex.debug.FlexDebugProcess;
import com.intellij.lang.javascript.flex.debug.VMState;
import com.intellij.xdebugger.Obsolescent;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

class CompositeDebuggerCommand
extends DebuggerCommand {
    private final DebuggerCommand[] myCommands;
    private int myCurrentIndex;
    private FlexDebugProcess myFlexDebugProcess;
    private final Obsolescent myObsolescent;
    private volatile boolean myBecomeObsolete;
    private volatile boolean mySucceeded;

    CompositeDebuggerCommand(DebuggerCommand ... commands) {
        if (commands == null) {
            CompositeDebuggerCommand.$$$reportNull$$$0(0);
        }
        this((Obsolescent)null, commands);
    }

    CompositeDebuggerCommand(@Nullable Obsolescent obsolescent, DebuggerCommand ... commands) {
        if (commands == null) {
            CompositeDebuggerCommand.$$$reportNull$$$0(1);
        }
        super("hz");
        this.myCommands = commands;
        assert (commands.length > 0);
        this.myObsolescent = obsolescent;
    }

    @Override
    public void post(FlexDebugProcess flexDebugProcess) throws IOException {
        this.myFlexDebugProcess = flexDebugProcess;
        if (this.myObsolescent != null && this.myObsolescent.isObsolete() && !this.myBecomeObsolete) {
            this.dispatchObsolete();
            return;
        }
        this.myCommands[this.myCurrentIndex].post(flexDebugProcess);
    }

    private void dispatchObsolete() {
        if (!this.myBecomeObsolete) {
            this.obsolete();
        }
    }

    protected void obsolete() {
        this.myBecomeObsolete = true;
    }

    @Override
    public CommandOutputProcessingType getOutputProcessingMode() {
        return this.myCommands[this.myCurrentIndex].getOutputProcessingMode();
    }

    @Override
    public VMState getStartVMState() {
        return this.myCommands[this.myCurrentIndex].getStartVMState();
    }

    @Override
    public VMState getEndVMState() {
        return this.myCommands[this.myCurrentIndex].getEndVMState();
    }

    @Override
    CommandOutputProcessingMode onTextAvailable(@NonNls String s) {
        if (this.myBecomeObsolete) {
            return CommandOutputProcessingMode.DONE;
        }
        CommandOutputProcessingMode b = this.myCommands[this.myCurrentIndex].onTextAvailable(s);
        if (b == CommandOutputProcessingMode.DONE) {
            if (this.myObsolescent != null && this.myObsolescent.isObsolete()) {
                this.dispatchObsolete();
                return CommandOutputProcessingMode.DONE;
            }
            ++this.myCurrentIndex;
            if (this.myCurrentIndex != this.myCommands.length) {
                this.myFlexDebugProcess.insertCommand(this);
            } else {
                this.succeeded();
            }
        }
        return b;
    }

    protected void succeeded() {
        this.mySucceeded = true;
    }

    @Override
    public String read(FlexDebugProcess flexDebugProcess) throws IOException {
        if (this.myBecomeObsolete) {
            return "*obsolete*";
        }
        return this.myCommands[this.myCurrentIndex].read(flexDebugProcess);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commands", "com/intellij/lang/javascript/flex/debug/CompositeDebuggerCommand", "<init>"));
    }
}

