/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.debug;

import com.intellij.lang.javascript.flex.debug.CommandOutputProcessingMode;
import com.intellij.lang.javascript.flex.debug.CommandOutputProcessingType;
import com.intellij.lang.javascript.flex.debug.DebuggerCommand;
import com.intellij.lang.javascript.flex.debug.FlexDebugProcess;
import com.intellij.lang.javascript.flex.debug.FlexStackFrame;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XSuspendContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class FlexSuspendContext
extends XSuspendContext {
    private final FlexExecutionStack myFlexExecutionStack;
    private static final Pattern STACK_FRAMES_DELIMITER = Pattern.compile(".(\\r?\\n)#\\d+ ");
    private static final String AT_MARKER = "at ";

    public FlexSuspendContext(FlexStackFrame topFrame) {
        this.myFlexExecutionStack = new FlexExecutionStack(topFrame);
    }

    public FlexSuspendContext(FlexDebugProcess flexDebugProcess, String[] frames) {
        this.myFlexExecutionStack = new FlexExecutionStack(FlexSuspendContext.createStackFrame(flexDebugProcess, frames[0]));
        this.myFlexExecutionStack.myAprioriKnownFrames = this.myFlexExecutionStack.getFrames(frames);
    }

    public XExecutionStack getActiveExecutionStack() {
        return this.myFlexExecutionStack;
    }

    private static FlexStackFrame createStackFrame(FlexDebugProcess flexDebugProcess, String frameText) {
        VirtualFile file = null;
        Trinity<String, String, Integer> fileNameAndIndexAndLine = FlexSuspendContext.getFileNameAndIdAndLine(frameText);
        String fileName = (String)fileNameAndIndexAndLine.first;
        String fileId = (String)fileNameAndIndexAndLine.second;
        int line = (Integer)fileNameAndIndexAndLine.third;
        if (StringUtil.isEmpty((String)fileName) || (file = flexDebugProcess.findFileByNameOrId(fileName, FlexSuspendContext.getPackageFromFrameText(frameText), fileId)) == null) {
            // empty if block
        }
        VirtualFile finalFile = file;
        XSourcePosition sourcePosition = file == null ? null : (XSourcePosition)ReadAction.compute(() -> XDebuggerUtil.getInstance().createPosition(finalFile, line > 0 ? line - 1 : line));
        return sourcePosition != null ? new FlexStackFrame(flexDebugProcess, sourcePosition) : new FlexStackFrame(flexDebugProcess, fileName, line);
    }

    private static String getPackageFromFrameText(String frameText) {
        int startIndex;
        String packageName = null;
        for (startIndex = frameText.indexOf(32); startIndex != -1 && frameText.length() > startIndex && frameText.charAt(startIndex) == ' '; ++startIndex) {
        }
        if (startIndex > 0 && frameText.substring(startIndex).startsWith("this = [")) {
            int classMarkerIndex = frameText.indexOf(", class='", startIndex);
            int packageEndIndex = frameText.indexOf("::", classMarkerIndex + ", class='".length());
            int classEndIndex = frameText.indexOf("']", classMarkerIndex + ", class='".length());
            packageName = classMarkerIndex > 0 && packageEndIndex > classMarkerIndex && packageEndIndex < classEndIndex ? frameText.substring(classMarkerIndex + ", class='".length(), packageEndIndex) : "";
        }
        return packageName;
    }

    static String[] splitStackFrames(String s) {
        Matcher m = STACK_FRAMES_DELIMITER.matcher(s);
        ArrayList<String> result = new ArrayList<String>();
        int prev = 0;
        while (m.find()) {
            result.add(s.substring(prev, m.start(1)));
            prev = m.end(1);
        }
        result.add(s.substring(prev));
        return ArrayUtil.toStringArray(result);
    }

    static String extractScope(String stackFrame) {
        int lparIndex;
        int dotIndex;
        int startIndex = stackFrame.indexOf(93);
        if (startIndex == -1) {
            for (startIndex = stackFrame.indexOf(32); startIndex != -1 && stackFrame.length() > startIndex + 1 && stackFrame.charAt(startIndex + 1) == ' '; ++startIndex) {
            }
        }
        String clsMethodText = stackFrame.substring(dotIndex + 1, (lparIndex = stackFrame.indexOf(40, dotIndex = Math.max(startIndex, stackFrame.indexOf(46, startIndex + 1)))) != -1 ? lparIndex : stackFrame.length());
        int methodStart = clsMethodText.indexOf(47);
        return methodStart == -1 ? clsMethodText : clsMethodText.substring(methodStart + 1) + ": " + clsMethodText.substring(0, methodStart);
    }

    private static Trinity<String, String, Integer> getFileNameAndIdAndLine(String text) {
        String fileName;
        int atPos = text.lastIndexOf(AT_MARKER);
        if (atPos == -1) {
            return Trinity.create(null, null, (Object)0);
        }
        String fileId = null;
        int line = 0;
        int eolIndex = Math.min(text.indexOf("\r", atPos), text.indexOf("\n", atPos));
        String fileNameAndFurther = text.substring(atPos + AT_MARKER.length(), eolIndex > atPos ? eolIndex : text.length());
        int hashIndex = fileNameAndFurther.indexOf(35);
        int colonIndex = fileNameAndFurther.indexOf(58, hashIndex);
        if (hashIndex != -1) {
            fileName = fileNameAndFurther.substring(0, hashIndex);
            if (colonIndex > hashIndex) {
                fileId = fileNameAndFurther.substring(hashIndex + 1, colonIndex);
                try {
                    line = Integer.parseInt(fileNameAndFurther.substring(colonIndex + 1));
                }
                catch (NumberFormatException numberFormatException) {}
            }
        } else if (colonIndex != -1) {
            fileName = fileNameAndFurther.substring(0, colonIndex);
            try {
                line = Integer.parseInt(fileNameAndFurther.substring(colonIndex + 1));
            }
            catch (NumberFormatException numberFormatException) {}
        } else {
            fileName = fileNameAndFurther;
        }
        return Trinity.create((Object)fileName, fileId, (Object)line);
    }

    private static class FlexExecutionStack
    extends XExecutionStack {
        private final FlexStackFrame myTopFrame;
        @Nullable
        private List<XStackFrame> myAprioriKnownFrames;

        private FlexExecutionStack(FlexStackFrame topFrame) {
            super("");
            this.myTopFrame = topFrame;
        }

        public XStackFrame getTopFrame() {
            return this.myTopFrame;
        }

        public void computeStackFrames(final int frameIndex, final XExecutionStack.XStackFrameContainer container) {
            if (this.myAprioriKnownFrames != null) {
                container.addStackFrames(this.myAprioriKnownFrames.subList(frameIndex, this.myAprioriKnownFrames.size()), true);
            } else {
                this.myTopFrame.getDebugProcess().sendCommand(new DebuggerCommand("bt", CommandOutputProcessingType.SPECIAL_PROCESSING){

                    @Override
                    CommandOutputProcessingMode onTextAvailable(@NonNls String s) {
                        if (container.isObsolete()) {
                            return CommandOutputProcessingMode.DONE;
                        }
                        List frames = this.getFrames(FlexSuspendContext.splitStackFrames(s));
                        container.addStackFrames(frames.subList(frameIndex, frames.size()), true);
                        return CommandOutputProcessingMode.DONE;
                    }
                });
            }
        }

        private List<XStackFrame> getFrames(String[] frames) {
            XStackFrame[] allFrames = new XStackFrame[frames.length];
            int i = 0;
            FlexDebugProcess flexDebugProcess = this.myTopFrame.getDebugProcess();
            if (frames.length == 0) {
                return Collections.emptyList();
            }
            String frameText = frames[i];
            this.myTopFrame.setScope(FlexSuspendContext.extractScope(frameText));
            this.myTopFrame.setFrameIndex(0);
            allFrames[i++] = this.myTopFrame;
            while (i < frames.length) {
                frameText = frames[i];
                FlexStackFrame flexStackFrame = FlexSuspendContext.createStackFrame(flexDebugProcess, frameText);
                allFrames[i] = flexStackFrame;
                flexStackFrame.setScope(FlexSuspendContext.extractScope(frameText));
                flexStackFrame.setFrameIndex(i);
                ++i;
            }
            return Arrays.asList(allFrames);
        }
    }
}

