/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.flashbuilder;

import com.intellij.flex.model.bc.OutputType;
import com.intellij.flex.model.bc.TargetPlatform;
import com.intellij.lang.javascript.flex.FlexBundle;
import com.intellij.openapi.util.Pair;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class FlashBuilderProject {
    private String myName = FlexBundle.message("unnamed", new Object[0]);
    private final Map<String, String> myLinkedResources = new THashMap();
    private final Set<String> myUsedPathVariables = new THashSet();
    private String myProjectRootPath = "";
    private final Collection<String> mySourcePaths = new ArrayList<String>();
    private String myOutputFolderPath = "";
    private boolean mySdkUsed;
    private String mySdkName = "";
    private TargetPlatform myTargetPlatform = TargetPlatform.Web;
    private boolean myPureActionScript = false;
    private boolean myAirSdk = false;
    private OutputType myOutputType = OutputType.Application;
    private boolean myAndroidSupported = false;
    private boolean myIosSupported = false;
    private String myDesktopCertPath;
    private String myAndroidCertPath;
    private String myIOSCertPath;
    private String myIOSProvisioningPath;
    private String myMainAppClassName = "";
    private final Collection<String> myApplicationClassNames = new ArrayList<String>();
    private String myTargetPlayerVersion;
    private String myAdditionalCompilerOptions = "";
    private boolean myUseHtmlWrapper = false;
    private final Map<String, Collection<String>> myLibraryPathsAndSources = new LinkedHashMap<String, Collection<String>>();
    private final Collection<Pair<String, String>> myNamespacesAndManifestPaths = new ArrayList<Pair<String, String>>(1);
    private final Collection<String> myFilesIncludedInSwc = new ArrayList<String>();
    private final Collection<FBRLMInfo> myModules = new ArrayList<FBRLMInfo>();
    private final Collection<String> myCssFilesToCompile = new ArrayList<String>();
    private final Collection<String> myPathsExcludedFromDesktopPackaging = new ArrayList<String>();
    private final Collection<String> myPathsExcludedFromAndroidPackaging = new ArrayList<String>();
    private final Collection<String> myPathsExcludedFromIOSPackaging = new ArrayList<String>();
    private String myThemeDirPathRaw;

    FlashBuilderProject() {
    }

    public String getName() {
        return this.myName;
    }

    public void setName(String name) {
        this.myName = name;
    }

    public void addLinkedResource(String linkName, String linkLocation) {
        this.myLinkedResources.put(linkName, linkLocation);
    }

    public Map<String, String> getLinkedResources() {
        return this.myLinkedResources;
    }

    public String getProjectRootPath() {
        return this.myProjectRootPath;
    }

    public void setProjectRootPath(String projectRootPath) {
        this.myProjectRootPath = projectRootPath;
    }

    public Collection<String> getSourcePaths() {
        return this.mySourcePaths;
    }

    public void addSourcePath(String sourcePath) {
        this.checkIfPathMacroUsed(sourcePath);
        this.mySourcePaths.add(sourcePath);
    }

    public String getOutputFolderPath() {
        return this.myOutputFolderPath;
    }

    public void setOutputFolderPath(String outputFolderPath) {
        this.checkIfPathMacroUsed(outputFolderPath);
        this.myOutputFolderPath = outputFolderPath;
    }

    public boolean isSdkUsed() {
        return this.mySdkUsed;
    }

    public void setSdkUsed(boolean sdkUsed) {
        this.mySdkUsed = sdkUsed;
    }

    public String getSdkName() {
        return this.mySdkName;
    }

    public void setSdkName(String sdkName) {
        this.mySdkName = sdkName;
    }

    public TargetPlatform getTargetPlatform() {
        return this.myTargetPlatform;
    }

    public void setTargetPlatform(TargetPlatform targetPlatform) {
        this.myTargetPlatform = targetPlatform;
    }

    public boolean isPureActionScript() {
        return this.myPureActionScript;
    }

    public void setPureActionScript(boolean pureActionScript) {
        this.myPureActionScript = pureActionScript;
    }

    public boolean isAirSdk() {
        return this.myAirSdk;
    }

    public void setAirSdk(boolean airSdk) {
        this.myAirSdk = airSdk;
    }

    public OutputType getOutputType() {
        return this.myOutputType;
    }

    public void setOutputType(OutputType outputType) {
        this.myOutputType = outputType;
    }

    public boolean isAndroidSupported() {
        return this.myAndroidSupported;
    }

    public void setAndroidSupported(boolean androidSupported) {
        this.myAndroidSupported = androidSupported;
    }

    public boolean isIosSupported() {
        return this.myIosSupported;
    }

    public void setIosSupported(boolean iosSupported) {
        this.myIosSupported = iosSupported;
    }

    public String getDesktopCertPath() {
        return this.myDesktopCertPath;
    }

    public void setDesktopCertPath(String desktopCertPath) {
        this.myDesktopCertPath = desktopCertPath;
    }

    public String getAndroidCertPath() {
        return this.myAndroidCertPath;
    }

    public void setAndroidCertPath(String androidCertPath) {
        this.myAndroidCertPath = androidCertPath;
    }

    public String getIOSCertPath() {
        return this.myIOSCertPath;
    }

    public void setIOSCertPath(String iOSCertPath) {
        this.myIOSCertPath = iOSCertPath;
    }

    public String getIOSProvisioningPath() {
        return this.myIOSProvisioningPath;
    }

    public void setIOSProvisioningPath(String IOSProvisioningPath) {
        this.myIOSProvisioningPath = IOSProvisioningPath;
    }

    public String getMainAppClassName() {
        return this.myMainAppClassName;
    }

    public void addApplicationClassName(String className) {
        if (!className.equals(this.myMainAppClassName)) {
            this.myApplicationClassNames.add(className);
        }
    }

    public Collection<String> getApplicationClassNames() {
        return this.myApplicationClassNames;
    }

    public void setMainAppClassName(String mainClassName) {
        this.myMainAppClassName = mainClassName;
    }

    public String getTargetPlayerVersion() {
        return this.myTargetPlayerVersion;
    }

    public void setTargetPlayerVersion(String targetPlayerVersion) {
        this.myTargetPlayerVersion = targetPlayerVersion;
    }

    public String getAdditionalCompilerOptions() {
        return this.myAdditionalCompilerOptions;
    }

    public void setAdditionalCompilerOptions(String additionalCompilerOptions) {
        this.myAdditionalCompilerOptions = additionalCompilerOptions;
    }

    public boolean isUseHtmlWrapper() {
        return this.myUseHtmlWrapper;
    }

    public void setUseHtmlWrapper(boolean useHtmlWrapper) {
        this.myUseHtmlWrapper = useHtmlWrapper;
    }

    public Collection<String> getLibraryPaths() {
        return this.myLibraryPathsAndSources.keySet();
    }

    public Collection<String> getLibrarySourcePaths(String libraryPath) {
        return this.myLibraryPathsAndSources.get(libraryPath);
    }

    public void addLibraryPathAndSources(String libraryPath, Collection<String> sourcePathsForLibrary) {
        this.checkIfPathMacroUsed(libraryPath);
        for (String path : sourcePathsForLibrary) {
            this.checkIfPathMacroUsed(path);
        }
        this.myLibraryPathsAndSources.put(libraryPath, sourcePathsForLibrary);
    }

    public Set<String> getUsedPathVariables() {
        return this.myUsedPathVariables;
    }

    public void addNamespaceAndManifestPath(String namespace, String manifestPath) {
        this.checkIfPathMacroUsed(manifestPath);
        this.myNamespacesAndManifestPaths.add((Pair<String, String>)Pair.create((Object)namespace, (Object)manifestPath));
    }

    public Collection<Pair<String, String>> getNamespacesAndManifestPaths() {
        return this.myNamespacesAndManifestPaths;
    }

    public void addFileIncludedInSwc(String path) {
        this.myFilesIncludedInSwc.add(path);
    }

    public Collection<String> getFilesIncludedInSwc() {
        return this.myFilesIncludedInSwc;
    }

    public void addModule(FBRLMInfo rlmInfo) {
        this.checkIfPathMacroUsed(rlmInfo.MAIN_CLASS_PATH);
        this.checkIfPathMacroUsed(rlmInfo.OUTPUT_PATH);
        this.checkIfPathMacroUsed(rlmInfo.OPTIMIZE_FOR);
        this.myModules.add(rlmInfo);
    }

    public Collection<FBRLMInfo> getModules() {
        return this.myModules;
    }

    public void addCssFileToCompile(String cssFilePath) {
        this.checkIfPathMacroUsed(cssFilePath);
        this.myCssFilesToCompile.add(cssFilePath);
    }

    public Collection<String> getCssFilesToCompile() {
        return this.myCssFilesToCompile;
    }

    public void addPathExcludedFromDesktopPackaging(String path) {
        this.myPathsExcludedFromDesktopPackaging.add(path);
    }

    public Collection<String> getPathsExcludedFromDesktopPackaging() {
        return this.myPathsExcludedFromDesktopPackaging;
    }

    public void addPathExcludedFromAndroidPackaging(String path) {
        this.myPathsExcludedFromAndroidPackaging.add(path);
    }

    public Collection<String> getPathsExcludedFromAndroidPackaging() {
        return this.myPathsExcludedFromAndroidPackaging;
    }

    public void addPathExcludedFromIOSPackaging(String path) {
        this.myPathsExcludedFromIOSPackaging.add(path);
    }

    public Collection<String> getPathsExcludedFromIOSPackaging() {
        return this.myPathsExcludedFromIOSPackaging;
    }

    public void setThemeDirPathRaw(String themeDirPathRaw) {
        this.myThemeDirPathRaw = themeDirPathRaw;
    }

    public String getThemeDirPathRaw() {
        return this.myThemeDirPathRaw;
    }

    private void checkIfPathMacroUsed(String path) {
        String potentialLink;
        int slashIndex = path.indexOf(47);
        String string = potentialLink = slashIndex >= 0 ? path.substring(0, slashIndex) : path;
        if (potentialLink.startsWith("${") && potentialLink.endsWith("}")) {
            this.myUsedPathVariables.add(potentialLink.substring(2, potentialLink.length() - 1));
        }
    }

    public static class FBRLMInfo {
        public final String MAIN_CLASS_PATH;
        public final String OUTPUT_PATH;
        public final boolean OPTIMIZE;
        public final String OPTIMIZE_FOR;

        public FBRLMInfo(String mainClassPath, String outputPath, boolean optimize, String optimizeFor) {
            this.MAIN_CLASS_PATH = mainClassPath;
            this.OUTPUT_PATH = outputPath;
            this.OPTIMIZE = optimize;
            this.OPTIMIZE_FOR = optimizeFor;
        }
    }
}

