/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.flexunit;

import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.flex.FlexCommonBundle;
import com.intellij.flex.model.bc.LinkageType;
import com.intellij.flex.model.bc.OutputType;
import com.intellij.javascript.flex.resolve.ActionScriptClassResolver;
import com.intellij.lang.javascript.flex.FlexBundle;
import com.intellij.lang.javascript.flex.FlexUtils;
import com.intellij.lang.javascript.flex.flexunit.FlexUnitSupport;
import com.intellij.lang.javascript.flex.projectStructure.model.FlexBuildConfiguration;
import com.intellij.lang.javascript.flex.projectStructure.model.ModifiableDependencyEntry;
import com.intellij.lang.javascript.flex.projectStructure.model.ModifiableFlexBuildConfiguration;
import com.intellij.lang.javascript.flex.projectStructure.model.impl.Factory;
import com.intellij.lang.javascript.flex.run.BCBasedRunnerParameters;
import com.intellij.lang.javascript.flex.run.FlashRunnerParameters;
import com.intellij.lang.javascript.flex.run.LauncherParameters;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Transient;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlexUnitRunnerParameters
extends BCBasedRunnerParameters {
    @NotNull
    private Scope myScope = Scope.Class;
    @NotNull
    private String myPackageName = "";
    @NotNull
    private String myClassName = "";
    @NotNull
    private String myMethodName = "";
    @Nullable
    private OutputLogLevel myOutputLogLevel = null;
    @NotNull
    private LauncherParameters myLauncherParameters = new LauncherParameters();
    private boolean myTrusted = true;
    private String myEmulatorAdlOptions = "";
    @NotNull
    private FlashRunnerParameters.AppDescriptorForEmulator myAppDescriptorForEmulator = FlashRunnerParameters.AppDescriptorForEmulator.Android;
    private int myPort;
    private int mySocketPolicyPort;

    @Attribute(value="scope")
    @NotNull
    public Scope getScope() {
        Scope scope = this.myScope;
        if (scope == null) {
            FlexUnitRunnerParameters.$$$reportNull$$$0(0);
        }
        return scope;
    }

    public void setScope(@NotNull Scope scope) {
        if (scope == null) {
            FlexUnitRunnerParameters.$$$reportNull$$$0(1);
        }
        this.myScope = scope;
    }

    @Attribute(value="package_name")
    @NotNull
    public String getPackageName() {
        String string = this.myPackageName;
        if (string == null) {
            FlexUnitRunnerParameters.$$$reportNull$$$0(2);
        }
        return string;
    }

    public void setPackageName(@NotNull String packageName) {
        if (packageName == null) {
            FlexUnitRunnerParameters.$$$reportNull$$$0(3);
        }
        this.myPackageName = packageName;
    }

    @Attribute(value="class_name")
    @NotNull
    public String getClassName() {
        String string = this.myClassName;
        if (string == null) {
            FlexUnitRunnerParameters.$$$reportNull$$$0(4);
        }
        return string;
    }

    public void setClassName(@NotNull String className) {
        if (className == null) {
            FlexUnitRunnerParameters.$$$reportNull$$$0(5);
        }
        this.myClassName = className;
    }

    @Attribute(value="method_name")
    @NotNull
    public String getMethodName() {
        String string = this.myMethodName;
        if (string == null) {
            FlexUnitRunnerParameters.$$$reportNull$$$0(6);
        }
        return string;
    }

    public void setMethodName(@NotNull String methodName) {
        if (methodName == null) {
            FlexUnitRunnerParameters.$$$reportNull$$$0(7);
        }
        this.myMethodName = methodName;
    }

    @Transient
    public int getPort() {
        return this.myPort;
    }

    public void setPort(int port) {
        this.myPort = port;
    }

    @Transient
    public int getSocketPolicyPort() {
        return this.mySocketPolicyPort;
    }

    public void setSocketPolicyPort(int port) {
        this.mySocketPolicyPort = port;
    }

    @Attribute(value="output_log_level")
    @Nullable
    public OutputLogLevel getOutputLogLevel() {
        return this.myOutputLogLevel;
    }

    public void setOutputLogLevel(@Nullable OutputLogLevel outputLogLevel) {
        this.myOutputLogLevel = outputLogLevel;
    }

    @NotNull
    public LauncherParameters getLauncherParameters() {
        LauncherParameters launcherParameters = this.myLauncherParameters;
        if (launcherParameters == null) {
            FlexUnitRunnerParameters.$$$reportNull$$$0(8);
        }
        return launcherParameters;
    }

    public void setLauncherParameters(@NotNull LauncherParameters launcherParameters) {
        if (launcherParameters == null) {
            FlexUnitRunnerParameters.$$$reportNull$$$0(9);
        }
        this.myLauncherParameters = launcherParameters;
    }

    public boolean isTrusted() {
        return this.myTrusted;
    }

    public void setTrusted(boolean trusted) {
        this.myTrusted = trusted;
    }

    @Attribute(value="emulatorAdlOptions")
    @NotNull
    public String getEmulatorAdlOptions() {
        String string = this.myEmulatorAdlOptions;
        if (string == null) {
            FlexUnitRunnerParameters.$$$reportNull$$$0(10);
        }
        return string;
    }

    public void setEmulatorAdlOptions(String emulatorAdlOptions) {
        this.myEmulatorAdlOptions = emulatorAdlOptions;
    }

    @Attribute(value="appDescriptorForEmulator")
    @NotNull
    public FlashRunnerParameters.AppDescriptorForEmulator getAppDescriptorForEmulator() {
        FlashRunnerParameters.AppDescriptorForEmulator appDescriptorForEmulator = this.myAppDescriptorForEmulator;
        if (appDescriptorForEmulator == null) {
            FlexUnitRunnerParameters.$$$reportNull$$$0(11);
        }
        return appDescriptorForEmulator;
    }

    public void setAppDescriptorForEmulator(@NotNull FlashRunnerParameters.AppDescriptorForEmulator appDescriptorForEmulator) {
        if (appDescriptorForEmulator == null) {
            FlexUnitRunnerParameters.$$$reportNull$$$0(12);
        }
        this.myAppDescriptorForEmulator = appDescriptorForEmulator;
    }

    public void check(Project project) throws RuntimeConfigurationError {
        this.doCheck(project, super.checkAndGetModuleAndBC(project));
    }

    @Override
    public Pair<Module, FlexBuildConfiguration> checkAndGetModuleAndBC(Project project) throws RuntimeConfigurationError {
        Pair<Module, FlexBuildConfiguration> moduleAndBC = super.checkAndGetModuleAndBC(project);
        this.doCheck(project, moduleAndBC);
        ModifiableFlexBuildConfiguration overriddenBC = Factory.getTemporaryCopyForCompilation((FlexBuildConfiguration)moduleAndBC.second);
        overriddenBC.setOutputType(OutputType.Application);
        overriddenBC.setMainClass("____FlexUnitLauncher");
        overriddenBC.setOutputFileName("_flexunit.swf");
        overriddenBC.setOutputFolder(VfsUtilCore.urlToPath((String)CompilerModuleExtension.getInstance((Module)((Module)moduleAndBC.first)).getCompilerOutputUrlForTests()));
        overriddenBC.setUseHtmlWrapper(false);
        overriddenBC.setRLMs(Collections.emptyList());
        overriddenBC.setCssFilesToCompile(Collections.emptyList());
        overriddenBC.setSkipCompile(false);
        overriddenBC.getDependencies().setFrameworkLinkage(LinkageType.Merged);
        for (ModifiableDependencyEntry entry : overriddenBC.getDependencies().getModifiableEntries()) {
            if (entry.getDependencyType().getLinkageType() != LinkageType.External) continue;
            entry.getDependencyType().setLinkageType(LinkageType.Merged);
        }
        return Pair.create((Object)moduleAndBC.first, (Object)overriddenBC);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void doCheck(Project project, Pair<Module, FlexBuildConfiguration> moduleAndBC) throws RuntimeConfigurationError {
        if (DumbService.getInstance((Project)project).isDumb()) {
            return;
        }
        FlexBuildConfiguration bc = (FlexBuildConfiguration)moduleAndBC.second;
        Sdk sdk = bc.getSdk();
        if (sdk == null) {
            throw new RuntimeConfigurationError(FlexCommonBundle.message((String)"sdk.not.set.for.bc.0.of.module.1", (Object[])new Object[]{bc.getName(), ((Module)moduleAndBC.first).getName()}));
        }
        switch (bc.getTargetPlatform()) {
            case Web: {
                break;
            }
            case Desktop: {
                FlashRunnerParameters.checkAdlAndAirRuntime(sdk);
                if (bc.getOutputType() != OutputType.Application) break;
                FlashRunnerParameters.checkCustomDescriptor(bc.getAirDesktopPackagingOptions(), this.getBCName(), this.getModuleName());
                break;
            }
            case Mobile: {
                FlashRunnerParameters.checkAdlAndAirRuntime(sdk);
                switch (this.myAppDescriptorForEmulator) {
                    case Android: {
                        if (bc.getOutputType() != OutputType.Application) break;
                        FlashRunnerParameters.checkCustomDescriptor(bc.getAndroidPackagingOptions(), this.getBCName(), this.getModuleName());
                        break;
                    }
                    case IOS: {
                        if (bc.getOutputType() != OutputType.Application) break;
                        FlashRunnerParameters.checkCustomDescriptor(bc.getIosPackagingOptions(), this.getBCName(), this.getModuleName());
                    }
                }
                break;
            }
        }
        FlexUnitSupport support = FlexUnitSupport.getSupport(bc, (Module)moduleAndBC.first);
        if (support == null) {
            throw new RuntimeConfigurationError(FlexBundle.message("flexunit.not.found.for.bc", bc.getName()));
        }
        if (!support.flexUnit4Present && bc.isPureAs()) {
            throw new RuntimeConfigurationError(FlexBundle.message("cant.execute.flexunit1.for.pure.as.bc", new Object[0]));
        }
        GlobalSearchScope searchScope = FlexUtils.getModuleWithDependenciesAndLibrariesScope((Module)moduleAndBC.first, bc, true);
        switch (this.getScope()) {
            case Class: {
                FlexUnitRunnerParameters.getClassToTest(this.getClassName(), searchScope, support, true);
                return;
            }
            case Method: {
                JSClass classToTest = FlexUnitRunnerParameters.getClassToTest(this.getClassName(), searchScope, support, false);
                if (StringUtil.isEmpty((String)this.getMethodName())) {
                    throw new RuntimeConfigurationError(FlexBundle.message("no.test.method.specified", new Object[0]));
                }
                JSFunction methodToTest = classToTest.findFunctionByNameAndKind(this.getMethodName(), JSFunction.FunctionKind.SIMPLE);
                if (methodToTest != null) {
                    if (support.isTestMethod(methodToTest)) return;
                }
                throw new RuntimeConfigurationError(FlexBundle.message("method.not.valid", this.getMethodName()));
            }
            case Package: {
                if (JSUtils.packageExists((String)this.getPackageName(), (GlobalSearchScope)searchScope)) return;
                throw new RuntimeConfigurationError(FlexBundle.message("package.not.valid", this.getPackageName()));
            }
        }
        assert (false) : "Unknown scope: " + (Object)((Object)this.getScope());
        return;
    }

    private static JSClass getClassToTest(String className, GlobalSearchScope searchScope, @NotNull FlexUnitSupport flexUnitSupport, boolean allowSuite) throws RuntimeConfigurationError {
        if (flexUnitSupport == null) {
            FlexUnitRunnerParameters.$$$reportNull$$$0(13);
        }
        if (StringUtil.isEmpty((String)className)) {
            throw new RuntimeConfigurationError(FlexBundle.message("test.class.not.specified", new Object[0]));
        }
        PsiElement classToTest = ActionScriptClassResolver.findClassByQNameStatic(className, searchScope);
        if (!(classToTest instanceof JSClass)) {
            throw new RuntimeConfigurationError(FlexBundle.message("class.not.found", className));
        }
        if (!flexUnitSupport.isTestClass((JSClass)classToTest, allowSuite)) {
            throw new RuntimeConfigurationError(FlexBundle.message("class.contains.no.tests", className));
        }
        return (JSClass)classToTest;
    }

    @Override
    public FlexUnitRunnerParameters clone() {
        FlexUnitRunnerParameters clone = (FlexUnitRunnerParameters)super.clone();
        clone.myLauncherParameters = this.myLauncherParameters.clone();
        return clone;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FlexUnitRunnerParameters that = (FlexUnitRunnerParameters)o;
        if (this.myTrusted != that.myTrusted) {
            return false;
        }
        if (!this.myClassName.equals(that.myClassName)) {
            return false;
        }
        if (!this.myLauncherParameters.equals(that.myLauncherParameters)) {
            return false;
        }
        if (!this.myMethodName.equals(that.myMethodName)) {
            return false;
        }
        if (this.myOutputLogLevel != that.myOutputLogLevel) {
            return false;
        }
        if (!this.myPackageName.equals(that.myPackageName)) {
            return false;
        }
        return this.myScope == that.myScope;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 12: 
            case 13: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 12: 
            case 13: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/flex/flexunit/FlexUnitRunnerParameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "launcherParameters";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appDescriptorForEmulator";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flexUnitSupport";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getScope";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/flex/flexunit/FlexUnitRunnerParameters";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getLauncherParameters";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getEmulatorAdlOptions";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getAppDescriptorForEmulator";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setScope";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setPackageName";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setClassName";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setMethodName";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setLauncherParameters";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setAppDescriptorForEmulator";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getClassToTest";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 12: 
            case 13: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum OutputLogLevel {
        Fatal("1000"),
        Error("8"),
        Warn("6"),
        Info("4"),
        Debug("2"),
        All("0");

        private final String myFlexConstant;

        private OutputLogLevel(String flexConstant) {
            this.myFlexConstant = flexConstant;
        }

        public String getFlexConstant() {
            return this.myFlexConstant;
        }
    }

    public static enum Scope {
        Method,
        Class,
        Package;

    }
}

