/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.flexunit;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.flex.flexunit.CreateFlexUnitTestDialog;
import com.intellij.lang.javascript.flex.flexunit.FlexUnitTestFinder;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.refactoring.util.JSMemberInfo;
import com.intellij.lang.javascript.validation.fixes.ActionScriptCreateClassOrInterfaceFix;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.testIntegration.TestCreator;
import com.intellij.util.Consumer;
import gnu.trove.THashSet;
import java.util.Collections;

public class FlexUnitTestCreator
implements TestCreator {
    public boolean isAvailable(Project project, Editor editor, PsiFile file) {
        VirtualFile vFile = file.getVirtualFile();
        return FlexUnitTestFinder.findContextClass((PsiElement)file) != null && vFile != null && !ProjectRootManager.getInstance((Project)project).getFileIndex().isInTestSourceContent(vFile);
    }

    public void createTest(Project project, Editor editor, PsiFile file) {
        JSMemberInfo[] selectedMemberInfos;
        boolean generateTearDown;
        boolean generateSetUp;
        PsiDirectory targetDirectory;
        JSClass superClass;
        String packageName;
        String testClassName;
        JSClass jsClass = FlexUnitTestFinder.findContextClass((PsiElement)file);
        if (jsClass == null) {
            return;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            testClassName = jsClass.getName() + "Test";
            packageName = StringUtil.getPackageName((String)jsClass.getQualifiedName());
            superClass = null;
            targetDirectory = jsClass.getContainingFile().getContainingDirectory();
            generateSetUp = true;
            generateTearDown = true;
            selectedMemberInfos = JSMemberInfo.EMPTY_ARRAY;
        } else {
            CreateFlexUnitTestDialog dialog = new CreateFlexUnitTestDialog(ModuleUtilCore.findModuleForPsiElement((PsiElement)jsClass), jsClass);
            dialog.show();
            if (dialog.getExitCode() != 0) {
                return;
            }
            testClassName = dialog.getTestClassName();
            packageName = dialog.getPackageName();
            superClass = dialog.getSuperClass();
            targetDirectory = dialog.getTargetDirectory();
            generateSetUp = dialog.isGenerateSetUp();
            generateTearDown = dialog.isGenerateTearDown();
            selectedMemberInfos = dialog.getSelectedMemberInfos();
        }
        Consumer postProcessRunnable = createdClass -> {
            PsiElement methods;
            String methodsText = FlexUnitTestCreator.getMethodsText(createdClass, generateSetUp, generateTearDown, selectedMemberInfos);
            if (!methodsText.isEmpty() && (methods = JSChangeUtil.createJSTreeFromText((Project)project, (String)("{" + methodsText + "}"), (JSLanguageDialect)JavaScriptSupportLoader.ECMA_SCRIPT_L4).getPsi()) != null) {
                for (PsiElement psiElement : PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)methods, JSFunction.class)) {
                    createdClass.add(psiElement);
                }
            }
            CodeStyleManager.getInstance((Project)project).reformat((PsiElement)createdClass);
            createdClass.navigate(true);
        };
        CommandProcessor.getInstance().executeCommand(project, () -> ActionScriptCreateClassOrInterfaceFix.createClass((String)"ActionScript Class with Supers", (String)testClassName, (String)packageName, (JSClass)superClass, Collections.emptyList(), (PsiDirectory)targetDirectory, (String)CodeInsightBundle.message((String)"intention.create.test", (Object[])new Object[0]), (boolean)true, Collections.emptyMap(), (Consumer)postProcessRunnable), CodeInsightBundle.message((String)"intention.create.test", (Object[])new Object[0]), null);
    }

    private static String getMethodsText(JSClass createdClass, boolean generateSetUp, boolean generateTearDown, JSMemberInfo[] selectedMemberInfos) {
        StringBuilder builder = new StringBuilder();
        builder.append(generateSetUp ? (JSInheritanceUtil.findMember((String)"setUp", (JSClass)createdClass, (JSInheritanceUtil.SearchedMemberType)JSInheritanceUtil.SearchedMemberType.Methods, (JSFunction.FunctionKind)JSFunction.FunctionKind.SIMPLE, (boolean)true) == null ? "[Before]\npublic function setUp():void{\n\n}" : "[Before]\npublic override function setUp():void{\nsuper.setUp();\n}") : "");
        builder.append(generateTearDown ? (JSInheritanceUtil.findMember((String)"tearDown", (JSClass)createdClass, (JSInheritanceUtil.SearchedMemberType)JSInheritanceUtil.SearchedMemberType.Methods, (JSFunction.FunctionKind)JSFunction.FunctionKind.SIMPLE, (boolean)true) == null ? "[After]\npublic function tearDown():void{\n\n}" : "[After]\npublic override function tearDown():void{\nsuper.tearDown();\n}") : "");
        THashSet processedNames = new THashSet();
        for (JSMemberInfo info : selectedMemberInfos) {
            String name = ((JSAttributeListOwner)info.getMember()).getName();
            if (processedNames.contains(name)) continue;
            processedNames.add(name);
            String testName = "test" + FlexUnitTestCreator.capitalizeFirstCharacter(name);
            builder.append("[Test]\npublic function ").append(testName).append("():void{\n\n}");
        }
        return builder.toString();
    }

    private static String capitalizeFirstCharacter(String s) {
        if (StringUtil.isEmpty((String)s)) {
            return s;
        }
        return Character.toUpperCase(s.charAt(0)) + s.substring(1);
    }
}

