/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.flexunit;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configuration.BrowseModuleValueActionListener;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.javascript.flex.resolve.ActionScriptClassResolver;
import com.intellij.lang.javascript.flex.FlexBundle;
import com.intellij.lang.javascript.flex.FlexMethodChooserDialog;
import com.intellij.lang.javascript.flex.flexunit.FlexUnitRunnerParameters;
import com.intellij.lang.javascript.flex.flexunit.FlexUnitSupport;
import com.intellij.lang.javascript.flex.projectStructure.model.FlexBuildConfiguration;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.refactoring.ui.JSReferenceEditor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WhatToTestForm {
    private JPanel myMainPanel;
    private JRadioButton myPackageRadioButton;
    private JRadioButton myClassRadioButton;
    private JRadioButton myMethodRadioButton;
    private JLabel myPackageOrClassLabel;
    private JSReferenceEditor myPackageField;
    private JSReferenceEditor myClassField;
    private JPanel myMethodPanel;
    private TextFieldWithBrowseButton.NoPathCompletion myMethodField;
    private final Project myProject;
    private final ThrowableComputable<? extends Module, ? extends RuntimeConfigurationError> myModuleComputable;
    private final ThrowableComputable<? extends FlexUnitSupport, ? extends RuntimeConfigurationError> myFlexUnitSupportComputable;
    private TestClassFilter myMainClassFilter;

    public WhatToTestForm(Project project, ThrowableComputable<? extends Module, ? extends RuntimeConfigurationError> moduleComputable, ThrowableComputable<? extends FlexUnitSupport, ? extends RuntimeConfigurationError> flexUnitSupportComputable) {
        this.myProject = project;
        this.myModuleComputable = moduleComputable;
        this.myFlexUnitSupportComputable = flexUnitSupportComputable;
        this.$$$setupUI$$$();
        ActionListener scopeChangeListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WhatToTestForm.this.updateOnScopeChange();
            }
        };
        this.myClassRadioButton.addActionListener(scopeChangeListener);
        this.myPackageRadioButton.addActionListener(scopeChangeListener);
        this.myMethodRadioButton.addActionListener(scopeChangeListener);
        new MethodChooserActionListener(project);
    }

    private void createUIComponents() {
        this.myMainClassFilter = new TestClassFilter(this.myProject);
        this.myClassField = JSReferenceEditor.forClassName((String)"", (Project)this.myProject, null, (GlobalSearchScope)GlobalSearchScope.EMPTY_SCOPE, null, (Condition)this.myMainClassFilter, (String)ExecutionBundle.message((String)"choose.test.class.dialog.title", (Object[])new Object[0]));
        this.myPackageField = JSReferenceEditor.forPackageName((String)"", (Project)this.myProject, null, (GlobalSearchScope)GlobalSearchScope.EMPTY_SCOPE, (String)ExecutionBundle.message((String)"choose.package.dialog.title", (Object[])new Object[0]));
    }

    private void updateOnScopeChange() {
        if (this.myClassRadioButton.isSelected()) {
            WhatToTestForm.setText(this.myPackageOrClassLabel, "Class:", 'C');
            this.myMethodPanel.setVisible(false);
            this.myPackageOrClassLabel.setLabelFor(this.myClassField.getChildComponent());
            this.myMainClassFilter.setAllowSuite(true);
            this.myClassField.setVisible(true);
            this.myClassField.invalidateHighlight();
            this.myPackageField.setVisible(false);
        } else if (this.myPackageRadioButton.isSelected()) {
            WhatToTestForm.setText(this.myPackageOrClassLabel, "Package:", 'g');
            this.myPackageOrClassLabel.setLabelFor(this.myPackageField.getChildComponent());
            this.myMethodPanel.setVisible(false);
            this.myClassField.setVisible(false);
            this.myPackageField.setVisible(true);
        } else if (this.myMethodRadioButton.isSelected()) {
            WhatToTestForm.setText(this.myPackageOrClassLabel, "Class:", 'C');
            this.myPackageOrClassLabel.setLabelFor(this.myClassField.getChildComponent());
            this.myMethodPanel.setVisible(true);
            this.myMainClassFilter.setAllowSuite(false);
            this.myClassField.setVisible(true);
            this.myClassField.invalidateHighlight();
            this.myPackageField.setVisible(false);
        }
    }

    private static void setText(JLabel label, String text, char mnemonic) {
        label.setText(text);
        label.setDisplayedMnemonic(mnemonic);
    }

    public void updateOnBCChange(@Nullable FlexBuildConfiguration bc, Module module) {
        if (bc == null) {
            this.updateOnError(FlexBundle.message("bc.not.specified", new Object[0]));
            return;
        }
        FlexUnitSupport support = FlexUnitSupport.getSupport(bc, module);
        if (support == null) {
            this.updateOnError(FlexBundle.message("flexunit.not.found.for.bc", bc.getName()));
            return;
        }
        this.updateControls(GlobalSearchScope.moduleScope((Module)module), support);
    }

    private void updateControls(@NotNull GlobalSearchScope scope, @NotNull FlexUnitSupport support) {
        if (scope == null) {
            WhatToTestForm.$$$reportNull$$$0(0);
        }
        if (support == null) {
            WhatToTestForm.$$$reportNull$$$0(1);
        }
        this.myClassField.setScope(scope);
        this.myMainClassFilter.setSupport(support);
        this.myClassField.setChooserBlockingMessage(null);
        this.myPackageField.setScope(scope);
        this.myPackageField.setChooserBlockingMessage(null);
    }

    public void updateOnError(String message) {
        this.myClassField.setScope(GlobalSearchScope.EMPTY_SCOPE);
        this.myMainClassFilter.setSupport(null);
        this.myClassField.setChooserBlockingMessage(message);
        this.myPackageField.setScope(GlobalSearchScope.EMPTY_SCOPE);
        this.myPackageField.setChooserBlockingMessage(message);
    }

    public void resetFrom(@Nullable Module module, @Nullable FlexBuildConfiguration bc, FlexUnitRunnerParameters params) {
        switch (params.getScope()) {
            case Class: {
                this.myClassRadioButton.setSelected(true);
                this.myClassField.setText(params.getClassName());
                this.myPackageField.setText("");
                break;
            }
            case Method: {
                this.myMethodRadioButton.setSelected(true);
                this.myClassField.setText(params.getClassName());
                this.myPackageField.setText("");
                this.myMethodField.setText(params.getMethodName());
                break;
            }
            case Package: {
                this.myPackageRadioButton.setSelected(true);
                this.myClassField.setText("");
                this.myPackageField.setText(params.getPackageName());
                break;
            }
            default: {
                assert (false) : "Unknown scope: " + (Object)((Object)params.getScope());
                break;
            }
        }
        this.updateOnBCChange(bc, module);
        this.updateOnScopeChange();
    }

    public void applyTo(FlexUnitRunnerParameters params) {
        if (this.myClassRadioButton.isSelected()) {
            params.setScope(FlexUnitRunnerParameters.Scope.Class);
            params.setClassName(this.myClassField.getText());
        } else if (this.myPackageRadioButton.isSelected()) {
            params.setScope(FlexUnitRunnerParameters.Scope.Package);
            params.setPackageName(this.myPackageField.getText());
        } else if (this.myMethodRadioButton.isSelected()) {
            params.setScope(FlexUnitRunnerParameters.Scope.Method);
            params.setClassName(this.myClassField.getText());
            params.setMethodName(this.myMethodField.getText());
        }
    }

    public void dispose() {
        this.myPackageRadioButton = null;
        this.myClassRadioButton = null;
        this.myMethodRadioButton = null;
        this.myPackageOrClassLabel = null;
        this.myClassField = null;
        this.myPackageField = null;
        this.myMethodPanel = null;
        this.myMethodField = null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "scope";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "support";
                break;
            }
        }
        objectArray[1] = "com/intellij/lang/javascript/flex/flexunit/WhatToTestForm";
        objectArray[2] = "updateControls";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        TextFieldWithBrowseButton.NoPathCompletion noPathCompletion;
        JPanel jPanel;
        JLabel jLabel;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JRadioButton jRadioButton3;
        JPanel jPanel2;
        this.createUIComponents();
        this.myMainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Test:");
        jPanel2.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myClassRadioButton = jRadioButton3 = new JRadioButton();
        jRadioButton3.setText("Class or suite");
        jRadioButton3.setMnemonic('L');
        jRadioButton3.setDisplayedMnemonicIndex(1);
        jPanel3.add((Component)jRadioButton3, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myPackageRadioButton = jRadioButton2 = new JRadioButton();
        jRadioButton2.setText("All in Package");
        jRadioButton2.setMnemonic('P');
        jRadioButton2.setDisplayedMnemonicIndex(7);
        jPanel3.add((Component)jRadioButton2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myMethodRadioButton = jRadioButton = new JRadioButton();
        jRadioButton.setText("Method");
        jRadioButton.setMnemonic('T');
        jRadioButton.setDisplayedMnemonicIndex(2);
        jPanel3.add((Component)jRadioButton, new GridConstraints(0, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myPackageOrClassLabel = jLabel = new JLabel();
        jLabel.setText("Package:");
        jLabel.setDisplayedMnemonic('G');
        jLabel.setDisplayedMnemonicIndex(5);
        jPanel2.add((Component)jLabel, new GridConstraints(1, 0, 2, 1, 8, 0, 0, 0, null, null, null));
        JSReferenceEditor jSReferenceEditor = this.myPackageField;
        jPanel2.add((Component)jSReferenceEditor, new GridConstraints(1, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        JSReferenceEditor jSReferenceEditor2 = this.myClassField;
        jPanel2.add((Component)jSReferenceEditor2, new GridConstraints(2, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        this.myMethodPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Method:");
        jLabel3.setDisplayedMnemonic('O');
        jLabel3.setDisplayedMnemonicIndex(4);
        jPanel.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myMethodField = noPathCompletion = new TextFieldWithBrowseButton.NoPathCompletion();
        jPanel.add((Component)noPathCompletion, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton3);
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private static class TestClassFilter
    implements Condition<JSClass> {
        @NotNull
        private final Project myProject;
        @Nullable
        private FlexUnitSupport mySupport;
        private boolean myAllowSuite;
        private Condition<JSClass> myCondition;

        TestClassFilter(@NotNull Project project) {
            if (project == null) {
                TestClassFilter.$$$reportNull$$$0(0);
            }
            this.myProject = project;
            this.setSupport(null);
            this.setAllowSuite(false);
        }

        private synchronized Condition<JSClass> getCondition() {
            if (DumbService.getInstance((Project)this.myProject).isDumb() || this.mySupport == null) {
                return Conditions.alwaysFalse();
            }
            if (this.myCondition == null) {
                this.myCondition = Conditions.cached(jsClass -> {
                    assert (this.mySupport != null);
                    return this.mySupport.isTestClass((JSClass)jsClass, this.myAllowSuite);
                });
            }
            return this.myCondition;
        }

        public synchronized void setSupport(@Nullable FlexUnitSupport support) {
            this.mySupport = support;
            this.myCondition = null;
        }

        public synchronized void setAllowSuite(boolean allowSuite) {
            this.myAllowSuite = allowSuite;
            this.myCondition = null;
        }

        public boolean value(JSClass jsClass) {
            return this.getCondition().value((Object)jsClass);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/flex/flexunit/WhatToTestForm$TestClassFilter", "<init>"));
        }
    }

    private class MethodChooserActionListener
    extends BrowseModuleValueActionListener {
        protected MethodChooserActionListener(Project project) {
            super(project);
            this.setField((ComponentWithBrowseButton)WhatToTestForm.this.myMethodField);
        }

        protected String showDialog() {
            FlexUnitSupport support;
            Module module;
            if (StringUtil.isEmpty((String)WhatToTestForm.this.myClassField.getText())) {
                Messages.showInfoMessage((Project)this.getProject(), (String)ExecutionBundle.message((String)"set.class.name.message", (Object[])new Object[0]), (String)ExecutionBundle.message((String)"choose.test.method.dialog.title", (Object[])new Object[0]));
                return null;
            }
            try {
                module = (Module)WhatToTestForm.this.myModuleComputable.compute();
                support = (FlexUnitSupport)WhatToTestForm.this.myFlexUnitSupportComputable.compute();
            }
            catch (RuntimeConfigurationError e) {
                Messages.showErrorDialog((Project)this.getProject(), (String)e.getMessage(), (String)ExecutionBundle.message((String)"choose.test.method.dialog.title", (Object[])new Object[0]));
                return null;
            }
            PsiElement clazz = ActionScriptClassResolver.findClassByQNameStatic(WhatToTestForm.this.myClassField.getText(), GlobalSearchScope.moduleScope((Module)module));
            if (!(clazz instanceof JSClass)) {
                Messages.showErrorDialog((Project)this.getProject(), (String)FlexBundle.message("class.not.found", WhatToTestForm.this.myClassField.getText()), (String)ExecutionBundle.message((String)"choose.test.method.dialog.title", (Object[])new Object[0]));
                return null;
            }
            FlexMethodChooserDialog dialog = new FlexMethodChooserDialog((JSClass)clazz, (Condition<JSFunction>)((Condition)jsFunction -> support.isTestMethod((JSFunction)jsFunction)), WhatToTestForm.this.myMainPanel, WhatToTestForm.this.myMethodField.getText());
            if (dialog.showAndGet()) {
                JSFunction method = dialog.getSelectedMethod();
                return method != null ? method.getName() : null;
            }
            return null;
        }
    }
}

