/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.flexunit.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.flex.FlexBundle;
import com.intellij.lang.javascript.flex.flexunit.FlexUnitSupport;
import com.intellij.lang.javascript.flex.flexunit.inspections.FlexUnitMethodInspectionBase;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSRecursiveElementVisitor;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.types.primitives.JSVoidType;
import com.intellij.lang.javascript.validation.fixes.ChangeTypeFix;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class FlexUnitMethodReturnTypeInspection
extends FlexUnitMethodInspectionBase {
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = FlexBundle.message("flexunit.inspection.testmethodreturntype.displayname", new Object[0]);
        if (string == null) {
            FlexUnitMethodReturnTypeInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if ("FlexUnitMethodReturnTypeInspection" == null) {
            FlexUnitMethodReturnTypeInspection.$$$reportNull$$$0(1);
        }
        return "FlexUnitMethodReturnTypeInspection";
    }

    @Override
    protected void visitPotentialTestMethod(JSFunction method, ProblemsHolder holder, FlexUnitSupport support) {
        ASTNode nameIdentifier;
        if (FlexUnitSupport.getCustomRunner((JSClass)method.getParent()) != null) {
            return;
        }
        if (method.getKind() != JSFunction.FunctionKind.SIMPLE) {
            return;
        }
        if (support.isFlexUnit1Subclass((JSClass)method.getParent()) || support.isFlunitSubclass((JSClass)method.getParent())) {
            return;
        }
        JSType returnType = method.getReturnType();
        if (returnType != null && !(returnType instanceof JSVoidType) && (nameIdentifier = method.findNameIdentifier()) != null) {
            LocalQuickFix[] localQuickFixArray;
            if (FlexUnitMethodReturnTypeInspection.canFix(method)) {
                LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
                localQuickFixArray = localQuickFixArray2;
                localQuickFixArray2[0] = new ChangeTypeFix((JSNamedElement)method, "void", "javascript.fix.set.method.return.type");
            } else {
                localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
            }
            LocalQuickFix[] fix = localQuickFixArray;
            holder.registerProblem(nameIdentifier.getPsi(), FlexBundle.message("flexunit.inspection.testmethodreturntype.message", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, fix);
        }
    }

    private static boolean canFix(JSFunction method) {
        NonVoidReturnVisitor visitor = new NonVoidReturnVisitor(method);
        method.acceptChildren((PsiElementVisitor)visitor);
        return !visitor.hasNonVoidReturns();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/lang/javascript/flex/flexunit/inspections/FlexUnitMethodReturnTypeInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class NonVoidReturnVisitor
    extends JSRecursiveElementVisitor {
        private final JSFunction myFunction;
        private boolean myHasNonVoidReturns = false;

        NonVoidReturnVisitor(JSFunction myFunction) {
            this.myFunction = myFunction;
        }

        public void visitJSReturnStatement(JSReturnStatement statement) {
            JSFunction containingFunction;
            super.visitJSReturnStatement(statement);
            if (statement.getExpression() != null && this.myFunction.equals(containingFunction = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)statement, JSFunction.class))) {
                this.myHasNonVoidReturns = true;
            }
        }

        public void visitJSFunctionDeclaration(JSFunction function) {
        }

        public boolean hasNonVoidReturns() {
            return this.myHasNonVoidReturns;
        }
    }
}

