/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.importer;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.zip.InflaterInputStream;
import org.jetbrains.annotations.NotNull;

class ByteBuffer {
    private byte[] bytes;
    private int position;
    private boolean littleEndian;

    ByteBuffer() {
    }

    void read(@NotNull InputStream inputStream) throws IOException {
        if (inputStream == null) {
            ByteBuffer.$$$reportNull$$$0(0);
        }
        try {
            this.bytes = ByteBuffer.readStream(inputStream);
        }
        finally {
            inputStream.close();
        }
    }

    void setLittleEndian() {
        this.littleEndian = true;
    }

    int readInt() {
        int result = this.littleEndian ? (((this.bytes[this.position + 3] & 0xFF) << 8 | this.bytes[this.position + 2] & 0xFF) << 16) + ((this.bytes[this.position + 1] & 0xFF) << 8) | this.bytes[this.position] & 0xFF : (((this.bytes[this.position] & 0xFF) << 8 | this.bytes[this.position + 1] & 0xFF) << 16) + ((this.bytes[this.position + 2] & 0xFF) << 8) | this.bytes[this.position + 3] & 0xFF;
        this.position += 4;
        return result;
    }

    public int readUnsignedInt() {
        return this.readInt();
    }

    public void setPosition(int i) {
        this.position = i;
    }

    public int bytesSize() {
        return this.bytes.length;
    }

    public void uncompress() throws IOException {
        InflaterInputStream zipInputStream = new InflaterInputStream(new ByteArrayInputStream(this.bytes));
        this.bytes = ByteBuffer.readStream(zipInputStream);
        zipInputStream.close();
    }

    private static byte[] readStream(InputStream zipInputStream) throws IOException {
        int read;
        byte[] buf = new byte[8192];
        byte[] result = new byte[8192];
        int total = 0;
        while ((read = zipInputStream.read(buf)) != -1) {
            if (total + read >= result.length) {
                byte[] newresult = new byte[result.length * 2];
                System.arraycopy(result, 0, newresult, 0, total);
                result = newresult;
            }
            System.arraycopy(buf, 0, result, total, read);
            total += read;
        }
        byte[] realResult = new byte[total];
        System.arraycopy(result, 0, realResult, 0, total);
        return realResult;
    }

    public int readUnsignedByte() {
        return this.bytes[this.position++] & 0xFF;
    }

    public int readByte() {
        return this.bytes[this.position++];
    }

    public int readUnsignedShort() {
        int result = this.littleEndian ? (this.bytes[this.position + 1] & 0xFF) << 8 | this.bytes[this.position] & 0xFF : (this.bytes[this.position] & 0xFF) << 8 | this.bytes[this.position + 1] & 0xFF;
        this.position += 2;
        return result;
    }

    public void readBytes(ByteBuffer data2, int length) {
        data2.bytes = new byte[length];
        System.arraycopy(this.bytes, this.position, data2.bytes, 0, length);
        this.position += length;
    }

    public boolean eof() {
        return this.position >= this.bytes.length;
    }

    public String readUTFBytes(int i) {
        byte[] buf = new byte[i];
        while (i > 0) {
            buf[buf.length - i] = (byte)this.readByte();
            --i;
        }
        return new String(buf, StandardCharsets.UTF_8);
    }

    public double readDouble() {
        int first = this.readInt();
        int second = this.readInt();
        return Double.longBitsToDouble((long)second << 32 | (long)first);
    }

    public int readU32() {
        int result = this.readUnsignedByte();
        if ((result & 0x80) == 0) {
            return result;
        }
        if (((result = result & 0x7F | this.readUnsignedByte() << 7) & 0x4000) == 0) {
            return result;
        }
        if (((result = result & 0x3FFF | this.readUnsignedByte() << 14) & 0x200000) == 0) {
            return result;
        }
        if (((result = result & 0x1FFFFF | this.readUnsignedByte() << 21) & 0x10000000) == 0) {
            return result;
        }
        return result & 0xFFFFFFF | this.readUnsignedByte() << 28;
    }

    public byte getByte(int i) {
        return this.bytes[i];
    }

    public int getPosition() {
        return this.position;
    }

    public void incPosition(int length) {
        this.position += length;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputStream", "com/intellij/lang/javascript/flex/importer/ByteBuffer", "read"));
    }
}

