/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.importer;

import com.intellij.lang.javascript.flex.importer.AS3InterfaceDumper;
import com.intellij.lang.javascript.flex.importer.AS3InterfaceStubDumper;
import com.intellij.lang.javascript.flex.importer.Abc;
import com.intellij.lang.javascript.flex.importer.AbcDumper;
import com.intellij.lang.javascript.flex.importer.ByteBuffer;
import com.intellij.lang.javascript.flex.importer.FlexByteCodeInformationProcessor;
import com.intellij.lang.javascript.flex.importer.Swf;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.stubs.StubElement;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class FlexImporter {
    private static final int ABC_VER = 0x2E000E;
    private static final int ABC_VER2 = 3014671;
    private static final int ABC_VER3 = 3014672;
    private static final int SWF_MAGIC = 5461827;
    private static final int SWF_MAGIC2 = 5461830;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        if (args.length < 1) {
            System.out.print("FlexImporter\nusage:\nFlexImporter <filename>");
        } else {
            long started = System.currentTimeMillis();
            for (String file : args) {
                try {
                    String result = FlexImporter.dumpContentsFromStream(new BufferedInputStream(new FileInputStream(file)), true);
                    FlexImporter.saveStringAsFile(result, file + ".il");
                }
                finally {
                    long total = System.currentTimeMillis() - started;
                    System.out.println("File created... " + total + "ms");
                }
            }
        }
    }

    private static void saveStringAsFile(String result, String fileName) throws IOException {
        FileUtil.writeToFile((File)new File(fileName), (String)result);
    }

    public static String dumpContentsFromStream(InputStream in, boolean _dumpCode) throws IOException {
        AbcDumper abcDumper = new AbcDumper(_dumpCode);
        FlexImporter.processFlexByteCode(in, abcDumper);
        return abcDumper.getResult();
    }

    @NonNls
    public static String buildInterfaceFromStream(InputStream in) {
        try {
            AS3InterfaceDumper abcDumper = new AS3InterfaceDumper();
            FlexImporter.processFlexByteCode(in, abcDumper);
            String s = abcDumper.getResult();
            return s;
        }
        catch (IOException ex) {
            return "/* " + ex.getLocalizedMessage() + " */";
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            return "/* Invalid format */";
        }
    }

    @NonNls
    public static void buildStubsInterfaceFromStream(InputStream in, StubElement parent) throws Exception {
        FlexImporter.processFlexByteCode(in, new AS3InterfaceStubDumper(parent));
    }

    private static void processFlexByteCode(@NotNull InputStream in, @NotNull FlexByteCodeInformationProcessor processor) throws IOException {
        if (in == null) {
            FlexImporter.$$$reportNull$$$0(0);
        }
        if (processor == null) {
            FlexImporter.$$$reportNull$$$0(1);
        }
        ByteBuffer data = new ByteBuffer();
        data.read(in);
        data.setLittleEndian();
        if (data.bytesSize() == 0) {
            return;
        }
        int version = data.readUnsignedInt();
        if (version == 0x2E000E || version == 3014671 || version == 3014672) {
            Abc abc = new Abc(data, processor);
            abc.dump("");
        } else if ((version & 0x535743) == 5461827) {
            int delta = 8;
            data.setPosition(8);
            ByteBuffer udata = new ByteBuffer();
            udata.setLittleEndian();
            data.readBytes(udata, data.bytesSize() - 8);
            int csize = udata.bytesSize();
            udata.uncompress();
            processor.dumpStat("decompressed swf " + csize + " -> " + udata.bytesSize() + "\n");
            udata.setPosition(0);
            new Swf(udata, processor);
        } else if ((version & 0x535746) == 5461830) {
            data.setPosition(8);
            new Swf(data, processor);
        } else {
            processor.hasError("unknown format " + version + ", swf version: " + (version >> 24) + "\n");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "in";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "processor";
                break;
            }
        }
        objectArray[1] = "com/intellij/lang/javascript/flex/importer/FlexImporter";
        objectArray[2] = "processFlexByteCode";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

