/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.importer;

import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.flex.importer.AS3InterfaceDumper;
import com.intellij.lang.javascript.flex.importer.Abc;
import com.intellij.lang.javascript.flex.importer.MemberInfo;
import com.intellij.lang.javascript.flex.importer.SlotInfo;
import com.intellij.lang.javascript.flex.importer.Traits;
import com.intellij.util.containers.BidirectionalMap;
import gnu.trove.THashMap;
import java.util.Map;
import java.util.Set;

class Multiname {
    private static final String PUBLIC_NS_IN_SOURCE = "public";
    private static final String AS3_VEC = "__AS3__.vec";
    String[] nsset;
    String name;
    private static final Map<String, String> predefined = new THashMap();

    Multiname(String[] nsset, String name) {
        this.nsset = nsset;
        this.name = name;
    }

    public String toString() {
        String s = "";
        if (this.hasNotEmptyNs()) {
            s = s + this.nsset[0] + "::";
        }
        s = s + this.name;
        return s;
    }

    boolean hasNotEmptyNs() {
        return this.nsset != null && this.nsset.length > 0 && this.nsset[0] != null && this.nsset[0].length() > 0;
    }

    public boolean hasNamespace() {
        return this.hasNotEmptyNs() && Multiname.hasNamespace(this.nsset[0]);
    }

    public static boolean hasNamespace(String ns) {
        return ns.equals("private") || ns.equals(AS3_VEC) || ns.indexOf(36) != -1 || ns.indexOf(58) != -1;
    }

    private static String makeNsIdentifier(String ns, Traits parentTraits) {
        String s;
        String prefix;
        String predefinedName = predefined.get(ns);
        if (predefinedName != null) {
            prefix = predefinedName;
        } else {
            int i2;
            int i = ns.lastIndexOf(47);
            if (i != -1) {
                i2 = ns.lastIndexOf(47, i - 1);
                if (i2 != -1) {
                    i = i2;
                }
            } else {
                i = ns.lastIndexOf(46);
                if (i != -1 && (i2 = ns.lastIndexOf(46, i - 1)) != -1) {
                    i = i2;
                }
            }
            prefix = i != -1 ? Multiname.makeIdentifier(ns.substring(i + 1)) : "ns";
        }
        int nsCount = 1;
        while (parentTraits.names.containsKey(s = prefix + (nsCount++ == 1 ? "" : Integer.valueOf(nsCount)))) {
        }
        parentTraits.names.put(ns, null);
        return s;
    }

    public String getNsName(MemberInfo mi) {
        String varName;
        Object parentName;
        String ns = this.nsset[0];
        if (ns.length() == 0) {
            return PUBLIC_NS_IN_SOURCE;
        }
        if ("private".equals(ns)) {
            return ns;
        }
        if (mi.parentTraits.name == mi.name) {
            return PUBLIC_NS_IN_SOURCE;
        }
        Traits parentTraits = mi.parentTraits;
        if (ns.equals(parentTraits.protectedNs) || parentTraits.itraits != null && ns.equals(parentTraits.itraits.protectedNs)) {
            return "protected";
        }
        if (parentTraits.name instanceof Multiname) {
            parentName = (Multiname)parentTraits.name;
            String parentNs = ((Multiname)parentName).nsset[0];
            if (parentNs.equals(ns)) {
                return "internal";
            }
            int i = ns.indexOf(58);
            if (i != -1 && ns.regionMatches(0, parentNs, 0, parentNs.length()) && ns.regionMatches(parentNs.length() + 1, ((Multiname)parentName).name, 0, ((Multiname)parentName).name.length()) && ns.charAt(parentNs.length()) == ':' && ns.length() == parentNs.length() + ((Multiname)parentName).name.length() + 1) {
                return "";
            }
            if (i == -1 && ns.equals(((Multiname)parentName).name) && parentNs.length() == 0) {
                return "";
            }
        } else if (parentTraits.name instanceof String) {
            parentName = (String)parentTraits.name;
            if (((String)parentName).startsWith("script")) {
                String predefinedNs;
                if (mi.kind == Abc.TraitType.Const) {
                    SlotInfo slotInfo = (SlotInfo)mi;
                    if (slotInfo.type.isStarReference() && slotInfo.value instanceof String) {
                        return PUBLIC_NS_IN_SOURCE;
                    }
                }
                if ((predefinedNs = predefined.get(ns)) != null) {
                    return predefinedNs;
                }
                return PUBLIC_NS_IN_SOURCE;
            }
            if (ns.regionMatches(0, (String)parentName, 0, ns.length()) && ns.length() < ((String)parentName).length() && ((String)parentName).charAt(ns.length()) == ':') {
                return "internal";
            }
        }
        if (parentTraits.staticTrait != null) {
            parentTraits = parentTraits.staticTrait;
        }
        if (parentTraits.usedNamespacesToNamesMap == null) {
            parentTraits.usedNamespacesToNamesMap = new BidirectionalMap();
        }
        if ((varName = (String)parentTraits.usedNamespacesToNamesMap.get((Object)ns)) == null) {
            varName = Multiname.makeNsIdentifier(ns, parentTraits);
            parentTraits.usedNamespacesToNamesMap.put((Object)ns, (Object)varName);
        }
        return varName;
    }

    public String getValidNsName(Set<String> classNameTable) {
        int nsIndex = 0;
        if (this.nsset.length > 1) {
            for (int i = 0; i < this.nsset.length; ++i) {
                String ns = this.nsset[i];
                if (ns.equals("") || ns.equals("private") || !classNameTable.contains(ns + ":" + this.name)) continue;
                nsIndex = i;
                break;
            }
        }
        return this.nsset[nsIndex];
    }

    private static String makeIdentifier(String s) {
        StringBuilder builder = new StringBuilder(s.length());
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (!Character.isJavaIdentifierPart(ch)) {
                ch = '_';
            }
            builder.append(ch);
        }
        String s2 = builder.toString();
        if (JSTokenTypes.IDENTIFIER != AS3InterfaceDumper.identifierType(s2)) {
            s2 = "_" + s2;
        }
        return s2;
    }

    public boolean isStarReference() {
        return "*".equals(this.name);
    }

    static {
        predefined.put("http://adobe.com/AS3/2006/builtin", "AS3");
        predefined.put("http://www.adobe.com/2006/flex/mx/internal", "mx_internal");
        predefined.put(AS3_VEC, "__AS3__$vec");
        predefined.put("http://www.adobe.com/2008/actionscript/Flash10/", "flash10");
        predefined.put("http://www.adobe.com/2006/actionscript/flash/objectproxy", "object_proxy");
        predefined.put("http://www.adobe.com/2006/actionscript/flash/proxy", "flash_proxy");
    }
}

